package com.hyprmx.android.sdk.utility

import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import com.hyprmx.android.sdk.core.js.JSEngine

internal class DefaultConsoleLog(jsEngine: JSEngine) : ConsoleLogJSInterface {

  init {
    jsEngine.addJavascriptInterface(this, JS_INTERFACE_NAME)
  }

  @RetainMethodSignature
  override fun log(message: String) {
    HyprMXLog.i(TAG, message)
  }

  @RetainMethodSignature
  override fun warn(message: String) {
    HyprMXLog.w(TAG, message)
  }

  @RetainMethodSignature
  override fun debug(message: String) {
    HyprMXLog.longDebugLog(TAG, message)
  }

  @RetainMethodSignature
  override fun error(message: String) {
    HyprMXLog.e(TAG, message)
  }

  @RetainMethodSignature
  override fun messages(): String {
    return HyprMXLog.loggedMessages
  }

  companion object {
    const val TAG = "HyprMXCore"
    const val JS_INTERFACE_NAME = "console"
  }
}

internal interface ConsoleLogJSInterface {
  @RetainMethodSignature
  fun log(message: String)

  @RetainMethodSignature
  fun warn(message: String)

  @RetainMethodSignature
  fun debug(message: String)

  @RetainMethodSignature
  fun error(message: String)

  @RetainMethodSignature
  fun messages(): String
}
