package com.hyprmx.android.sdk.utility

import android.annotation.TargetApi
import android.os.Build
import com.hyprmx.android.sdk.webview.HyprMXWebViewContract
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

internal interface CustomEventHandler {
  suspend fun sendCustomEvent(event: String, detail: String)
}

internal class DefaultWebViewCustomEventHandler(val webView: HyprMXWebViewContract.InternalView) : CustomEventHandler {
  @TargetApi(Build.VERSION_CODES.LOLLIPOP)
  override suspend fun sendCustomEvent(event: String, detail: String) =
    withContext(Dispatchers.Main) {
      sendCustomEvent(webView, event, detail)
    }
}

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
internal suspend fun sendCustomEvent(webView: HyprMXWebViewContract.InternalView, event: String, detail: String) =
  withContext(Dispatchers.Main) {
    webView.executeJS(
      "window.dispatchEvent(new CustomEvent('$event', { detail: '$detail' }));",
    )
  }
