package com.hyprmx.android.sdk.utility

import androidx.annotation.Keep
import com.hyprmx.android.BuildConfig

@Keep
object HyprMXProperties {

  var baseUrl = BuildConfig.baseUrlHttps

  fun resetBaseUrlToDefault() {
    baseUrl = BuildConfig.baseUrlHttps
  }

  const val version: String = BuildConfig.HYPRMX_VERSION
  const val buildNumber: Int = BuildConfig.HYPRMX_BUILD_NUMBER

  @Deprecated(
    message = "No longer being used as of 5.1.0",
    level = DeprecationLevel.WARNING,
    replaceWith = ReplaceWith("HyprMXProperties.buildNumber"),
  )
  const val number = buildNumber
}
