package com.hyprmx.android.sdk.utility

import android.app.Activity
import android.app.AlertDialog

interface InternetConnectionDialog {
  fun showInternetConnectionErrorDialog(activity: Activity, onClickAction: () -> Unit)
  fun dismissInternetConnectionErrorDialog()
  fun isInternetConnectionErrorDialogShowing(): Boolean
}

class DefaultInternetConnectionDialog : InternetConnectionDialog {

  private var internetConnectionErrorDialog: AlertDialog? = null

  override fun showInternetConnectionErrorDialog(activity: Activity, onClickAction: () -> Unit) {
    val errorMsg = Utils.getActivityNetworkErrorMsg(activity)

    val clickListener = DetachableClickListener.wrap { dialog, _ ->
      if (internetConnectionErrorDialog?.isShowing == true) {
        dialog.dismiss()
      }
      dialog.dismiss()
      onClickAction()
    }

    internetConnectionErrorDialog = AlertDialog.Builder(activity)
      .setMessage(errorMsg)
      .setNegativeButton(activity.getString(android.R.string.ok), clickListener)
      .setCancelable(false)
      .create().apply {
        setCanceledOnTouchOutside(false)
        if (!activity.isFinishing) {
          show()
        }
        clickListener.clearOnDetach(this)
      }
  }

  override fun dismissInternetConnectionErrorDialog() {
    internetConnectionErrorDialog?.dismiss()
  }

  override fun isInternetConnectionErrorDialogShowing(): Boolean =
    internetConnectionErrorDialog?.isShowing ?: false
}
