package com.hyprmx.android.sdk.utility

import org.json.JSONObject

/** Return the value mapped by the given key, or {@code null} if not present or null. */
fun JSONObject.getStringOrNull(key: String): String? {
  // http://code.google.com/p/android/issues/detail?id=13830
  return if (isNull(key)) {
    null
  } else {
    getString(key)
  }
}
