package com.hyprmx.android.sdk.utility

import android.content.Context

/**
 * Interface for storing images to external storage from an external url
 */
internal interface StorePictureManager {

  /**
   * Request a picture to be downloaded and stored to disk
   *
   * @return On successful result, the result will contain the path to the stored file.  On failure, will return the FailureCode and appropriate message
   */
  suspend fun storePicture(url: String, context: Context): Result<String>

  enum class FailureCode(val code: Int) {
    INVALID_URI(0),
    FAILED_TO_DECODE(1),
    FAILED_TO_STORE_TO_DISK(2),
    FAILED_TO_STORE_TO_DOWNLOAD(3),
  }
}
