package com.hyprmx.android.sdk.webview

import com.hyprmx.android.sdk.utility.HyprMXLog
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_ALPHA
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_BACKGROUND_COLOR
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_BOUNCE
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_BUILT_IN_ZOOM_CONTROLS
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_CUSTOM_USER_AGENT
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_DOM_STORAGE
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_JS_ENABLED
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_LINK_PREVIEW
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_MULTIWINDOW
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_OVERVIEW_MODE
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_PINCH
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_PLAYBACK_REQUIRES_USER_GESTURE
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_SCROLLABLE
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_WIDE_VIEWPORT
import com.hyprmx.android.sdk.webview.WebViewEvents.Companion.UPDATE_WEBVIEW_CONFIG_ARG_ZOOM_CONTROLS
import org.json.JSONObject

data class WebViewConfigUpdate(
  val scrollable: Boolean,
  val bounceEnable: Boolean,
  val allowPinchGesture: Boolean,
  val linkPreview: Boolean,
  val javascriptEnabled: Boolean,
  val domStorageEnabled: Boolean,
  val loadWithOverviewMode: Boolean,
  val useWideViewPort: Boolean,
  val displayZoomControls: Boolean,
  val builtInZoomControls: Boolean,
  val supportMultiWindow: Boolean,
  val backgroundColor: String,
  val customUserAgent: String,
  val playbackRequiresUserAction: Boolean,
)

internal fun createWebViewConfigEvent(data: String): WebViewConfigUpdate? {
  try {
    val jsonObject = JSONObject(data)
    val scrollable = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_SCROLLABLE)
    val bounce = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_BOUNCE)
    val pinch = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_PINCH)
    val linkPreview = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_LINK_PREVIEW)
    val jsEnabled = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_JS_ENABLED)
    val domStorage = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_DOM_STORAGE)
    val overviewMode = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_OVERVIEW_MODE)
    val wideViewPort = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_WIDE_VIEWPORT)
    val zoomControls = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_ZOOM_CONTROLS)
    val builtInZoomControls = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_BUILT_IN_ZOOM_CONTROLS)
    val multiWindow = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_MULTIWINDOW)
    val backgroundColor = jsonObject.getString(UPDATE_WEBVIEW_CONFIG_ARG_ALPHA) + jsonObject.getString(UPDATE_WEBVIEW_CONFIG_ARG_BACKGROUND_COLOR)
    val customUserAgent = jsonObject.getString(UPDATE_WEBVIEW_CONFIG_ARG_CUSTOM_USER_AGENT)
    val requireUserGestureForPlayback = jsonObject.getBoolean(UPDATE_WEBVIEW_CONFIG_ARG_PLAYBACK_REQUIRES_USER_GESTURE)

    return WebViewConfigUpdate(
      scrollable = scrollable,
      bounceEnable = bounce,
      allowPinchGesture = pinch,
      linkPreview = linkPreview,
      javascriptEnabled = jsEnabled,
      domStorageEnabled = domStorage,
      loadWithOverviewMode = overviewMode,
      useWideViewPort = wideViewPort,
      displayZoomControls = zoomControls,
      builtInZoomControls = builtInZoomControls,
      supportMultiWindow = multiWindow,
      backgroundColor = backgroundColor,
      customUserAgent = customUserAgent,
      playbackRequiresUserAction = requireUserGestureForPlayback,
    )
  } catch (exception: Exception) {
    HyprMXLog.e("Exception parsing config ${exception.localizedMessage}")
    return null
  }
}

internal interface WebViewEvents {
  companion object {
    const val PERMISSION_RESPONSE_ARG_PERMISSION_ID = "permissionId"
    const val PERMISSION_RESPONSE_ARG_PERMISSIONS = "permissions"
    const val PERMISSION_RESPONSE_ARG_PERMISSION = "permission"
    const val PERMISSION_RESPONSE_ARG_GRANTED = "granted"

    const val UPDATE_WEBVIEW_CONFIG_ARG_SCROLLABLE = "isWebViewScrollable"
    const val UPDATE_WEBVIEW_CONFIG_ARG_BOUNCE = "isWebViewScrollBounceEnabled"
    const val UPDATE_WEBVIEW_CONFIG_ARG_PINCH = "allowsPinchGesture"
    const val UPDATE_WEBVIEW_CONFIG_ARG_LINK_PREVIEW = "allowsLinkPreview"
    const val UPDATE_WEBVIEW_CONFIG_ARG_JS_ENABLED = "javaScriptEnabled"
    const val UPDATE_WEBVIEW_CONFIG_ARG_DOM_STORAGE = "domStorageEnabled"
    const val UPDATE_WEBVIEW_CONFIG_ARG_OVERVIEW_MODE = "loadWithOverviewMode"
    const val UPDATE_WEBVIEW_CONFIG_ARG_WIDE_VIEWPORT = "useWideViewPort"
    const val UPDATE_WEBVIEW_CONFIG_ARG_ZOOM_CONTROLS = "displayZoomControls"
    const val UPDATE_WEBVIEW_CONFIG_ARG_BUILT_IN_ZOOM_CONTROLS = "builtInZoomControls"
    const val UPDATE_WEBVIEW_CONFIG_ARG_MULTIWINDOW = "supportsMultipleWindows"
    const val UPDATE_WEBVIEW_CONFIG_ARG_ALPHA = "alpha"
    const val UPDATE_WEBVIEW_CONFIG_ARG_BACKGROUND_COLOR = "backgroundColor"
    const val UPDATE_WEBVIEW_CONFIG_ARG_CUSTOM_USER_AGENT = "customUserAgent"
    const val UPDATE_WEBVIEW_CONFIG_ARG_PLAYBACK_REQUIRES_USER_GESTURE = "playbackRequiresUserAction"
  }
}
