package com.hyprmx.android.sdk.webview

import android.content.Context
import com.hyprmx.android.sdk.preload.PreloadControllerIf

internal interface WebViewFactoryIf {
  fun createWebView(viewModelIdentifier: String, userAgent: String?): HyprMXWebView
}

internal class WebViewFactory(private val appContext: Context, private val preloadController: PreloadControllerIf) :
  WebViewFactoryIf {
  override fun createWebView(viewModelIdentifier: String, userAgent: String?): HyprMXWebView {
    return preloadController.getPreloadedWebView(viewModelIdentifier) ?: HyprMXWebView(
      context = appContext,
      userAgent = userAgent,
    )
  }
}
