package com.hyprmx.android.sdk.webview

import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import java.lang.ref.WeakReference

internal interface WebViewNativeInterface {
  @RetainMethodSignature
  fun setUrl(url: String)

  @RetainMethodSignature
  fun setAdHtml(data: String)

  @RetainMethodSignature
  fun setCatalogFramePost(data: String)

  @RetainMethodSignature
  fun postUrl(url: String, postParams: String)

  @RetainMethodSignature
  fun runScript(script: String)

  @RetainMethodSignature
  fun navigateBack()

  @RetainMethodSignature
  fun navigateForward()

  @RetainMethodSignature
  fun pauseJSExecution()

  @RetainMethodSignature
  fun resumeJSExecution()

  @RetainMethodSignature
  fun removeJavascriptInterface()

  @RetainMethodSignature
  fun addJavascriptInterface()

  @RetainMethodSignature
  fun imageCaptured(url: String)

  @RetainMethodSignature
  fun permissionResponse(data: String)

  @RetainMethodSignature
  fun updateWebViewConfiguration(data: String)
}

internal class WebViewPresenterAdapter(
  presenter: WebViewNativeInterface,
) :
  WebViewNativeInterface {
  val webViewPresenter: WeakReference<WebViewNativeInterface> = WeakReference(presenter)
  override fun setUrl(url: String) {
    webViewPresenter.get()?.setUrl(url)
  }

  override fun setAdHtml(data: String) {
    webViewPresenter.get()?.setAdHtml(data)
  }

  override fun setCatalogFramePost(data: String) {
    webViewPresenter.get()?.setCatalogFramePost(data)
  }

  override fun postUrl(url: String, postParams: String) {
    webViewPresenter.get()?.postUrl(url, postParams)
  }

  override fun runScript(script: String) {
    webViewPresenter.get()?.runScript(script)
  }

  override fun navigateBack() {
    webViewPresenter.get()?.navigateBack()
  }

  override fun navigateForward() {
    webViewPresenter.get()?.navigateForward()
  }

  override fun pauseJSExecution() {
    webViewPresenter.get()?.pauseJSExecution()
  }

  override fun resumeJSExecution() {
    webViewPresenter.get()?.resumeJSExecution()
  }

  override fun removeJavascriptInterface() {
    webViewPresenter.get()?.removeJavascriptInterface()
  }

  override fun addJavascriptInterface() {
    webViewPresenter.get()?.addJavascriptInterface()
  }

  override fun imageCaptured(url: String) {
    webViewPresenter.get()?.imageCaptured(url)
  }

  override fun permissionResponse(data: String) {
    webViewPresenter.get()?.permissionResponse(data)
  }

  override fun updateWebViewConfiguration(data: String) {
    webViewPresenter.get()?.updateWebViewConfiguration(data)
  }
}
