/*
 * Decompiled with CFR 0.152.
 */
package com.inmobi.commons.core.configs;

import androidx.annotation.Keep;
import androidx.annotation.VisibleForTesting;
import com.inmobi.commons.core.configs.Config;
import com.inmobi.commons.utils.json.Constructor;
import com.inmobi.media.i4;
import com.inmobi.media.l2;
import com.inmobi.media.p6;
import com.inmobi.media.tb;
import com.inmobi.media.v9;
import com.inmobi.media.x4;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0004-./0B\u0011\u0012\b\u0010)\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0000H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0015R\u001e\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00050\u00058\u0002@\u0003X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001bR\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001e\u0010#\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u00061"}, d2={"Lcom/inmobi/commons/core/configs/RootConfig;", "Lcom/inmobi/commons/core/configs/Config;", "config", "", "isSameAs", "", "getType", "Lorg/json/JSONObject;", "toJson", "isValid", "type", "", "getExpiryForType", "", "getMaxRetries", "getRetryInterval", "getWaitTime", "isMonetizationDisabled", "shouldTransmitRequest", "getUrlForType", "getFallbackUrlForRootType", "Lcom/inmobi/commons/core/configs/RootConfig$LatestSdkInfo;", "getLatestSdkInfo", "kotlin.jvm.PlatformType", "TAG", "Ljava/lang/String;", "maxRetries", "I", "retryInterval", "waitTime", "Lcom/inmobi/commons/core/configs/RootConfig$GDPR;", "gdpr", "Lcom/inmobi/commons/core/configs/RootConfig$GDPR;", "", "Lcom/inmobi/commons/core/configs/RootConfig$ComponentConfig;", "components", "Ljava/util/List;", "latestSdkInfo", "Lcom/inmobi/commons/core/configs/RootConfig$LatestSdkInfo;", "monetizationDisabled", "Z", "accountId", "<init>", "(Ljava/lang/String;)V", "Companion", "a", "ComponentConfig", "GDPR", "LatestSdkInfo", "media_release"})
@Keep
public final class RootConfig
extends Config {
    @NotNull
    public static final a Companion = new a();
    public static final long DEFAULT_EXPIRY = 86400L;
    public static final int DEFAULT_MAX_RETRIES = 3;
    public static final int DEFAULT_RETRY_INTERVAL = 60;
    public static final int DEFAULT_WAIT_TIME = 3;
    @NotNull
    public static final String DEFAULT_URL = "";
    @NotNull
    public static final String DEFAULT_FALLBACK_URL = "https://config.inmobi.com/config-server/v1/config/secure.cfg";
    @NotNull
    private static final Object sAcquisitionLock = new Object();
    @x4
    private final String TAG;
    private int maxRetries = 3;
    private int retryInterval = 60;
    private int waitTime = 3;
    @v9
    @Nullable
    private GDPR gdpr = new GDPR();
    @Nullable
    private List<ComponentConfig> components = CollectionsKt.emptyList();
    @NotNull
    private LatestSdkInfo latestSdkInfo = new LatestSdkInfo();
    private boolean monetizationDisabled;

    public RootConfig(@Nullable String string) {
        super(string);
        this.TAG = "RootConfig";
    }

    public static final /* synthetic */ Object access$getSAcquisitionLock$cp() {
        return sAcquisitionLock;
    }

    @VisibleForTesting
    public final boolean isSameAs(@NotNull RootConfig rootConfig) {
        Intrinsics.checkNotNullParameter((Object)rootConfig, (String)"config");
        return (this.getAccountId$media_release() == null && rootConfig.getAccountId$media_release() == null || this.getAccountId$media_release() != null && StringsKt.equals$default((String)this.getAccountId$media_release(), (String)rootConfig.getAccountId$media_release(), (boolean)false, (int)2, null)) && rootConfig.maxRetries == this.maxRetries && rootConfig.retryInterval == this.retryInterval && rootConfig.waitTime == this.waitTime && rootConfig.monetizationDisabled == this.monetizationDisabled;
    }

    @Override
    @NotNull
    public String getType() {
        return "root";
    }

    @Override
    @NotNull
    public JSONObject toJson() {
        JSONObject jSONObject = Companion.a().a(this);
        if (jSONObject == null) {
            Intrinsics.checkNotNullExpressionValue((Object)this.TAG, (String)"TAG");
            return new JSONObject();
        }
        return jSONObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        RootConfig rootConfig = gDPR;
        Intrinsics.checkNotNullExpressionValue((Object)rootConfig.TAG, (String)"TAG");
        Intrinsics.stringPlus((String)"isValid ", (Object)rootConfig.gdpr);
        if (rootConfig.maxRetries < 0) return false;
        if (((RootConfig)((Object)gDPR)).retryInterval < 0) return false;
        if (((RootConfig)((Object)gDPR)).waitTime < 0) return false;
        if (!((RootConfig)((Object)gDPR)).latestSdkInfo.isValid()) {
            return false;
        }
        Object object = sAcquisitionLock;
        synchronized (object) {
            Object object2;
            block13: {
                block12: {
                    object2 = ((RootConfig)((Object)gDPR)).components;
                    if (object2 != null) break block12;
                    return false;
                }
                object2 = object2.iterator();
                while (true) {
                    if (!object2.hasNext()) break block13;
                    if (((ComponentConfig)object2.next()).isValid()) continue;
                    break;
                }
                return false;
            }
            object2 = Unit.INSTANCE;
            if (object2 == null) {
                return false;
            }
            RootConfig rootConfig2 = gDPR;
            Object object3 = object;
            GDPR gDPR = rootConfig2.gdpr;
            if (gDPR == null) {
                return false;
            }
            if (!gDPR.isValid()) return false;
            return true;
        }
    }

    public final long getExpiryForType(@NotNull String string) {
        RootConfig rootConfig = object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"type");
        Object object = sAcquisitionLock;
        synchronized (object) {
            Object object2;
            block10: {
                object2 = rootConfig.components;
                if (object2 != null) break block10;
            }
            try {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    ComponentConfig componentConfig = (ComponentConfig)object2.next();
                    if (!Intrinsics.areEqual((Object)string, (Object)componentConfig.getType())) continue;
                    return componentConfig.getExpiry();
                }
            }
            catch (Throwable throwable) {}
            finally {
                throw throwable;
            }
        }
    }

    public final int getMaxRetries() {
        return this.maxRetries;
    }

    public final int getRetryInterval() {
        return this.retryInterval;
    }

    public final int getWaitTime() {
        return this.waitTime;
    }

    public final boolean isMonetizationDisabled() {
        return this.monetizationDisabled;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean shouldTransmitRequest() {
        Object object = ((RootConfig)object).gdpr;
        if (object == null) return true;
        if ((object = ((GDPR)object).getTransmitRequest()) == null) return true;
        boolean bl = (Boolean)object;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final String getUrlForType(@NotNull String string) {
        RootConfig rootConfig = object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"type");
        Object object = sAcquisitionLock;
        synchronized (object) {
            Object object2 = rootConfig.components;
            if (object2 != null) {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    String string2 = string;
                    ComponentConfig componentConfig = (ComponentConfig)object2.next();
                    if (!Intrinsics.areEqual((Object)string2, (Object)componentConfig.getType())) continue;
                    return componentConfig.getUrl();
                }
            }
            return DEFAULT_URL;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final String getFallbackUrlForRootType() {
        RootConfig rootConfig = object;
        Object object = sAcquisitionLock;
        synchronized (object) {
            Object object2 = rootConfig.components;
            if (object2 != null) {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    ComponentConfig componentConfig = (ComponentConfig)object2.next();
                    if (!Intrinsics.areEqual((Object)"root", (Object)componentConfig.getType())) continue;
                    return componentConfig.getFallbackUrl();
                }
            }
            return DEFAULT_FALLBACK_URL;
        }
    }

    @NotNull
    public final LatestSdkInfo getLatestSdkInfo() {
        return this.latestSdkInfo;
    }

    public static final class a {
        @NotNull
        public final com.inmobi.commons.utils.json.a<RootConfig> a() {
            p6<ComponentConfig> p62;
            p6<ComponentConfig> p63 = p62;
            p62 = new p6<ComponentConfig>(new Constructor<List<? extends ComponentConfig>>(){

                @Override
                public Object construct() {
                    return new ArrayList();
                }
            }, ComponentConfig.class);
            return new com.inmobi.commons.utils.json.a().a(new tb("components", RootConfig.class), p63);
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0002J\u0006\u0010\u0007\u001a\u00020\u0002J\u0006\u0010\t\u001a\u00020\bR\u0016\u0010\n\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000bR\u0016\u0010\u000f\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/inmobi/commons/core/configs/RootConfig$ComponentConfig;", "", "", "getType", "", "getExpiry", "getUrl", "getFallbackUrl", "", "isValid", "type", "Ljava/lang/String;", "expiry", "J", "url", "fallbackUrl", "<init>", "()V", "media_release"})
    @Keep
    public static final class ComponentConfig {
        @NotNull
        private String type = "";
        private long expiry = Long.MAX_VALUE;
        @NotNull
        private String url = "";
        @NotNull
        private String fallbackUrl = "https://config.inmobi.com/config-server/v1/config/secure.cfg";

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final long getExpiry() {
            return this.expiry;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getFallbackUrl() {
            return this.fallbackUrl;
        }

        public final boolean isValid() {
            String string = this.getType();
            if (string != null) {
                if (((Object)StringsKt.trim((CharSequence)string)).toString().length() == 0) {
                    return false;
                }
                if (this.getExpiry() >= 0L && this.getExpiry() <= 864000L) {
                    if (i4.a(this.url)) {
                        return false;
                    }
                    return !Intrinsics.areEqual((Object)"root", (Object)this.getType()) || !i4.a(this.fallbackUrl);
                }
                return false;
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0003\u001a\u00020\u0002J\u0006\u0010\u0004\u001a\u00020\u0002J\u0006\u0010\u0006\u001a\u00020\u0005R\u0016\u0010\u0007\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\t\u0010\b\u00a8\u0006\f"}, d2={"Lcom/inmobi/commons/core/configs/RootConfig$LatestSdkInfo;", "", "", "getLatestVersion", "getLatestVersionUrl", "", "isValid", "version", "Ljava/lang/String;", "url", "<init>", "()V", "media_release"})
    @Keep
    public static final class LatestSdkInfo {
        @NotNull
        private String version = "10.6.6";
        @NotNull
        private String url = "https://www.inmobi.com/products/sdk/#downloads";

        @NotNull
        public final String getLatestVersion() {
            return this.version;
        }

        @NotNull
        public final String getLatestVersionUrl() {
            return this.url;
        }

        public final boolean isValid() {
            String string = this.version;
            if (string != null) {
                return l2.a(((Object)StringsKt.trim((CharSequence)string)).toString()) && !i4.a(this.url);
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0002R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/inmobi/commons/core/configs/RootConfig$GDPR;", "", "", "getTransmitRequest", "()Ljava/lang/Boolean;", "isValid", "transmitRequest", "Ljava/lang/Boolean;", "<init>", "()V", "media_release"})
    @Keep
    public static final class GDPR {
        @v9
        @Nullable
        private Boolean transmitRequest = Boolean.TRUE;

        @Nullable
        public final Boolean getTransmitRequest() {
            return this.transmitRequest;
        }

        public final boolean isValid() {
            return this.transmitRequest != null;
        }
    }
}

