/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.architecture.ui.callback;

import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class ProtectedUnPeekLiveData<T>
extends LiveData<T> {
    private final AtomicInteger currentVersion = new AtomicInteger(-1);
    protected boolean isAllowNullValue;

    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<? super T> observer) {
        super.observe(owner, (Observer)this.createObserverWrapper(observer, this.currentVersion.get()));
    }

    public void observeForever(@NonNull Observer<? super T> observer) {
        super.observeForever((Observer)this.createObserverWrapper(observer, this.currentVersion.get()));
    }

    public void observeSticky(@NonNull LifecycleOwner owner, @NonNull Observer<T> observer) {
        super.observe(owner, observer);
    }

    public void observeStickyForever(@NonNull Observer<? super T> observer) {
        super.observeForever(observer);
    }

    protected void setValue(T value) {
        this.currentVersion.getAndIncrement();
        super.setValue(value);
    }

    protected void postValue(T value) {
        this.currentVersion.getAndIncrement();
        super.postValue(value);
    }

    public void removeObserver(@NonNull Observer<? super T> observer) {
        super.removeObserver((Observer)this.createObserverWrapper(observer, -1));
    }

    private ObserverWrapper createObserverWrapper(@NonNull Observer<? super T> observer, int version) {
        return new ObserverWrapper(observer, version);
    }

    public void clear() {
        super.setValue(null);
    }

    class ObserverWrapper
    implements Observer<T> {
        private final Observer<? super T> observer;
        private int mVersion = -1;

        public ObserverWrapper(Observer<? super T> observer, int mVersion) {
            this.observer = observer;
            this.mVersion = mVersion;
        }

        public void onChanged(T t) {
            if (ProtectedUnPeekLiveData.this.currentVersion.get() > this.mVersion && (t != null || ProtectedUnPeekLiveData.this.isAllowNullValue)) {
                this.observer.onChanged(t);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObserverWrapper that = (ObserverWrapper)o;
            return this.isObjectEquals(this.observer, that.observer);
        }

        public int hashCode() {
            return this.getObjectHash(this.observer);
        }

        private boolean isObjectEquals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }

        private int getObjectHash(Object ... values) {
            return Arrays.hashCode(values);
        }
    }
}

