/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VersionInfo;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.BaseAdsAdapter;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.CustomAdInitCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.InterstitialAdCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.RewardedVideoCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.nativead.NativeAdOptions;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.HandlerUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AdMobAdapter
extends BaseAdsAdapter {
    public static final String TAG = "AdMobAdapter";
    private final ConcurrentMap<String, Object> mRewardedAds = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, InterstitialAd> mInterstitialAds = new ConcurrentHashMap<String, InterstitialAd>();
    private final ConcurrentHashMap<String, Boolean> mAdUnitReadyStatus = new ConcurrentHashMap();

    static double getShowRevenue(double price) {
        try {
            BigDecimal priceBigDecimal = new BigDecimal(String.valueOf(price));
            BigDecimal ONE_THOUSAND = new BigDecimal("1000");
            return priceBigDecimal.divide(ONE_THOUSAND, 8, 4).doubleValue();
        }
        catch (Exception e) {
            MLog.e((String)TAG, (String)"Instance getRevenue Error", (Throwable)e);
            return 0.0;
        }
    }

    static void setAgeRestricted(boolean restricted) {
        int value = restricted ? 1 : 0;
        RequestConfiguration requestConfiguration = MobileAds.getRequestConfiguration().toBuilder().setTagForChildDirectedTreatment(value).build();
        MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
    }

    static AdRequest createAdRequest(Boolean usPrivacyLimit, Boolean userConsent, NativeAdOptions nativeAdOptions, List<String> defaultContentUrls) {
        AdRequest.Builder builder = new AdRequest.Builder();
        if (userConsent != null || usPrivacyLimit != null) {
            Bundle extras = new Bundle();
            if (userConsent != null && !userConsent.booleanValue()) {
                extras.putString("npa", "1");
            }
            if (usPrivacyLimit != null) {
                extras.putInt("rdp", usPrivacyLimit != false ? 1 : 0);
            }
            builder.addNetworkExtrasBundle(com.google.ads.mediation.admob.AdMobAdapter.class, extras);
        }
        if (nativeAdOptions != null && nativeAdOptions.getNeighboringContentUrls() != null) {
            builder.setNeighboringContentUrls(nativeAdOptions.getNeighboringContentUrls());
        } else if (defaultContentUrls != null && !defaultContentUrls.isEmpty()) {
            builder.setNeighboringContentUrls(defaultContentUrls);
        }
        if (nativeAdOptions != null && nativeAdOptions.getContentUrl() != null) {
            builder.setContentUrl(nativeAdOptions.getContentUrl());
        }
        return builder.build();
    }

    public String getMediationVersion() {
        String verStr = null;
        try {
            VersionInfo ver = MobileAds.getVersion();
            verStr = ver.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (verStr == null) {
            verStr = "";
        }
        return verStr;
    }

    public String getAdapterVersion() {
        return "21.4.0.1.9.2.1";
    }

    public int getAdNetworkId() {
        return 2;
    }

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        AdMobAdapter.setAgeRestricted(restricted);
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        this.setAgeRestricted(context, age < 13);
    }

    public void loadRewardedVideo(final Context context, final String adUnitId, final Map<String, Object> extras, final RewardedVideoCallback callback) {
        super.loadRewardedVideo(context, adUnitId, extras, callback);
        HandlerUtil.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        String error = AdMobAdapter.this.check(context, adUnitId);
                        if (!TextUtils.isEmpty((CharSequence)error)) {
                            if (callback != null) {
                                callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (String)error));
                            }
                            return;
                        }
                        if (AdMobAdapter.this.isRewardedInterstitial(extras)) {
                            RewardedInterstitialAd.load((Context)context, (String)adUnitId, (AdRequest)AdMobAdapter.createAdRequest(AdMobAdapter.this.mUSPrivacyLimit, AdMobAdapter.this.mUserConsent, null, AdMobAdapter.this.getDefaultContentUrls()), (RewardedInterstitialAdLoadCallback)new CommonRvCallback(adUnitId, callback).createRvIsLoadCallback());
                        } else {
                            RewardedAd.load((Context)context, (String)adUnitId, (AdRequest)AdMobAdapter.createAdRequest(AdMobAdapter.this.mUSPrivacyLimit, AdMobAdapter.this.mUserConsent, null, AdMobAdapter.this.getDefaultContentUrls()), (RewardedAdLoadCallback)new CommonRvCallback(adUnitId, callback).createRvLoadCallback());
                        }
                    }
                    catch (Exception e) {
                        MLog.e((String)AdMobAdapter.TAG, (String)"Load RewardedVideo Error", (Throwable)e);
                        if (callback == null) break block6;
                        callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (int)245, (String)e.getMessage()));
                    }
                }
            }
        });
    }

    public void showRewardedVideo(final Context context, final String adUnitId, final RewardedVideoCallback callback) {
        HandlerUtil.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                block12: {
                    try {
                        String error = AdMobAdapter.this.check(context, adUnitId);
                        if (!TextUtils.isEmpty((CharSequence)error)) {
                            if (callback != null) {
                                callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (int)311, (String)error));
                            }
                            return;
                        }
                        Object ad = AdMobAdapter.this.mRewardedAds.get(adUnitId);
                        if (ad instanceof RewardedAd) {
                            AdMobAdapter.this.mAdUnitReadyStatus.remove(adUnitId);
                            RewardedAd rewardedAd = (RewardedAd)ad;
                            rewardedAd.setFullScreenContentCallback(AdMobAdapter.this.createRvCallback(adUnitId, false, callback));
                            rewardedAd.show(AdMobAdapter.this.requireActivity(context), new OnUserEarnedRewardListener(){

                                public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                                    if (callback != null) {
                                        callback.onRewardedVideoAdRewarded();
                                    }
                                }
                            });
                        } else if (ad instanceof RewardedInterstitialAd) {
                            AdMobAdapter.this.mAdUnitReadyStatus.remove(adUnitId);
                            RewardedInterstitialAd rewardedAd = (RewardedInterstitialAd)ad;
                            rewardedAd.setFullScreenContentCallback(AdMobAdapter.this.createRvCallback(adUnitId, true, callback));
                            Activity act = AdMobAdapter.this.requireActivity(context);
                            if (act == null) {
                                if (callback != null) {
                                    callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (int)351, (String)"Show Unknown Internal Error"));
                                }
                            } else {
                                rewardedAd.show(act, new OnUserEarnedRewardListener(){

                                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                                        if (callback != null) {
                                            callback.onRewardedVideoAdRewarded();
                                        }
                                    }
                                });
                            }
                        } else if (callback != null) {
                            callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (int)341, (String)"No Ad Ready"));
                        }
                    }
                    catch (Exception e) {
                        MLog.e((String)AdMobAdapter.TAG, (String)"Show RewardedVideo Error", (Throwable)e);
                        if (callback == null) break block12;
                        callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (int)245, (String)e.getMessage()));
                    }
                }
            }
        });
    }

    public boolean isRewardedVideoAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        return this.mAdUnitReadyStatus.containsKey(adUnitId);
    }

    private FullScreenContentCallback createRvCallback(final String adUnitId, final boolean isRis, final RewardedVideoCallback callback) {
        return new FullScreenContentCallback(){

            public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                AdMobAdapter.this.log(AdMobAdapter.this.getRewardedAdName(isRis) + " onAdFailedToShowFullScreenContent error=" + adError);
                super.onAdFailedToShowFullScreenContent(adError);
                if (callback != null) {
                    callback.onRewardedVideoAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (int)AdMobAdapter.showError2Mint(adError.getCode()), (String)("code=" + adError.getCode() + ",message=" + adError.getMessage())));
                }
            }

            public void onAdShowedFullScreenContent() {
                AdMobAdapter.this.log(AdMobAdapter.this.getRewardedAdName(isRis) + " onAdShowedFullScreenContent");
                super.onAdShowedFullScreenContent();
            }

            public void onAdDismissedFullScreenContent() {
                AdMobAdapter.this.log(AdMobAdapter.this.getRewardedAdName(isRis) + " onAdDismissedFullScreenContent");
                super.onAdDismissedFullScreenContent();
                AdMobAdapter.this.mRewardedAds.remove(adUnitId);
                if (callback != null) {
                    callback.onRewardedVideoAdEnded();
                    callback.onRewardedVideoAdClosed();
                }
            }

            public void onAdImpression() {
                AdMobAdapter.this.log(AdMobAdapter.this.getRewardedAdName(isRis) + " onAdImpression");
                final double[] price = new double[]{0.0};
                Object ad = AdMobAdapter.this.mRewardedAds.get(adUnitId);
                if (ad instanceof RewardedAd) {
                    ((RewardedAd)ad).setOnPaidEventListener(new OnPaidEventListener(){

                        public void onPaidEvent(@NonNull AdValue adValue) {
                            AdMobAdapter.this.log("RewardedVideo onPaidEvent value=" + adValue);
                            price[0] = AdMobAdapter.getShowRevenue(adValue.getValueMicros());
                        }
                    });
                } else if (ad instanceof RewardedInterstitialAd) {
                    ((RewardedInterstitialAd)ad).setOnPaidEventListener(new OnPaidEventListener(){

                        public void onPaidEvent(@NonNull AdValue adValue) {
                            AdMobAdapter.this.log("RewardedInterstitial onPaidEvent value=" + adValue);
                            price[0] = AdMobAdapter.getShowRevenue(adValue.getValueMicros());
                        }
                    });
                }
                super.onAdImpression();
                if (callback != null) {
                    callback.onRewardedVideoAdShowSuccess(price[0]);
                    callback.onRewardedVideoAdStarted();
                }
            }

            public void onAdClicked() {
                AdMobAdapter.this.log(AdMobAdapter.this.getRewardedAdName(isRis) + " onAdClicked");
                super.onAdClicked();
                if (callback != null) {
                    callback.onRewardedVideoAdClicked();
                }
            }
        };
    }

    public void loadInterstitialAd(final Context context, final String adUnitId, Map<String, Object> extras, final InterstitialAdCallback callback) {
        super.loadInterstitialAd(context, adUnitId, extras, callback);
        HandlerUtil.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        String error = AdMobAdapter.this.check(context, adUnitId);
                        if (!TextUtils.isEmpty((CharSequence)error)) {
                            if (callback != null) {
                                callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadCheckError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (String)error));
                            }
                            return;
                        }
                        InterstitialAd.load((Context)context, (String)adUnitId, (AdRequest)AdMobAdapter.createAdRequest(AdMobAdapter.this.mUSPrivacyLimit, AdMobAdapter.this.mUserConsent, null, AdMobAdapter.this.getDefaultContentUrls()), (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                            public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                                AdMobAdapter.this.log("Interstitial onAdLoaded ad=" + interstitialAd);
                                super.onAdLoaded((Object)interstitialAd);
                                AdMobAdapter.this.mInterstitialAds.put(adUnitId, interstitialAd);
                                AdMobAdapter.this.mAdUnitReadyStatus.put(adUnitId, true);
                                if (callback != null) {
                                    callback.onInterstitialAdLoadSuccess();
                                }
                            }

                            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                                AdMobAdapter.this.log("Interstitial onAdFailedToLoad error=" + loadAdError);
                                super.onAdFailedToLoad(loadAdError);
                                AdMobAdapter.this.mInterstitialAds.remove(adUnitId);
                                if (callback != null) {
                                    callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (int)AdMobAdapter.loadError2Mint(loadAdError.getCode()), (String)("code=" + loadAdError.getCode() + ",message=" + loadAdError.getMessage())));
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        MLog.e((String)AdMobAdapter.TAG, (String)"Load Interstitial Error", (Throwable)e);
                        if (callback == null) break block4;
                        callback.onInterstitialAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (int)245, (String)e.getMessage()));
                    }
                }
            }
        });
    }

    public void showInterstitialAd(final Context context, final String adUnitId, final InterstitialAdCallback callback) {
        super.showInterstitialAd(context, adUnitId, callback);
        HandlerUtil.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                block12: {
                    try {
                        String error = AdMobAdapter.this.check(context, adUnitId);
                        if (!TextUtils.isEmpty((CharSequence)error)) {
                            if (callback != null) {
                                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (int)311, (String)error));
                            }
                            return;
                        }
                        if (!AdMobAdapter.this.isInterstitialAdAvailable(adUnitId)) {
                            if (callback != null) {
                                callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (int)341, (String)"No Ad Ready"));
                            }
                            return;
                        }
                        AdMobAdapter.this.mAdUnitReadyStatus.remove(adUnitId);
                        InterstitialAd ad = (InterstitialAd)AdMobAdapter.this.mInterstitialAds.get(adUnitId);
                        if (ad != null) {
                            ad.setFullScreenContentCallback(AdMobAdapter.this.createInterstitialListener(adUnitId, callback));
                            Activity act = AdMobAdapter.this.requireActivity(context);
                            if (act == null) {
                                if (callback != null) {
                                    callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (int)351, (String)"Show Unknown Internal Error"));
                                }
                            } else {
                                ad.show(act);
                            }
                        } else if (callback != null) {
                            callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (int)341, (String)"No Ad Ready"));
                        }
                    }
                    catch (Exception e) {
                        MLog.e((String)AdMobAdapter.TAG, (String)"Show Interstitial Error", (Throwable)e);
                        if (callback == null) break block12;
                        callback.onInterstitialAdShowFailed(AdapterErrorBuilder.buildShowError((String)"Interstitial", (String)AdMobAdapter.this.mAdapterName, (int)245, (String)e.getMessage()));
                    }
                }
            }
        });
    }

    public boolean isInterstitialAdAvailable(String adUnitId) {
        if (TextUtils.isEmpty((CharSequence)adUnitId)) {
            return false;
        }
        return this.mAdUnitReadyStatus.containsKey(adUnitId);
    }

    protected void initSDKInternal(Context context, Map<String, Object> dataMap, final CustomAdInitCallback callback) throws Exception {
        if (this.isTestMode(dataMap)) {
            List testDeviceList = this.getTestDeviceList(dataMap);
            RequestConfiguration requestConfiguration = MobileAds.getRequestConfiguration().toBuilder().setTestDeviceIds(testDeviceList).build();
            MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
        }
        MobileAds.initialize((Context)context.getApplicationContext(), (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus status) {
                AdMobAdapter.this.log("onInitializationComplete status=" + status);
                callback.onAdapterInitSucceed(AdMobAdapter.this.getAdNetworkId());
            }
        });
    }

    private FullScreenContentCallback createInterstitialListener(final String adUnitId, final InterstitialAdCallback callback) {
        return new FullScreenContentCallback(){

            public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                AdMobAdapter.this.log("Interstitial onAdFailedToShowFullScreenContent error=" + adError);
                super.onAdFailedToShowFullScreenContent(adError);
            }

            public void onAdShowedFullScreenContent() {
                AdMobAdapter.this.log("Interstitial onAdShowedFullScreenContent");
                super.onAdShowedFullScreenContent();
            }

            public void onAdDismissedFullScreenContent() {
                AdMobAdapter.this.log("Interstitial onAdDismissedFullScreenContent");
                super.onAdDismissedFullScreenContent();
                AdMobAdapter.this.mInterstitialAds.remove(adUnitId);
                if (callback != null) {
                    callback.onInterstitialAdClosed();
                }
            }

            public void onAdClicked() {
                AdMobAdapter.this.log("Interstitial onAdClicked");
                super.onAdClicked();
                if (callback != null) {
                    callback.onInterstitialAdClick();
                }
            }

            public void onAdImpression() {
                AdMobAdapter.this.log("Interstitial onAdImpression");
                final double[] price = new double[]{0.0};
                InterstitialAd interstitialAd = (InterstitialAd)AdMobAdapter.this.mInterstitialAds.get(adUnitId);
                if (interstitialAd != null) {
                    interstitialAd.setOnPaidEventListener(new OnPaidEventListener(){

                        public void onPaidEvent(@NonNull AdValue adValue) {
                            AdMobAdapter.this.log("Interstitial onPaidEvent value=" + adValue);
                            price[0] = AdMobAdapter.getShowRevenue(adValue.getValueMicros());
                        }
                    });
                }
                super.onAdImpression();
                if (callback != null) {
                    callback.onInterstitialAdShowSuccess(price[0]);
                }
            }
        };
    }

    public void onDestroy(Activity activity) {
        try {
            Iterator entryIterator = this.mRewardedAds.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry nextEntry = entryIterator.next();
                String tempKey = (String)nextEntry.getKey();
                this.mAdUnitReadyStatus.remove(tempKey);
                entryIterator.remove();
            }
        }
        catch (Exception e) {
            MLog.e((String)TAG, (String)"onDestroy had Exception", (Throwable)e);
        }
    }

    static int loadError2Mint(int admobLoadError) {
        switch (admobLoadError) {
            case 1: 
            case 8: 
            case 10: 
            case 11: {
                return 211;
            }
            case 2: {
                return 221;
            }
            case 3: 
            case 9: {
                return 261;
            }
        }
        return 251;
    }

    static int showError2Mint(int admobShowError) {
        switch (admobShowError) {
            case 2: {
                return 341;
            }
        }
        return 351;
    }

    public void clearAdCache() {
        super.clearAdCache();
        try {
            Iterator entryIterator = this.mInterstitialAds.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry nextEntry = entryIterator.next();
                String tempKey = (String)nextEntry.getKey();
                this.mAdUnitReadyStatus.remove(tempKey);
                entryIterator.remove();
                InterstitialAd interstitialAd = (InterstitialAd)nextEntry.getValue();
                if (interstitialAd == null) continue;
                interstitialAd = null;
            }
        }
        catch (Exception e) {
            MLog.e((String)TAG, (String)"clearAdCache had Exception", (Throwable)e);
        }
    }

    private String getRewardedAdName(boolean isRis) {
        return isRis ? "RewardedInterstitial" : "RewardedVideo";
    }

    private class CommonRvCallback {
        private final String adUnitId;
        private final RewardedVideoCallback callback;

        private CommonRvCallback(String adUnitId, RewardedVideoCallback callback) {
            this.adUnitId = adUnitId;
            this.callback = callback;
        }

        private RewardedAdLoadCallback createRvLoadCallback() {
            return new RewardedAdLoadCallback(){

                public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                    AdMobAdapter.this.log("RewardedVideo onAdLoaded rewardedAd=" + rewardedAd);
                    CommonRvCallback.this.handleAdLoad(rewardedAd);
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    AdMobAdapter.this.log("RewardedVideo onAdFailedToLoad error=" + loadAdError);
                    CommonRvCallback.this.handleAdLoadFailed(loadAdError);
                }
            };
        }

        private RewardedInterstitialAdLoadCallback createRvIsLoadCallback() {
            return new RewardedInterstitialAdLoadCallback(){

                public void onAdLoaded(@NonNull RewardedInterstitialAd rewardedInterstitialAd) {
                    AdMobAdapter.this.log("RewardedInterstitial onAdLoaded rewardedAd=" + rewardedInterstitialAd);
                    CommonRvCallback.this.handleAdLoad(rewardedInterstitialAd);
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    AdMobAdapter.this.log("RewardedInterstitial onAdFailedToLoad error=" + loadAdError);
                    CommonRvCallback.this.handleAdLoadFailed(loadAdError);
                }
            };
        }

        public void handleAdLoad(Object rewardedAd) {
            AdMobAdapter.this.mRewardedAds.put(this.adUnitId, rewardedAd);
            AdMobAdapter.this.mAdUnitReadyStatus.put(this.adUnitId, true);
            if (this.callback != null) {
                this.callback.onRewardedVideoLoadSuccess();
            }
        }

        public void handleAdLoadFailed(@NonNull LoadAdError loadAdError) {
            AdMobAdapter.this.mRewardedAds.remove(this.adUnitId);
            if (this.callback != null) {
                this.callback.onRewardedVideoLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Rewarded Video", (String)AdMobAdapter.this.mAdapterName, (int)AdMobAdapter.loadError2Mint(loadAdError.getCode()), (String)("code=" + loadAdError.getCode() + ",message=" + loadAdError.getMessage())));
            }
        }
    }
}

