/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnPaidEventListener;
import com.zeus.gmc.sdk.mobileads.mintmediation.adapters.AdMobAdapter;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.BaseBannerEvent;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import java.math.BigDecimal;
import java.util.Map;

public class AdMobBanner
extends BaseBannerEvent {
    private static final String TAG = "AdMobBanner";
    private AdView mBannerView;
    private double mAdValue = 0.0;

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        AdMobAdapter.setAgeRestricted(restricted);
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        this.setAgeRestricted(context, age < 13);
    }

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config, "Banner")) {
            return;
        }
        if (this.mBannerView != null) {
            this.mBannerView.loadAd(AdMobAdapter.createAdRequest(this.mUSPrivacyLimit, this.mUserConsent, null, null));
            return;
        }
        this.mBannerView = new AdView(activity.getApplicationContext());
        this.mBannerView.setAdUnitId(this.mInstancesKey);
        AdSize adSize = this.getAdSize(activity, config);
        if (adSize != null) {
            this.mBannerView.setAdSize(adSize);
        }
        this.mBannerView.setAdListener(new AdListener(){

            public void onAdLoaded() {
                AdMobBanner.this.log("Banner onAdLoaded");
                if (!AdMobBanner.this.isDestroyed) {
                    AdMobBanner.this.onInsReady(AdMobBanner.this.mBannerView);
                }
            }

            public void onAdClicked() {
                AdMobBanner.this.log("Banner onAdClicked");
                super.onAdClicked();
                if (!AdMobBanner.this.isDestroyed) {
                    AdMobBanner.this.onInsClicked();
                }
            }

            public void onAdImpression() {
                AdMobBanner.this.log("Banner onAdImpression");
                if (!AdMobBanner.this.isDestroyed && AdMobBanner.this.mBannerView != null) {
                    AdMobBanner.this.mBannerView.setOnPaidEventListener(new OnPaidEventListener(){

                        public void onPaidEvent(@NonNull AdValue adValue) {
                            AdMobBanner.this.log("Banner onPaidEvent value=" + adValue);
                            AdMobBanner.this.mAdValue = AdMobBanner.this.getShowRevenue(adValue.getValueMicros());
                        }
                    });
                }
                super.onAdImpression();
                if (!AdMobBanner.this.isDestroyed) {
                    AdMobBanner.this.onInsShowSuccess(AdMobBanner.this.mAdValue);
                }
            }

            public void onAdFailedToLoad(LoadAdError loadAdError) {
                AdMobBanner.this.log("Banner onAdFailedToLoad error=" + loadAdError);
                super.onAdFailedToLoad(loadAdError);
                if (!AdMobBanner.this.isDestroyed) {
                    AdMobBanner.this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Banner", (String)AdMobBanner.this.mAdapterName, (int)AdMobAdapter.loadError2Mint(loadAdError.getCode()), (String)("code=" + loadAdError.getCode() + ",message=" + loadAdError.getMessage())));
                }
            }
        });
        this.mBannerView.loadAd(AdMobAdapter.createAdRequest(this.mUSPrivacyLimit, this.mUserConsent, null, null));
    }

    public int getMediation() {
        return 2;
    }

    public void destroy(Activity activity) {
        try {
            if (this.mBannerView != null) {
                this.mBannerView.destroy();
                this.mBannerView = null;
            }
        }
        catch (Exception e) {
            MLog.e((String)TAG, (String)"onDestroy had Exception", (Throwable)e);
        }
        this.isDestroyed = true;
    }

    private AdSize getAdSize(Activity activity, Map<String, String> config) {
        String bannerDesc;
        switch (bannerDesc = this.getBannerDesc(config)) {
            case "LEADERBOARD": {
                return AdSize.LEADERBOARD;
            }
            case "RECTANGLE": {
                return AdSize.MEDIUM_RECTANGLE;
            }
            case "BANNER": {
                return this.getAdaptiveAdSize(activity, AdSize.BANNER.getWidthInPixels((Context)activity));
            }
            case "SMART": {
                return this.getAdaptiveAdSize(activity, 0);
            }
        }
        return this.getAdaptiveAdSize(activity, 0);
    }

    private double getShowRevenue(double price) {
        try {
            BigDecimal priceBigDecimal = new BigDecimal(String.valueOf(price));
            BigDecimal ONE_THOUSAND = new BigDecimal("1000");
            return priceBigDecimal.divide(ONE_THOUSAND, 8, 4).doubleValue();
        }
        catch (Exception e) {
            MLog.e((String)TAG, (String)"Instance getRevenue Error", (Throwable)e);
            return 0.0;
        }
    }

    private void log(String message) {
        MLog.v((String)TAG, (String)message);
    }

    private AdSize getAdaptiveAdSize(Activity activity, int width) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float widthPixels = width <= 0 ? (float)outMetrics.widthPixels : (float)width;
        float density = outMetrics.density;
        int adWidth = (int)(widthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)activity, (int)adWidth);
    }
}

