/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdValue;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnPaidEventListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.zeus.gmc.sdk.mobileads.mintmediation.adapters.AdMobAdapter;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.BaseNativeAdapter;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.CustomAdInitCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.NativeAdCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.nativead.AdIconView;
import com.zeus.gmc.sdk.mobileads.mintmediation.nativead.AdInfo;
import com.zeus.gmc.sdk.mobileads.mintmediation.nativead.MediaController;
import com.zeus.gmc.sdk.mobileads.mintmediation.nativead.NativeAdOptions;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdMobNative
extends BaseNativeAdapter {
    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        AdMobAdapter.setAgeRestricted(restricted);
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        this.setAgeRestricted(context, age < 13);
    }

    public String getMediationVersion() {
        if (this.isSDKInitSucceed()) {
            return MobileAds.getVersionString();
        }
        return "";
    }

    public String getAdapterVersion() {
        return "21.4.0.1.9.2.1";
    }

    public int getAdNetworkId() {
        return 2;
    }

    protected void initSDKInternal(Context context, Map<String, Object> dataMap, final CustomAdInitCallback callback) throws Exception {
        if (this.isTestMode(dataMap)) {
            List testDeviceList = this.getTestDeviceList(dataMap);
            RequestConfiguration requestConfiguration = MobileAds.getRequestConfiguration().toBuilder().setTestDeviceIds(testDeviceList).build();
            MobileAds.setRequestConfiguration((RequestConfiguration)requestConfiguration);
        }
        MobileAds.initialize((Context)context.getApplicationContext(), (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

            public void onInitializationComplete(InitializationStatus status) {
                AdMobNative.this.log("onInitializationComplete status=" + status);
                callback.onAdapterInitSucceed(AdMobNative.this.getAdNetworkId());
            }
        });
    }

    protected BaseNativeAdapter.AdNetworkingNativeAd createNativeAd(Activity activity, String adUnitId, Map<String, String> extras, NativeAdOptions nativeAdOptions, NativeAdCallback callback) {
        return new AdmobNativeAdImpl(activity.getApplicationContext(), adUnitId, extras, nativeAdOptions, callback);
    }

    private double getShowRevenue(double price) {
        try {
            BigDecimal priceBigDecimal = new BigDecimal(String.valueOf(price));
            BigDecimal ONE_THOUSAND = new BigDecimal("1000");
            return priceBigDecimal.divide(ONE_THOUSAND, 8, 4).doubleValue();
        }
        catch (Exception e) {
            MLog.e((String)this.TAG, (String)"Instance getRevenue Error", (Throwable)e);
            return 0.0;
        }
    }

    private class AdmobNativeAdImpl
    extends BaseNativeAdapter.AdNetworkingNativeAd
    implements NativeAd.OnNativeAdLoadedListener {
        private static final String ID_PREFIX = "ADMOB_";
        private NativeAd mNativeAd;
        private NativeAdView mNativeAdView;
        private MediaView mAdMobMediaView;
        private com.zeus.gmc.sdk.mobileads.mintmediation.nativead.MediaView mMediaView;
        private AdIconView mAdIconView;
        private double mAdValue;
        private final AdListener mListener;

        protected AdmobNativeAdImpl(Context context, String adUnit, Map<String, String> extras, NativeAdOptions options, NativeAdCallback callback) {
            super(context, adUnit, extras, options, callback);
            this.mListener = new AdListener(){

                public void onAdClosed() {
                    super.onAdClosed();
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    AdMobNative.this.log("Native onAdFailedToLoad error=" + loadAdError);
                    super.onAdFailedToLoad(loadAdError);
                    if (AdmobNativeAdImpl.this.callback != null) {
                        AdmobNativeAdImpl.this.callback.onNativeAdLoadFailed(AdapterErrorBuilder.buildLoadError((String)"Native", (String)AdMobNative.this.mAdapterName, (int)AdMobAdapter.loadError2Mint(loadAdError.getCode()), (String)("code=" + loadAdError.getCode() + ",message=" + loadAdError.getMessage())));
                    }
                }

                public void onAdOpened() {
                    AdMobNative.this.log("Native onAdOpened");
                    super.onAdOpened();
                }

                public void onAdLoaded() {
                    super.onAdLoaded();
                }

                public void onAdClicked() {
                    super.onAdClicked();
                    AdMobNative.this.log("Native onAdClicked");
                    if (AdmobNativeAdImpl.this.callback != null) {
                        AdmobNativeAdImpl.this.callback.onNativeAdClick();
                    }
                }

                public void onAdImpression() {
                    super.onAdImpression();
                    AdMobNative.this.log("Native onAdImpression");
                    if (AdmobNativeAdImpl.this.mNativeAd != null) {
                        AdmobNativeAdImpl.this.mNativeAd.setOnPaidEventListener(new OnPaidEventListener(){

                            public void onPaidEvent(@NonNull AdValue adValue) {
                                AdMobNative.this.log("Native onPaidEvent value=" + adValue.getValueMicros());
                                AdmobNativeAdImpl.this.mAdValue = AdMobNative.this.getShowRevenue(adValue.getValueMicros());
                            }
                        });
                    }
                    super.onAdImpression();
                    if (AdmobNativeAdImpl.this.callback != null) {
                        AdmobNativeAdImpl.this.callback.onNativeAdShowSuccess(AdmobNativeAdImpl.this.mAdValue);
                    }
                }
            };
        }

        protected void destroy() {
            try {
                if (this.context != null) {
                    this.context = null;
                }
                if (this.mNativeAd != null) {
                    this.mNativeAd.destroy();
                    this.mNativeAd = null;
                }
                if (this.mNativeAdView != null) {
                    this.mNativeAdView.removeAllViews();
                    this.mNativeAdView.destroy();
                    this.mNativeAdView = null;
                }
                if (this.mAdMobMediaView != null) {
                    this.mAdMobMediaView.removeAllViews();
                    this.mAdMobMediaView = null;
                }
                if (this.mMediaView != null) {
                    this.mMediaView.removeAllViews();
                    this.mMediaView = null;
                }
                if (this.mAdIconView != null) {
                    this.mAdIconView.removeAllViews();
                    this.mAdIconView = null;
                }
            }
            catch (Exception e) {
                MLog.e((String)AdMobNative.this.TAG, (String)"onDestroy had exception", (Throwable)e);
            }
        }

        protected void internalLoad() {
            AdLoader.Builder builder = new AdLoader.Builder(this.context, AdMobNative.this.mInstancesKey);
            builder.forNativeAd((NativeAd.OnNativeAdLoadedListener)this);
            NativeAdOptions.Builder nativeAdOptionsBuilder = new NativeAdOptions.Builder();
            nativeAdOptionsBuilder.setRequestMultipleImages(false);
            if (this.extras.get("adChoicesPlacement") != null) {
                try {
                    nativeAdOptionsBuilder.setAdChoicesPlacement(this.options.getAdChoicesPlacement());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AdLoader admobLoader = builder.withNativeAdOptions(nativeAdOptionsBuilder.build()).withAdListener(this.mListener).build();
            admobLoader.loadAd(AdMobAdapter.createAdRequest(AdMobNative.this.mUSPrivacyLimit, AdMobNative.this.mUserConsent, this.options, AdMobNative.this.getDefaultContentUrls()));
        }

        protected void registerNativeView(com.zeus.gmc.sdk.mobileads.mintmediation.nativead.NativeAdView adView) {
            RelativeLayout.LayoutParams layoutParams;
            RelativeLayout relativeLayout = new RelativeLayout(adView.getContext());
            if (this.mNativeAd == null) {
                return;
            }
            if (adView.getMediaView() != null) {
                this.mMediaView = adView.getMediaView();
                adView.setMediaView(this.mMediaView);
            }
            if (adView.getAdIconView() != null) {
                this.mAdIconView = adView.getAdIconView();
                adView.setAdIconView(this.mAdIconView);
            }
            this.mNativeAdView = new NativeAdView(adView.getContext());
            if (adView.getTitleView() != null) {
                this.mNativeAdView.setHeadlineView(adView.getTitleView());
            }
            if (adView.getDescView() != null) {
                this.mNativeAdView.setBodyView(adView.getDescView());
            }
            if (adView.getCallToActionView() != null) {
                this.mNativeAdView.setCallToActionView(adView.getCallToActionView());
            }
            if (this.mMediaView != null) {
                this.mMediaView.removeAllViews();
                MediaView admobMediaView = new MediaView(adView.getContext());
                this.mMediaView.addView((View)admobMediaView);
                layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(13);
                admobMediaView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (this.mMediaView.getImageScaleType() != null) {
                    admobMediaView.setImageScaleType(this.mMediaView.getImageScaleType());
                }
                admobMediaView.setMediaContent(this.mNativeAd.getMediaContent());
                this.mAdMobMediaView = admobMediaView;
                this.mNativeAdView.setMediaView(admobMediaView);
            }
            if (this.mAdIconView != null && this.mNativeAd.getIcon() != null && this.mNativeAd.getIcon().getDrawable() != null) {
                this.mAdIconView.removeAllViews();
                ImageView iconImageView = new ImageView(adView.getContext());
                this.mAdIconView.addView((View)iconImageView);
                iconImageView.setImageDrawable(this.mNativeAd.getIcon().getDrawable());
                iconImageView.getLayoutParams().width = -1;
                iconImageView.getLayoutParams().height = -1;
                this.mNativeAdView.setIconView((View)this.mAdIconView);
            }
            TextView textView = new TextView(adView.getContext());
            if (adView.getAdvertiserView() != null) {
                this.mNativeAdView.setAdvertiserView(adView.getAdvertiserView());
            } else {
                layoutParams = new RelativeLayout.LayoutParams(50, 35);
                layoutParams.addRule(10);
                textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                textView.setBackgroundColor(Color.argb((int)255, (int)234, (int)234, (int)234));
                textView.setGravity(17);
                textView.setText((CharSequence)"Ad");
                textView.setTextSize(10.0f);
                textView.setTextColor(Color.argb((int)255, (int)45, (int)174, (int)201));
                relativeLayout.addView((View)textView);
                this.mNativeAdView.setAdvertiserView((View)textView);
            }
            int count = adView.getChildCount();
            for (int a = 0; a < count; ++a) {
                View v = adView.getChildAt(a);
                if (v == null || v instanceof NativeAdView) continue;
                adView.removeView(v);
                relativeLayout.addView(v);
            }
            this.mNativeAdView.setNativeAd(this.mNativeAd);
            textView.bringToFront();
            if (this.mNativeAdView.getAdChoicesView() != null) {
                this.mNativeAdView.getAdChoicesView().bringToFront();
            }
            adView.addView((View)this.mNativeAdView);
            int l = adView.getPaddingLeft();
            int t = adView.getPaddingTop();
            int r = adView.getPaddingRight();
            int b = adView.getPaddingBottom();
            relativeLayout.setPadding(l, t, r, b);
            adView.setPadding(0, 0, 0, 0);
            this.mNativeAdView.addView((View)relativeLayout);
        }

        public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
            this.mNativeAd = nativeAd;
            HashMap<String, String> extras = new HashMap<String, String>();
            if (nativeAd.getResponseInfo() != null) {
                extras.put("adid", ID_PREFIX + nativeAd.getResponseInfo().getResponseId());
            } else {
                extras.put("adid", "ADMOB_null");
            }
            extras.put("pid", AdMobNative.this.mInstancesKey);
            AdInfo adInfo = new AdInfo();
            adInfo.setExtras(extras);
            adInfo.setType(AdMobNative.this.getAdNetworkId());
            adInfo.setTitle(nativeAd.getHeadline());
            adInfo.setDesc(nativeAd.getBody());
            adInfo.setCallToActionText(nativeAd.getCallToAction());
            final MediaContent mediaContent = nativeAd.getMediaContent();
            final VideoController videoController = mediaContent == null ? null : mediaContent.getVideoController();
            adInfo.setVideoAd(videoController != null && videoController.hasVideoContent());
            if (mediaContent != null) {
                adInfo.setVideoDuration((int)(mediaContent.getDuration() / 1000.0f));
            }
            adInfo.setAdObject((Object)this);
            if (nativeAd.getIcon() != null) {
                adInfo.setAdIconUri(nativeAd.getIcon().getUri());
                adInfo.setAdIconDrawable(nativeAd.getIcon().getDrawable());
            } else {
                adInfo.setAdIconUri(null);
                adInfo.setAdIconDrawable(null);
            }
            final MediaController mc = new MediaController(){

                public void play() {
                    if (videoController != null) {
                        videoController.play();
                        videoController.mute(false);
                    }
                }

                public void pause() {
                    if (videoController != null) {
                        videoController.pause();
                    }
                }

                public void stop() {
                    if (videoController != null) {
                        videoController.stop();
                    }
                }

                public void bindIconView(View adIconView) {
                    if (AdmobNativeAdImpl.this.mNativeAdView != null && AdmobNativeAdImpl.this.mNativeAd.getIcon() != null) {
                        AdmobNativeAdImpl.this.mNativeAdView.setIconView(adIconView);
                    }
                }

                public float getVideoCurrentTime() {
                    if (mediaContent != null) {
                        return mediaContent.getCurrentTime();
                    }
                    return super.getVideoCurrentTime();
                }

                public float getVideoDuration() {
                    if (mediaContent != null) {
                        return mediaContent.getDuration();
                    }
                    return super.getVideoDuration();
                }
            };
            if (videoController != null) {
                videoController.setVideoLifecycleCallbacks(new VideoController.VideoLifecycleCallbacks(){

                    public void onVideoStart() {
                        super.onVideoStart();
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                Log.e((String)AdMobNative.this.TAG, (String)"onVideoStart: ");
                                if (mc.getMediaControllerCallback() != null) {
                                    mc.getMediaControllerCallback().onVideoStart();
                                }
                            }
                        });
                    }

                    public void onVideoPlay() {
                        super.onVideoPlay();
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                Log.e((String)AdMobNative.this.TAG, (String)"onVideoPlay: ");
                                if (mc.getMediaControllerCallback() != null) {
                                    mc.getMediaControllerCallback().onVideoPlay();
                                }
                            }
                        });
                    }

                    public void onVideoPause() {
                        super.onVideoPause();
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                Log.e((String)AdMobNative.this.TAG, (String)"onVideoPause: ");
                                if (mc.getMediaControllerCallback() != null) {
                                    mc.getMediaControllerCallback().onVideoPause();
                                }
                            }
                        });
                    }

                    public void onVideoEnd() {
                        super.onVideoEnd();
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                Log.e((String)AdMobNative.this.TAG, (String)"onVideoEnd: ");
                                if (mc.getMediaControllerCallback() != null) {
                                    mc.getMediaControllerCallback().onVideoEnd();
                                }
                            }
                        });
                    }

                    public void onVideoMute(final boolean b) {
                        super.onVideoMute(b);
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                if (mc.getMediaControllerCallback() != null) {
                                    mc.getMediaControllerCallback().onVideoMute(b);
                                }
                            }
                        });
                    }
                });
            }
            adInfo.setMediaController(mc);
            if (this.callback != null) {
                this.callback.onNativeAdLoadSuccess(adInfo);
            }
        }
    }
}

