/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.zeus.gmc.sdk.mobileads.mintmediation.adapters.AdMobAdapter;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.BaseSplashEvent;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.HandlerUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import java.util.Map;

public class AdMobSplash
extends BaseSplashEvent {
    public static final String TAG = "AdMobSplash";
    private AppOpenAd mAppOpenAd;
    private Long mAdLoadTime;
    private static final long mTimeTimeLess = 14400000L;

    public void setAgeRestricted(Context context, boolean restricted) {
        super.setAgeRestricted(context, restricted);
        AdMobAdapter.setAgeRestricted(restricted);
    }

    public void setUserAge(Context context, int age) {
        super.setUserAge(context, age);
        this.setAgeRestricted(context, age < 13);
    }

    public int getMediation() {
        return 2;
    }

    public void loadAd(Activity activity, Map<String, String> config) throws Throwable {
        super.loadAd(activity, config);
        if (!this.check(activity, config, "Splash")) {
            return;
        }
        if (!this.check(activity)) {
            this.onInsError(AdapterErrorBuilder.buildLoadCheckError((String)"Splash", (String)this.mAdapterName, (String)"Activity is null"));
            return;
        }
        this.loadSplashAd(activity, this.mInstancesKey, config);
    }

    public void destroy(Activity activity) {
        this.isDestroyed = true;
        this.mAppOpenAd = null;
        this.mAdLoadTime = 0L;
    }

    public void loadSplashAd(final Activity activity, final String adUnit, Map<String, String> config) {
        final int orientation = activity.getResources().getConfiguration().orientation == 2 ? 2 : 1;
        final AppOpenAd.AppOpenAdLoadCallback loadCallback = new AppOpenAd.AppOpenAdLoadCallback(){

            public void onAdLoaded(@NonNull AppOpenAd ad) {
                if (AdMobSplash.this.isDestroyed) {
                    return;
                }
                if (ad != null) {
                    AdMobSplash.this.mAppOpenAd = ad;
                    AdMobSplash.this.mAdLoadTime = SystemClock.elapsedRealtime();
                    AdMobSplash.this.onInsReady(null);
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                if (AdMobSplash.this.isDestroyed) {
                    return;
                }
                AdMobSplash.this.onInsError(AdapterErrorBuilder.buildLoadError((String)"Splash", (String)AdMobSplash.this.mAdapterName, (int)AdMobAdapter.loadError2Mint(loadAdError.getCode()), (String)("code=" + loadAdError.getCode() + ",message=" + loadAdError.getMessage())));
            }
        };
        final AdRequest request = AdMobAdapter.createAdRequest(this.mUSPrivacyLimit, this.mUserConsent, null, this.getDefaultContentUrls());
        HandlerUtil.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AppOpenAd.load((Context)activity.getApplicationContext(), (String)adUnit, (AdRequest)request, (int)orientation, (AppOpenAd.AppOpenAdLoadCallback)loadCallback);
            }
        });
    }

    public void show(Activity activity, ViewGroup container) {
        super.show(activity, container);
        this.showSplashAd(activity, container);
    }

    public void show(Activity activity) {
        this.showSplashAd(activity, null);
    }

    private void showSplashAd(final Activity activity, ViewGroup container) {
        if (!this.check(activity)) {
            this.onInsError(AdapterErrorBuilder.buildShowError((String)"Splash", (String)this.mAdapterName, (int)311, (String)"Activity is null"));
            return;
        }
        if (!this.isReady()) {
            this.onInsShowFailed(AdapterErrorBuilder.buildShowError((String)"Splash", (String)this.mAdapterName, (int)341, (String)"SplashAd not ready"));
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                try {
                    AdMobSplash.this.showSplashAd(activity);
                }
                catch (Exception e) {
                    MLog.e((String)AdMobSplash.TAG, (String)"Show Splash Failed", (Throwable)e);
                    AdMobSplash.this.onInsShowFailed(AdapterErrorBuilder.buildShowError((String)"Splash", (String)AdMobSplash.this.mAdapterName, (int)345, (String)e.getMessage()));
                }
            }
        });
    }

    private void showSplashAd(Activity activity) {
        FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

            public void onAdDismissedFullScreenContent() {
                AdMobSplash.this.log("Splash onAdDismissedFullScreenContent");
                if (AdMobSplash.this.isDestroyed) {
                    return;
                }
                AdMobSplash.this.onInsDismissed();
            }

            public void onAdFailedToShowFullScreenContent(AdError adError) {
                AdMobSplash.this.log("Splash onAdFailedToShowFullScreenContent error=" + adError);
                if (AdMobSplash.this.isDestroyed) {
                    return;
                }
                AdMobSplash.this.onInsError(AdapterErrorBuilder.buildShowError((String)"Splash", (String)AdMobSplash.this.mAdapterName, (int)AdMobAdapter.showError2Mint(adError.getCode()), (String)("code=" + adError.getCode() + ",message=" + adError.getMessage())));
            }

            public void onAdShowedFullScreenContent() {
                AdMobSplash.this.log("Splash onAdShowedFullScreenContent");
            }

            public void onAdImpression() {
                AdMobSplash.this.log("Splash onAdImpression");
                super.onAdImpression();
                if (AdMobSplash.this.isDestroyed) {
                    return;
                }
                AdMobSplash.this.onInsShowSuccess();
            }

            public void onAdClicked() {
                AdMobSplash.this.log("Splash onAdClicked");
                super.onAdClicked();
                if (AdMobSplash.this.isDestroyed) {
                    return;
                }
                AdMobSplash.this.onInsClicked();
            }
        };
        this.mAppOpenAd.setFullScreenContentCallback(fullScreenContentCallback);
        this.mAppOpenAd.show(activity);
        this.mAppOpenAd = null;
        this.mAdLoadTime = 0L;
    }

    public boolean isReady() {
        if (this.isDestroyed || TextUtils.isEmpty((CharSequence)this.mInstancesKey)) {
            return false;
        }
        return this.mAppOpenAd != null && this.mAdLoadTime > 0L && this.wasLoadTimeLessThanNHoursAgo(this.mAdLoadTime);
    }

    private boolean wasLoadTimeLessThanNHoursAgo(long loadTime) {
        long dateDifference = SystemClock.elapsedRealtime() - loadTime;
        return dateDifference < 14400000L;
    }

    private void log(String message) {
        MLog.v((String)TAG, (String)message);
    }
}

