/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import android.text.TextUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.PlacementUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.DataCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.event.EventUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.BaseInstance;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Placement;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Scene;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.thread.ThrowableCaughtRunnable;

public class AdRateUtil {
    private static final String TAG = "AdRateUtil";
    private static final String RATE = "Rate";
    private static final String CAP = "CAP";
    private static final String CAP_TIME = "CAPTime";

    private AdRateUtil() {
        throw new IllegalStateException("AdRateUtil class");
    }

    public static void onInstancesShowed(final String string, String string2) {
        String string3 = string;
        AdRateUtil.saveShowTime(string3);
        AdRateUtil.addCAP(string3);
        AdRateUtil.saveShowTime(string + string2);
        AdRateUtil.addCAP(string + string2);
        MintPoolExecuter.execute(ExecutorEnum.AdRate, new Runnable(){

            @Override
            public void run() {
                PlacementUtils.savePlacementImprCount(string);
            }
        });
    }

    public static void onSceneShowed(String string, Scene scene) {
        if (scene != null) {
            AdRateUtil.saveShowTime(string + scene.getN());
            AdRateUtil.addCAP(string + scene.getN());
        }
    }

    private static void saveShowTime(final String string) {
        MintPoolExecuter.execute(ExecutorEnum.AdRate, new ThrowableCaughtRunnable(TAG, "saveShowTime"){

            @Override
            protected void execute() throws Exception {
                DataCache.getInstance().set(AdRateUtil.RATE + string, System.currentTimeMillis());
            }
        });
    }

    public static boolean shouldBlockPlacement(Placement placement) {
        if (placement != null && !TextUtils.isEmpty((CharSequence)placement.getId())) {
            boolean bl = AdRateUtil.isInterval(placement.getId(), placement.getFrequencyInterval());
            if (bl) {
                EventUtil.getInstance().placementCappedReport(placement.getId());
            }
            return bl;
        }
        return false;
    }

    public static boolean isPlacementCapped(Placement placement) {
        if (placement != null && !TextUtils.isEmpty((CharSequence)placement.getId())) {
            Placement placement2 = placement;
            int bl = placement2.getFrequencyUnit();
            boolean bl2 = AdRateUtil.isCAP(placement.getId(), bl, placement2.getFrequencyCap());
            if (bl2) {
                EventUtil.getInstance().placementCappedReport(placement.getId());
            }
            return bl2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldBlockInstance(String string, BaseInstance baseInstance) {
        int n2;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (!AdRateUtil.isInterval(string, baseInstance.getFrequencyInterval())) {
            BaseInstance baseInstance2 = baseInstance;
            n2 = baseInstance2.getFrequencyUnit();
            if (!AdRateUtil.isCAP(string, n2, baseInstance2.getFrequencyCap())) return 0 != 0;
        }
        n2 = 1;
        if (n2 == 0) return n2 != 0;
        EventUtil.getInstance().instanceCappedReport(baseInstance.buildReportData());
        return n2 != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldBlockScene(String string, Scene scene) {
        if (scene == null) return 0 != 0;
        Scene scene2 = scene;
        int n2 = scene2.getFrequencyUnit();
        if (!AdRateUtil.isCAP(string + scene.getN(), n2, scene2.getFrequencyCap())) return 0 != 0;
        n2 = 1;
        if (n2 == 0) return n2 != 0;
        EventUtil.getInstance().sceneCappedReport(string, scene.getId());
        return n2 != 0;
    }

    private static boolean isInterval(String string, long l2) {
        if (l2 == 0L) {
            return false;
        }
        Long l3 = DataCache.getInstance().get(RATE + string, Long.TYPE);
        if (l3 == null) {
            return false;
        }
        MLog.d(TAG, "Interval:" + string + ":" + (System.currentTimeMillis() - l3) + ":" + l2);
        return System.currentTimeMillis() - l3 < l2;
    }

    private static void addCAP(final String string) {
        MintPoolExecuter.execute(ExecutorEnum.AdRate, new ThrowableCaughtRunnable(TAG, "addCAP"){

            @Override
            public void execute() {
                Integer n2 = DataCache.getInstance().get(AdRateUtil.CAP + string, Integer.TYPE);
                if (n2 == null) {
                    n2 = 0;
                }
                MLog.d(AdRateUtil.TAG, "AddCAP:" + string + ":" + n2 + 1);
                DataCache.getInstance().set(AdRateUtil.CAP + string, n2 + 1);
                if (DataCache.getInstance().get(AdRateUtil.CAP_TIME + string, Long.TYPE) == null) {
                    DataCache.getInstance().set(AdRateUtil.CAP_TIME + string, System.currentTimeMillis());
                }
            }
        });
    }

    private static boolean isCAP(String string, int n2, int n3) {
        if (n3 <= 0) {
            return false;
        }
        Long l2 = DataCache.getInstance().get(CAP_TIME + string, Long.TYPE);
        if (l2 == null) {
            return false;
        }
        Integer n4 = DataCache.getInstance().get(CAP + string, Integer.TYPE);
        MLog.d(TAG, "CapTime:" + string + ":" + (System.currentTimeMillis() - l2) + ":" + n2 + ":Cap:" + n4 + ":" + n3);
        if (System.currentTimeMillis() - l2 < (long)n2) {
            return n4 >= n3;
        }
        DataCache.getInstance().delete(CAP_TIME + string);
        DataCache.getInstance().delete(CAP + string);
        return false;
    }
}

