/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.DataCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.device.DeviceUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.thread.ThrowableCaughtRunnable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class AdValueUtil {
    private static final String TAG = "AdValueUtil";
    private static final String PIT = "PIT";
    private static final String PIV = "PIV";
    private static final ConcurrentHashMap<String, Float> pivs = new ConcurrentHashMap();
    private static Date flDate = null;

    private AdValueUtil() {
        throw new IllegalStateException("AdValueUtil class");
    }

    public static int getUad() {
        int n2 = AdValueUtil.getuad();
        long l2 = AdValueUtil.getLlt();
        if (l2 == 0L) {
            l2 = System.currentTimeMillis();
            AdValueUtil.setLlt(l2);
        }
        if (AdValueUtil.differentDays(AdValueUtil.getZeroDate(l2)) == 0) {
            MLog.v(TAG, "getUad: " + n2);
            return n2;
        }
        AdValueUtil.setLlt(System.currentTimeMillis());
        AdValueUtil.setuad(++n2);
        MLog.v(TAG, "updateUad: " + n2);
        return n2;
    }

    public static int getUld() {
        int n2 = AdValueUtil.differentDays(AdValueUtil.getFld());
        MLog.v(TAG, "getUld: " + n2);
        return n2;
    }

    public static int getPit(String string) {
        int n2 = DataCache.getInstance().containsKey(PIT + string) ? DataCache.getInstance().get(PIT + string, Integer.TYPE) : 0;
        MLog.v(TAG, "pid: " + string + " getPit: " + n2);
        return n2;
    }

    public static float getPiv(String string) {
        block8: {
            float f2;
            block10: {
                block9: {
                    try {
                        if (!pivs.containsKey(string)) break block8;
                    }
                    catch (Exception exception) {
                        CrashUtil.getSingleton().saveException(exception);
                        MLog.e(TAG, "pid: " + string + " getPiv exception: " + exception);
                        return 0.0f;
                    }
                    if (pivs.get(string) == null) break block8;
                    Float f3 = pivs.get(string);
                    MLog.v(TAG, "pid: " + string + " getPiv: " + f3);
                    if (f3 == null) break block9;
                    f2 = f3.floatValue();
                    break block10;
                }
                f2 = 0.0f;
            }
            return f2;
        }
        float f4 = AdValueUtil.requestPiv(string);
        MLog.v(TAG, "pid: " + string + " getPiv: " + f4);
        return f4;
    }

    private static float requestPiv(String string) {
        int n2 = 0;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 10; ++i2) {
            if (!DataCache.getInstance().containsKey(PIV + string + i2)) continue;
            float f4 = DataCache.getInstance().get(PIV + string + i2, Float.TYPE).floatValue();
            MLog.v(TAG, "pid: " + string + " count: " + i2 + " value: " + f4);
            f2 += f4;
            ++n2;
        }
        if (n2 != 0) {
            f3 = f2 / (float)n2;
        }
        pivs.put(string, Float.valueOf(f3));
        MLog.v(TAG, "pid: " + string + " requestPiv: " + f3);
        return f3;
    }

    public static void setPitv(String string, String string2) {
        String string3 = string;
        MLog.v(TAG, "pid: " + string + " setPitv: " + string2);
        int n2 = AdValueUtil.getPit(string3);
        DataCache dataCache = DataCache.getInstance();
        String string4 = PIT + string;
        dataCache.set(string4, ++n2);
        DataCache.getInstance().set(PIV + string + (n2 %= 10), string2);
        AdValueUtil.requestPiv(string3);
    }

    public static void onInstancesShowed(final String string, final String string2) {
        MintPoolExecuter.execute(ExecutorEnum.AdRate, new ThrowableCaughtRunnable(TAG, "Advalue onInstancesShowed"){

            @Override
            protected void execute() throws Exception {
                AdValueUtil.setPitv(string, string2);
            }
        });
    }

    public static Date getFld() {
        if (flDate == null) {
            long l2 = DeviceUtil.getFlt() * 1000L;
            flDate = l2 == 0L ? AdValueUtil.getToadyZeroDate() : AdValueUtil.getZeroDate(l2);
        }
        MLog.v(TAG, "getFld: " + flDate);
        return flDate;
    }

    public static long getLlt() {
        return DataCache.getInstance().containsKey("llt") ? DataCache.getInstance().get("llt", Long.TYPE) : 0L;
    }

    public static void setLlt(long l2) {
        DataCache.getInstance().set("llt", l2);
    }

    public static int getuad() {
        return DataCache.getInstance().containsKey("uad") ? DataCache.getInstance().get("uad", Integer.TYPE) : 0;
    }

    public static void setuad(int n2) {
        DataCache.getInstance().set("uad", n2);
    }

    public static Date getToadyZeroDate() {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        calendar.set(n2, n3, n4, 0, 0, 0);
        Date date = calendar.getTime();
        MLog.v(TAG, "getToadyZeroDate: " + date);
        return date;
    }

    public static Date getZeroDate(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        calendar.set(n2, n3, n4, 0, 0, 0);
        return calendar.getTime();
    }

    public static int differentDays(Date date, Date date2) {
        return (int)((date2.getTime() - date.getTime()) / 86400000L);
    }

    public static int differentDays(Date date) {
        return AdValueUtil.differentDays(date, AdValueUtil.getToadyZeroDate());
    }

    public static long dateToMillSecond(Date date) {
        return date.getTime();
    }

    public static Date millSecondToDate(long l2) {
        return new Date(l2);
    }
}

