/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import android.util.SparseArray;
import com.zeus.gmc.sdk.mobileads.mintmediation.a.e;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterError;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.BaseAdParams;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.BaseAdsAdapter;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.CustomAdInitCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.CustomAdInitTimeoutCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.JsonUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.DataCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.debug.Debugger;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.device.AdvertisingIdUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.event.EventUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.AdNetwork;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.BaseInstance;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Configurations;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Mediation;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Placement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdapterUtil {
    private static final String TAG = "AdapterUtil";
    private static final int NOT_INIT = 1;
    private static final int INIT_PENDING = 2;
    private static final int INIT_SUCCESS = 3;
    private static final Object ADAPTER_LOCK;
    private static final SparseArray<BaseAdsAdapter> sAdapters;
    private static final SparseArray<AdapterDesc> sAdapterDesc;
    private static final Map<Integer, Integer> sAdapterInitStatus;
    private static final Object CALLBACK_LOCK;
    private static final Map<Integer, List<CustomAdInitCallback>> sPendingCallbacks;
    private static final Map<Integer, Long> sAdapterInitStartRecord;
    private static final InitCallbackManager INIT_CALLBACK_MANAGER;
    private static List<String> sTestDevice;

    public static void startCheckAdapterAndSDKVersion(Context context) {
        if (Debugger.isDebugMode()) {
            new VersionHelper().startCheckAdapterVersion(context);
        }
    }

    public static Map<Integer, Pair<String, String>> getSupportVersionMap() {
        HashMap<Integer, Pair<String, String>> hashMap;
        HashMap<Integer, Pair<String, String>> hashMap2 = hashMap;
        hashMap = new HashMap<Integer, Pair<String, String>>();
        int n2 = sAdapterDesc.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = sAdapterDesc.keyAt(i2);
            AdapterDesc adapterDesc = (AdapterDesc)sAdapterDesc.get(n3);
            if (adapterDesc == null) continue;
            hashMap2.put(n3, (Pair<String, String>)Pair.create((Object)adapterDesc.supportAdapterVersion, (Object)adapterDesc.supportSDKVersion));
        }
        return hashMap2;
    }

    public static String getAdapterVersion(int n2, BaseAdsAdapter baseAdsAdapter) {
        AdapterDesc adapterDesc = (AdapterDesc)sAdapterDesc.get(n2);
        if (adapterDesc != null && adapterDesc.realAdapterVersion != null) {
            return adapterDesc.realAdapterVersion;
        }
        String string = null;
        if (baseAdsAdapter != null) {
            try {
                string = baseAdsAdapter.getAdapterVersion();
            }
            catch (Throwable throwable) {}
        }
        if (string == null && adapterDesc != null) {
            try {
                Field field = Class.forName("com.zeus.gmc.sdk.mobileads.mintmediation.adapters." + adapterDesc.getRealName().toLowerCase() + ".BuildConfig").getDeclaredField("VERSION_NAME");
                field.setAccessible(true);
                string = (String)field.get(null);
            }
            catch (Throwable throwable) {}
        }
        if (string != null && adapterDesc != null) {
            adapterDesc.setRealAdapterVersion(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getAdns() {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        Object object = ADAPTER_LOCK;
        synchronized (object) {
            sAdapters.clear();
            int n2 = 0;
            while (true) {
                block11: {
                    Object object2;
                    if (n2 >= sAdapterDesc.size()) break;
                    try {
                        object2 = (AdapterDesc)sAdapterDesc.get(sAdapterDesc.keyAt(n2));
                        if (object2 == null) break block11;
                    }
                    catch (Throwable throwable) {}
                    JSONArray jSONArray3 = jSONArray2;
                    object2 = AdapterUtil.createAdapter(BaseAdsAdapter.class, ((AdapterDesc)object2).getAdapterClassPath());
                    sAdapters.put(((BaseAdsAdapter)object2).getAdNetworkId(), object2);
                    jSONArray3.put((Object)AdapterUtil.getAdNetWork((BaseAdsAdapter)object2).toJson());
                    e.d().a((BaseAdParams)object2);
                }
                ++n2;
            }
            return jSONArray2;
        }
    }

    protected static String getBidAdapterPath(int n2) {
        AdapterDesc adapterDesc = (AdapterDesc)sAdapterDesc.get(n2);
        if (adapterDesc == null) {
            return null;
        }
        return adapterDesc.getBidAdapterClassPath();
    }

    public static SparseArray<BaseAdsAdapter> getAdapterMap() {
        return sAdapters;
    }

    public static BaseAdsAdapter getCustomAdsAdapter(int n2) {
        return (BaseAdsAdapter)sAdapters.get(n2);
    }

    public static BaseAdsAdapter geNativeAdAdapter(int n2, String string) {
        Class<BaseAdsAdapter> clazz;
        try {
            clazz = Class.forName(string).asSubclass(BaseAdsAdapter.class);
        }
        catch (Throwable throwable) {
            return null;
        }
        Constructor<BaseAdsAdapter> constructor = clazz.getDeclaredConstructor(null);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    public static String getAdapterPathWithType(int n2, int n3) {
        AdapterDesc adapterDesc = (AdapterDesc)sAdapterDesc.get(n3);
        if (adapterDesc == null) {
            return null;
        }
        return adapterDesc.getAdapterPathWithType(n2);
    }

    public static void initAdNetworkWithDefaultConfig(Context object, int n2, CustomAdInitCallback customAdInitCallback) {
        Context context = object;
        object = AdapterUtil.getInitDataMapFromConfig(n2);
        AdapterUtil.initAdNetwork(context, n2, 0L, (Map<String, Object>)object, customAdInitCallback);
    }

    public static void initAdNetworkWithDefaultConfig(Context object, int n2, long l2, CustomAdInitCallback customAdInitCallback) {
        Context context = object;
        object = AdapterUtil.getInitDataMapFromConfig(n2);
        AdapterUtil.initAdNetwork(context, n2, l2, (Map<String, Object>)object, customAdInitCallback);
    }

    public static boolean isAdNetworkInitSucceed(int n2) {
        return AdapterUtil.getAdNetworkInitState(n2) == 3;
    }

    public static int getAdNetworkInitState(int n2) {
        Integer n3 = sAdapterInitStatus.get(n2);
        return n3 == null ? 1 : n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initAdNetwork(Context context, int n2, long l2, Map<String, Object> map, CustomAdInitCallback customAdInitCallback) {
        BaseAdsAdapter baseAdsAdapter;
        int n3;
        block20: {
            block21: {
                int n4 = n2;
                Object object = AdapterUtil.getAdapterNameFromCache(n4);
                n3 = AdapterUtil.getAdNetworkInitState(n4);
                if (n3 == 3) {
                    if (customAdInitCallback != null) {
                        customAdInitCallback.onAdapterInitSucceed(n2);
                    }
                    return;
                }
                baseAdsAdapter = AdapterUtil.getCustomAdsAdapter(n2);
                if (baseAdsAdapter == null) {
                    if (customAdInitCallback != null) {
                        customAdInitCallback.onAdapterInitFailed(n2, AdapterErrorBuilder.buildInitError("", (String)object, "adapter not found"));
                    }
                    return;
                }
                if (context == null) {
                    if (customAdInitCallback != null) {
                        MLog.w(TAG, (String)object + " init failed, context is null");
                        customAdInitCallback.onAdapterInitFailed(n2, AdapterErrorBuilder.buildInitError("", (String)object, "context is null"));
                    }
                    return;
                }
                if (customAdInitCallback == null) break block21;
                object = CALLBACK_LOCK;
                synchronized (object) {
                    block19: {
                        ArrayList<CustomAdInitCallback> arrayList;
                        block18: {
                            ArrayList<CustomAdInitCallback> arrayList2;
                            arrayList = sPendingCallbacks.get(n2);
                            if (arrayList != null) break block18;
                            arrayList = arrayList2;
                            arrayList2 = new ArrayList<CustomAdInitCallback>();
                            sPendingCallbacks.put(n2, arrayList);
                        }
                        if (arrayList.contains(customAdInitCallback)) break block19;
                        arrayList.add(customAdInitCallback);
                    }
                    if (l2 <= 0L) break block21;
                    INIT_CALLBACK_MANAGER.onTimeoutCallbackRequest(n2, l2, customAdInitCallback);
                }
            }
            try {
                if (!baseAdsAdapter.isSDKInitSucceed()) break block20;
            }
            catch (Throwable throwable) {}
            baseAdsAdapter.initSDK(context, map, INIT_CALLBACK_MANAGER);
            INIT_CALLBACK_MANAGER.onAdapterInitSucceed(baseAdsAdapter.getAdNetworkId());
            return;
        }
        if (n3 == 2) {
            return;
        }
        sAdapterInitStatus.put(n2, 2);
        sAdapterInitStartRecord.put(n2, SystemClock.elapsedRealtime());
        EventUtil.getInstance().onInsInitStartReport(AdapterUtil.buildInitReportData(n2, -1L));
        baseAdsAdapter.initSDK(context, map, INIT_CALLBACK_MANAGER);
    }

    static void setTestDevice(List<String> list) {
        sTestDevice = list;
    }

    private static AdNetwork getAdNetWork(BaseAdsAdapter baseAdsAdapter) {
        if (baseAdsAdapter != null) {
            BaseAdsAdapter baseAdsAdapter2 = baseAdsAdapter;
            int n2 = baseAdsAdapter2.getAdNetworkId();
            String string = baseAdsAdapter2.getAdapterVersion();
            String string2 = baseAdsAdapter2.getMediationVersion();
            return new AdNetwork(n2, string, string2);
        }
        return null;
    }

    protected static <T> T createAdapter(Class<T> clazz, String string) throws Exception {
        Constructor<T> constructor = Class.forName(string).asSubclass(clazz).getDeclaredConstructor(null);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    public static String getAdType(int n2) {
        String string = "";
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 4) {
                    string = "Splash";
                }
            } else {
                string = "Native";
            }
        } else {
            string = "Banner";
        }
        return string;
    }

    private static String getAdapterNameFromCache(int n2) {
        AdapterDesc adapterDesc = (AdapterDesc)sAdapterDesc.get(n2);
        if (adapterDesc == null) {
            return "";
        }
        return adapterDesc.getRealName();
    }

    private static JSONObject buildInitReportData(int n2, long l2) {
        JSONObject jSONObject;
        block10: {
            JSONObject jSONObject2;
            int n3;
            try {
                n3 = n2;
            }
            catch (Throwable throwable) {
                return null;
            }
            jSONObject = jSONObject2;
            long l3 = l2;
            JSONObject jSONObject3 = jSONObject;
            int n4 = n2;
            jSONObject();
            Object object = "mid";
            JsonUtil.put(jSONObject3, (String)object, n4);
            object = "duration";
            JsonUtil.put(jSONObject2, (String)object, l3);
            object = AdapterUtil.getCustomAdsAdapter(n3);
            if (object == null) break block10;
            String string = "adapterv";
            try {
                JsonUtil.put(jSONObject, string, ((BaseAdsAdapter)object).getAdapterVersion());
            }
            catch (Throwable throwable) {}
            Object object2 = object;
            object = "msdkv";
            try {
                JsonUtil.put(jSONObject, (String)object, ((BaseAdsAdapter)object2).getMediationVersion());
            }
            catch (Throwable throwable) {}
        }
        return jSONObject;
    }

    private static Map<String, Object> getInitDataMapFromConfig(int n2) {
        Object object;
        Object object2 = DataCache.getInstance().getFromMem("Config", Configurations.class);
        if (object2 != null && (object = ((Configurations)object2).getMs()) != null) {
            Map<String, Placement> map;
            HashMap<String, Object> hashMap;
            if ((object = (Mediation)object.get(n2)) == null) {
                return new HashMap<String, Object>();
            }
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>();
            String string = ((Mediation)object).getK();
            if (string != null) {
                hashMap2.put("AppKey", string);
            }
            if (!(n2 != 7 && n2 != 15 && n2 != 9 || (map = ((Configurations)object2).getPls()) == null || map.isEmpty() || (object2 = map.keySet()).isEmpty())) {
                hashMap2.put("zoneIds", AdapterUtil.buildZoneIds((Set<String>)object2, map, (Mediation)object));
            }
            if (Debugger.isDebugMode() && sTestDevice != null) {
                n2 = 0;
                object2 = AdvertisingIdUtil.getGaid();
                if (!TextUtils.isEmpty((CharSequence)object2)) {
                    object = sTestDevice.iterator();
                    while (object.hasNext()) {
                        if (!TextUtils.equals((CharSequence)object2, (CharSequence)((String)object.next()))) continue;
                        n2 = 1;
                        break;
                    }
                }
                if (n2 != 0) {
                    hashMap2.put("TestMode", Boolean.TRUE);
                }
                hashMap2.put("TestDevice", sTestDevice);
            }
            return hashMap2;
        }
        return new HashMap<String, Object>();
    }

    private static Map<Integer, List<String>> buildZoneIds(Set<String> object, Map<String, Placement> map, Mediation mediation) {
        HashMap hashMap;
        Set<String> set = object;
        object = hashMap;
        hashMap = new HashMap();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            Placement placement = map.get(iterator.next());
            if (placement == null) continue;
            int n2 = placement.getT();
            List list = (List)object.get(n2);
            SparseArray<BaseInstance> sparseArray = placement.getInsMap();
            if (sparseArray == null || sparseArray.size() <= 0) continue;
            int n3 = sparseArray.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                BaseInstance baseInstance = (BaseInstance)sparseArray.valueAt(i2);
                if (baseInstance == null || baseInstance.getMediationId() != mediation.getId()) continue;
                if (list == null) {
                    ArrayList arrayList;
                    list = arrayList;
                    arrayList = new ArrayList();
                    object.put(n2, list);
                }
                list.add(baseInstance.getKey());
            }
        }
        return object;
    }

    static {
        AdapterDesc adapterDesc;
        AdapterDesc adapterDesc2;
        AdapterDesc adapterDesc3;
        AdapterDesc adapterDesc4;
        AdapterDesc adapterDesc5;
        AdapterDesc adapterDesc6;
        AdapterDesc adapterDesc7;
        AdapterDesc adapterDesc8;
        AdapterDesc adapterDesc9;
        AdapterDesc adapterDesc10;
        AdapterDesc adapterDesc11;
        AdapterDesc adapterDesc12;
        AdapterDesc adapterDesc13;
        AdapterDesc adapterDesc14;
        AdapterDesc adapterDesc15;
        AdapterDesc adapterDesc16;
        AdapterDesc adapterDesc17;
        AdapterDesc adapterDesc18;
        AdapterDesc adapterDesc19;
        AdapterDesc adapterDesc20;
        AdapterDesc adapterDesc21;
        ADAPTER_LOCK = new Object();
        sAdapters = new SparseArray();
        sAdapterDesc = new SparseArray();
        sAdapterInitStatus = new ConcurrentHashMap<Integer, Integer>();
        CALLBACK_LOCK = new Object();
        sPendingCallbacks = new ConcurrentHashMap<Integer, List<CustomAdInitCallback>>();
        sAdapterInitStartRecord = new ConcurrentHashMap<Integer, Long>();
        INIT_CALLBACK_MANAGER = new InitCallbackManager();
        AdapterDesc adapterDesc22 = adapterDesc21;
        adapterDesc21 = new AdapterDesc("QWRUaW1pbmc=", false, "6.9.6.1.9.2.1", "6.9.6");
        sAdapterDesc.put(1, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc20;
        adapterDesc20 = new AdapterDesc("QWRNb2I=", false, "21.4.0.1.9.2.1", "21.4.0");
        sAdapterDesc.put(2, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc19;
        adapterDesc19 = new AdapterDesc("RmFjZWJvb2s=", true, "6.12.0.1.9.2.1", "6.12.0");
        sAdapterDesc.put(3, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc18;
        adapterDesc18 = new AdapterDesc("VW5pdHk=", false, "4.5.0.1.9.2.1", "4.5.0");
        sAdapterDesc.put(4, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc17;
        adapterDesc17 = new AdapterDesc("VnVuZ2xl", true, "6.12.0.1.9.2.1", "6.12.0");
        sAdapterDesc.put(5, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc16;
        adapterDesc16 = new AdapterDesc("QWRDb2xvbnk=", false, "4.8.0.1.9.2.1", "4.8.0");
        sAdapterDesc.put(7, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc15;
        adapterDesc15 = new AdapterDesc("QXBwTG92aW4=", true, "11.6.0.1.9.2.1", "11.6.0");
        sAdapterDesc.put(8, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc14;
        adapterDesc14 = new AdapterDesc("TW9QdWI=", false, "5.18.0.1.9.2.1", "5.18.0");
        sAdapterDesc.put(9, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc13;
        adapterDesc13 = new AdapterDesc("VGFwam95", true, "12.11.1.1.9.2.1", "12.11.1");
        sAdapterDesc.put(11, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc12;
        adapterDesc12 = new AdapterDesc("Q2hhcnRib29zdA==", true, "9.1.1.1.9.2.1", "9.1.1");
        sAdapterDesc.put(12, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc11;
        adapterDesc11 = new AdapterDesc("VGlrVG9r", false, "4.6.0.4.1.9.2.1", "4.6.0.4");
        sAdapterDesc.put(13, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc10;
        adapterDesc10 = new AdapterDesc("TWludGVncmFs", true, "16.3.21.1.9.2.1", "16.3.21");
        sAdapterDesc.put(14, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc9;
        adapterDesc9 = new AdapterDesc("SXJvblNvdXJjZQ==", true, "7.2.6.1.9.2.1", "7.2.6");
        sAdapterDesc.put(15, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc8;
        adapterDesc8 = new AdapterDesc("TXlUYXJnZXQ=", true, "5.16.3.1.9.2.1", "5.16.3");
        sAdapterDesc.put(16, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc7;
        adapterDesc7 = new AdapterDesc("SGVsaXVt", true, "2.9.0.1.9.2.1", "2.9.0");
        sAdapterDesc.put(17, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc6;
        adapterDesc6 = new AdapterDesc("Q29sdW1idXM=", true, "2.0.3.0.1.9.2.1", "2.0.3.0");
        sAdapterDesc.put(18, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc5;
        adapterDesc5 = new AdapterDesc("QW1hem9u", false, "9.5.6.1.9.2.1", "9.5.6");
        sAdapterDesc.put(22, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc4;
        adapterDesc4 = new AdapterDesc("SW5Nb2Jp", true, "10.1.1.1.9.2.1", "10.1.1");
        sAdapterDesc.put(23, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc3;
        adapterDesc3 = new AdapterDesc("WWFuZGV4", false, "5.4.1.1.9.2.1", "5.4.1");
        sAdapterDesc.put(24, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc2;
        adapterDesc2 = new AdapterDesc("Qmlnbw==", false, "2.6.2.1.9.2.1", "2.6.2");
        sAdapterDesc.put(25, (Object)adapterDesc22);
        adapterDesc22 = adapterDesc;
        adapterDesc = new AdapterDesc("RnliZXI=", false, "7.8.4.1.9.2.1", "7.8.4");
        sAdapterDesc.put(30, (Object)adapterDesc22);
    }

    private static class AdapterDesc {
        private static final Charset UTF_8 = Charset.forName("UTF-8");
        private static final String MEDIATION_ADAPTER_BASE_PATH = "com.zeus.gmc.sdk.mobileads.mintmediation.adapters.";
        private static final String BID_ADAPTER = "BidAdapter";
        private static final String ADAPTER = "Adapter";
        private static final int SUPPORT_UNKNOWN = 0;
        private static final int SUPPORT_TRUE = 1;
        private static final int SUPPORT_FALSE = 2;
        private final String name;
        private final String supportAdapterVersion;
        private final String supportSDKVersion;
        private final boolean supportBidding;
        private String realName;
        private volatile String realAdapterVersion;
        private volatile String realSDKVersion;

        private AdapterDesc(String string, boolean bl, String string2, String string3) {
            this.name = string;
            this.supportAdapterVersion = string2;
            this.supportBidding = bl;
            this.supportSDKVersion = string3;
        }

        private void setRealAdapterVersion(String string) {
            this.realAdapterVersion = string;
        }

        private void setRealSDKVersion(String string) {
            this.realSDKVersion = string;
        }

        private int getAdapterSupportState() {
            String string;
            if (!TextUtils.isEmpty((CharSequence)((AdapterDesc)((Object)string2)).realAdapterVersion) && (string = ((AdapterDesc)((Object)string2)).supportAdapterVersion) != null && !string.isEmpty()) {
                AdapterDesc adapterDesc = string2;
                String string2 = adapterDesc.realAdapterVersion;
                if (TextUtils.equals((CharSequence)adapterDesc.supportAdapterVersion, (CharSequence)string2)) {
                    return 1;
                }
                return 2;
            }
            return 0;
        }

        private int getSDKSupportState() {
            String string;
            if (!TextUtils.isEmpty((CharSequence)this.realSDKVersion) && (string = this.supportSDKVersion) != null && !string.isEmpty()) {
                string = this.realSDKVersion;
                if (string.contains("MAL_")) {
                    string = string.replace("MAL_", "");
                }
                if (string.contains("aps-android-")) {
                    string = string.replace("aps-android-", "");
                }
                if (TextUtils.equals((CharSequence)this.supportSDKVersion, (CharSequence)string)) {
                    return 1;
                }
                return 2;
            }
            return 0;
        }

        private String getRealName() {
            if (this.realName == null) {
                this.realName = new String(Base64.decode((String)this.name, (int)2), UTF_8);
            }
            return this.realName;
        }

        private String getPackagePath() {
            if (TextUtils.isEmpty((CharSequence)this.name)) {
                return null;
            }
            return MEDIATION_ADAPTER_BASE_PATH.concat(this.getRealName());
        }

        private String getAdapterClassPath() {
            if ((this = ((AdapterDesc)this).getPackagePath()) == null) {
                return null;
            }
            return ((String)this).concat(ADAPTER);
        }

        private String getBidAdapterClassPath() {
            if (!((AdapterDesc)this).supportBidding) {
                return null;
            }
            if ((this = ((AdapterDesc)this).getPackagePath()) == null) {
                return null;
            }
            return ((String)this).concat(BID_ADAPTER);
        }

        private String getAdapterPathWithType(int n2) {
            AdapterDesc adapterDesc = string;
            String string = AdapterUtil.getAdType(n2);
            String string2 = adapterDesc.getPackagePath();
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) && string2 != null) {
                return string2.concat(string);
            }
            return null;
        }
    }

    private static class VersionHelper
    implements CustomAdInitCallback {
        private static final AtomicBoolean mAlreadyStart = new AtomicBoolean(false);
        private final Map<Integer, String> mAdapterVersion;
        private final Map<Integer, String> mSdkVersion;
        private final List<Integer> mWaitInitFinishMediation;
        private final List<Integer> mMissingConfigCannotInitMediation;
        private SparseArray<BaseAdsAdapter> mAdaptersCopy;

        private VersionHelper() {
            CopyOnWriteArrayList copyOnWriteArrayList;
            CopyOnWriteArrayList copyOnWriteArrayList2;
            ConcurrentHashMap concurrentHashMap;
            ConcurrentHashMap concurrentHashMap2;
            Object object = concurrentHashMap2;
            concurrentHashMap2 = new ConcurrentHashMap();
            v1.mAdapterVersion = object;
            object = concurrentHashMap;
            concurrentHashMap = new ConcurrentHashMap();
            v1.mSdkVersion = object;
            object = copyOnWriteArrayList2;
            copyOnWriteArrayList2 = new CopyOnWriteArrayList();
            v1.mWaitInitFinishMediation = object;
            object = copyOnWriteArrayList;
            copyOnWriteArrayList = new CopyOnWriteArrayList();
            v1.mMissingConfigCannotInitMediation = object;
        }

        private void onAdapterInitFinish(int n2) {
            VersionHelper versionHelper = this;
            versionHelper.mWaitInitFinishMediation.remove((Object)n2);
            if (versionHelper.mWaitInitFinishMediation.isEmpty()) {
                this.onVersionsLoadComplete();
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void onVersionsLoadComplete() {
            block21: {
                Object object;
                VersionHelper versionHelper = iterator;
                Object object2 = versionHelper.getMediations();
                Set<Integer> set = versionHelper.mAdapterVersion.keySet();
                MLog.d(AdapterUtil.TAG, "integration check start");
                for (Integer n2 : set) {
                    object = (AdapterDesc)sAdapterDesc.get(n2.intValue());
                    if (object == null) {
                        MLog.e(AdapterUtil.TAG, "unknown Ad networking " + n2 + " please upgrade mint mediation sdk");
                        continue;
                    }
                    AdapterDesc adapterDesc = object;
                    Object object3 = iterator;
                    String string = ((VersionHelper)object3).mAdapterVersion.get(n2);
                    String string2 = ((VersionHelper)object3).mSdkVersion.get(n2);
                    adapterDesc.setRealSDKVersion(string2);
                    int n3 = adapterDesc.getAdapterSupportState();
                    int n4 = adapterDesc.getSDKSupportState();
                    if (2 == n3) {
                        MLog.e(AdapterUtil.TAG, ((AdapterDesc)object).getRealName() + " adapter version " + string + " is not support, support version is " + ((AdapterDesc)object).supportAdapterVersion);
                    } else if (1 == n3) {
                        MLog.d(AdapterUtil.TAG, ((AdapterDesc)object).getRealName() + " adapter version " + string);
                    } else {
                        MLog.w(AdapterUtil.TAG, ((AdapterDesc)object).getRealName() + " adapter missing");
                    }
                    if (2 == n4) {
                        MLog.w(AdapterUtil.TAG, ((AdapterDesc)object).getRealName() + " sdk version " + string2 + " is not support, support version is " + ((AdapterDesc)object).supportSDKVersion);
                    } else if (1 == n4) {
                        MLog.d(AdapterUtil.TAG, ((AdapterDesc)object).getRealName() + " sdk version " + string2);
                    } else if (((VersionHelper)((Object)iterator)).mMissingConfigCannotInitMediation.contains(n2)) {
                        MLog.w(AdapterUtil.TAG, ((AdapterDesc)object).getRealName() + " sdk missing key to init");
                    } else {
                        MLog.d(AdapterUtil.TAG, ((AdapterDesc)object).getRealName() + " sdk missing");
                    }
                    if (object2 == null) continue;
                    object2.remove(n2);
                }
                if (object2 == null || object2.isEmpty()) break block21;
                Iterator<Integer> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    AdapterDesc adapterDesc;
                    block22: {
                        int n5;
                        block24: {
                            block23: {
                                object2 = (Integer)iterator.next();
                                adapterDesc = (AdapterDesc)sAdapterDesc.get(((Integer)object2).intValue());
                                if (adapterDesc == null) {
                                    MLog.e(AdapterUtil.TAG, "unknown Ad networking " + object2 + " please upgrade mint mediation sdk");
                                    continue;
                                }
                                String string = adapterDesc.getAdapterClassPath();
                                if (string == null) break block22;
                                n5 = 0;
                                object = AdapterUtil.getAdapterVersion((Integer)object2, null);
                                if (!TextUtils.isEmpty((CharSequence)object)) break block23;
                                try {
                                    Class.forName(string);
                                }
                                catch (Throwable throwable) {}
                                break block24;
                            }
                            n5 = 1;
                            break block24;
                            catch (ClassNotFoundException classNotFoundException) {}
                        }
                        if (n5 != 0) {
                            if (TextUtils.isEmpty((CharSequence)object)) {
                                MLog.e(AdapterUtil.TAG, adapterDesc.getRealName() + " adapter create failed, adapter version not match mint sdk version");
                                continue;
                            }
                            n5 = adapterDesc.getAdapterSupportState();
                            if (2 == n5) {
                                MLog.e(AdapterUtil.TAG, adapterDesc.getRealName() + " adapter create failed, adapter version " + (String)object + " not support, support version is " + adapterDesc.supportAdapterVersion);
                                continue;
                            }
                            if (1 == n5) {
                                MLog.e(AdapterUtil.TAG, adapterDesc.getRealName() + " adapter version " + (String)object + " is support but create failed, please confirm " + adapterDesc.getRealName() + " sdk has been integrated");
                                continue;
                            }
                            MLog.e(AdapterUtil.TAG, adapterDesc.getRealName() + " adapter create failed, adapter version may not match mint sdk version");
                            continue;
                        }
                        MLog.e(AdapterUtil.TAG, adapterDesc.getRealName() + " adapter create failed, please confirm " + adapterDesc.getRealName() + " adapter and sdk has been integrated.");
                        continue;
                    }
                    MLog.e(AdapterUtil.TAG, adapterDesc.getRealName() + " mint not support");
                }
            }
            MLog.d(AdapterUtil.TAG, "integration check finish");
        }

        private Set<Integer> getMediations() {
            HashSet<Integer> hashSet;
            Object object = DataCache.getInstance().getFromMem("Config", Configurations.class);
            if (object == null) {
                return null;
            }
            if ((object = object.getMs()) == null) {
                return null;
            }
            HashSet<Integer> hashSet2 = hashSet;
            hashSet = new HashSet<Integer>();
            int n2 = object.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                hashSet2.add(object.keyAt(i2));
            }
            return hashSet2;
        }

        static /* synthetic */ SparseArray access$2202(VersionHelper versionHelper, SparseArray sparseArray) {
            versionHelper.mAdaptersCopy = sparseArray;
            return sparseArray;
        }

        void startCheckAdapterVersion(final Context context) {
            if (context == null) {
                return;
            }
            if (!mAlreadyStart.compareAndSet(false, true)) {
                return;
            }
            context = context.getApplicationContext();
            MintPoolExecuter.execute(ExecutorEnum.WorkExecutor, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    int n2;
                    1 v0 = this;
                    mAdapterVersion.clear();
                    mSdkVersion.clear();
                    mWaitInitFinishMediation.clear();
                    Object object = ADAPTER_LOCK;
                    // MONITORENTER : object
                    VersionHelper.access$2202(this, sAdapters.clone());
                    int n3 = mAdaptersCopy.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        String string;
                        int n4;
                        block23: {
                            String string2;
                            block20: {
                                BaseAdsAdapter baseAdsAdapter;
                                block21: {
                                    Object object2;
                                    block22: {
                                        n4 = mAdaptersCopy.keyAt(n2);
                                        string = AdapterUtil.getAdapterVersion(n4, baseAdsAdapter = (BaseAdsAdapter)mAdaptersCopy.get(n4));
                                        if (string != null) {
                                            mAdapterVersion.put(n4, string);
                                        }
                                        string = null;
                                        if (n4 != 7) break block21;
                                        try {
                                            object2 = Class.forName("com.adcolony.sdk.q");
                                            Method method = ((Class)object2).getDeclaredMethod("I", new Class[0]);
                                            method.setAccessible(true);
                                            Constructor<?> constructor = ((Class)object2).getDeclaredConstructors()[0];
                                            constructor.setAccessible(true);
                                            string = (String)method.invoke(constructor.newInstance(new Object[0]), new Object[0]);
                                        }
                                        catch (Throwable throwable) {}
                                        if (!TextUtils.isEmpty((CharSequence)string) || !AdapterUtil.isAdNetworkInitSucceed(n4)) break block22;
                                        if (baseAdsAdapter == null) break block23;
                                        try {
                                            string2 = baseAdsAdapter.getMediationVersion();
                                            break block20;
                                        }
                                        catch (Exception exception) {}
                                    }
                                    if (TextUtils.isEmpty((CharSequence)string)) {
                                        boolean bl = false;
                                        object2 = DataCache.getInstance().getFromMem("Config", Configurations.class);
                                        if (object2 != null && (object2 = ((Configurations)object2).getMs()) != null && (object2 = (Mediation)object2.get(n4)) != null && !TextUtils.isEmpty((CharSequence)((Mediation)object2).getK())) {
                                            bl = true;
                                            mWaitInitFinishMediation.add(n4);
                                        }
                                        if (!bl) {
                                            mMissingConfigCannotInitMediation.add(n4);
                                        }
                                    }
                                    break block23;
                                }
                                if (baseAdsAdapter == null) break block23;
                                string2 = baseAdsAdapter.getMediationVersion();
                            }
                            string = string2;
                        }
                        if (string == null) continue;
                        mSdkVersion.put(n4, string);
                    }
                    if (mWaitInitFinishMediation.isEmpty()) {
                        this.onVersionsLoadComplete();
                        return;
                    }
                    ArrayList arrayList = new ArrayList(mWaitInitFinishMediation.size());
                    arrayList.addAll(mWaitInitFinishMediation);
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        Integer n5 = (Integer)iterator.next();
                        n2 = n5;
                        AdapterUtil.initAdNetworkWithDefaultConfig(context, n2, this);
                    }
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onAdapterInitSucceed(int n2) {
            block4: {
                Object object = (BaseAdsAdapter)this.mAdaptersCopy.get(n2);
                if (object != null) {
                    try {
                        object = ((BaseAdsAdapter)object).getMediationVersion();
                        if (object == null) break block4;
                        this.mSdkVersion.put(n2, (String)object);
                    }
                    catch (Exception exception) {}
                }
            }
            this.onAdapterInitFinish(n2);
        }

        @Override
        public void onAdapterInitFailed(int n2, AdapterError adapterError) {
            this.onAdapterInitFinish(n2);
        }
    }

    private static class InitCallbackManager
    extends Handler
    implements CustomAdInitCallback {
        private final Map<Integer, Boolean> mAlreadyCallbackSucceed = new ConcurrentHashMap<Integer, Boolean>();

        InitCallbackManager() {
            super(Looper.getMainLooper());
        }

        private void handleInitSucceed(final int n2) {
            sAdapterInitStatus.put(n2, 3);
            if (Boolean.TRUE.equals(this.mAlreadyCallbackSucceed.get(n2))) {
                return;
            }
            this.mAlreadyCallbackSucceed.put(n2, Boolean.TRUE);
            Object object = (Long)sAdapterInitStartRecord.get(n2);
            long l2 = -1L;
            if (object != null) {
                l2 = SystemClock.elapsedRealtime() - (Long)object;
            }
            EventUtil.getInstance().onInsInitSuccessReport(AdapterUtil.buildInitReportData(n2, l2));
            if (Looper.getMainLooper() == Looper.myLooper()) {
                this.callbackSuccessOnMain(n2);
            } else {
                Runnable runnable;
                object = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        this.callbackSuccessOnMain(n2);
                    }
                };
                this.post((Runnable)object);
            }
        }

        private void handleInitTimeout(final int n2, long l2, final CustomAdInitCallback customAdInitCallback, final AdapterError adapterError) {
            if (Looper.getMainLooper() == Looper.myLooper()) {
                initCallbackManager.callbackFailedOnMain(n2, customAdInitCallback, adapterError);
            } else {
                Runnable runnable;
                Runnable runnable2 = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        2 v0 = this;
                        int n22 = v0.n2;
                        CustomAdInitCallback customAdInitCallback2 = v0.customAdInitCallback;
                        AdapterError adapterError2 = v0.adapterError;
                        initCallbackManager.callbackFailedOnMain(n22, customAdInitCallback2, adapterError2);
                    }
                };
                initCallbackManager.post(runnable2);
            }
            final InitCallbackManager initCallbackManager = AdapterUtil.buildInitReportData(n2, l2);
            if (initCallbackManager != null && adapterError != null) {
                JSONObject jSONObject;
                JSONObject jSONObject2 = jSONObject;
                jSONObject2();
                JsonUtil.put(jSONObject2, "code", adapterError.getCode());
                JsonUtil.put(jSONObject, "message", adapterError.getMessage());
                JsonUtil.put((JSONObject)initCallbackManager, "msg", jSONObject2);
            }
            EventUtil.getInstance().onInsInitFailedReport((JSONObject)initCallbackManager);
        }

        private void handleInitFailed(int n2, AdapterError adapterError) {
            Object object = (Integer)sAdapterInitStatus.get(n2);
            if (object != null && 3 == (Integer)object) {
                return;
            }
            sAdapterInitStatus.put(n2, 1);
            if (Looper.getMainLooper() == Looper.myLooper()) {
                ((InitCallbackManager)object2).callbackFailedOnMain(n2, null, adapterError);
            } else {
                Runnable runnable;
                object = runnable;
                runnable = new Runnable((InitCallbackManager)object2, n2, adapterError){
                    final /* synthetic */ int val$mediationId;
                    final /* synthetic */ AdapterError val$adapterError;
                    final /* synthetic */ InitCallbackManager this$0;
                    {
                        this.this$0 = initCallbackManager;
                        this.val$mediationId = n2;
                        this.val$adapterError = adapterError;
                    }

                    @Override
                    public void run() {
                        3 v0 = this;
                        int n2 = v0.val$mediationId;
                        AdapterError adapterError = v0.val$adapterError;
                        this.this$0.callbackFailedOnMain(n2, null, adapterError);
                    }
                };
                object2.post((Runnable)object);
            }
            long l2 = -1L;
            Object object2 = (Long)sAdapterInitStartRecord.get(n2);
            if (object2 != null) {
                l2 = SystemClock.elapsedRealtime() - (Long)object2;
            }
            if ((object2 = AdapterUtil.buildInitReportData(n2, l2)) != null && adapterError != null) {
                JSONObject jSONObject;
                JSONObject jSONObject2 = jSONObject;
                jSONObject2();
                JsonUtil.put(jSONObject2, "code", adapterError.getCode());
                JsonUtil.put(jSONObject, "message", adapterError.getMessage());
                JsonUtil.put((JSONObject)object2, "msg", jSONObject2);
            }
            EventUtil.getInstance().onInsInitFailedReport((JSONObject)object2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callbackSuccessOnMain(int n2) {
            Iterator iterator = CALLBACK_LOCK;
            synchronized (iterator) {
                ArrayList arrayList;
                Object object2;
                block10: {
                    object2 = (List)sPendingCallbacks.get(n2);
                    if (object2 != null) break block10;
                    return;
                }
                ArrayList arrayList2 = arrayList;
                Iterator iterator2 = iterator;
                List list = object2;
                arrayList2(object2.size());
                arrayList2.addAll(object2);
                list.clear();
                sPendingCallbacks.remove(n2);
                // ** MonitorExit[v1] (shouldn't be in output)
                for (Object object2 : arrayList) {
                    try {
                        this.removeCallbacksAndMessages(object2);
                        object2.onAdapterInitSucceed(n2);
                    }
                    catch (Throwable throwable) {
                        CrashUtil.getSingleton().saveException(throwable);
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void callbackFailedOnMain(int var1_1, CustomAdInitCallback var2_2, AdapterError var3_6) {
            this = AdapterUtil.access$1600();
            synchronized (this) {
                block19: {
                    block18: {
                        var4_7 = (List)AdapterUtil.access$1700().get(var1_1);
                        if (var4_7 != null) break block18;
                        return;
                    }
                    if (var2_2 == null) {
                        var2_3 = false;
                        var5_8 = v0;
                        var5_8(var4_7.size());
                        v0.addAll(var4_7);
                        var5_9 = var2_3;
                        var6_10 = var5_8;
                    } else {
                        var5_9 = true;
                        var6_10 = v1;
                        var6_10(1);
                        v1.add(var2_2);
                    }
                    v2 = var4_7;
                    v3 = v2;
                    v2.removeAll(var6_10);
                    if (!v3.isEmpty()) break block19;
                    AdapterUtil.access$1700().remove(var1_1);
                }
                ** try [egrp 9[TRYBLOCK] [9 : 126->130)] { 
            }
lbl37:
            // 5 sources

            for (CustomAdInitCallback var2_4 : var6_10) {
                if (!var5_9) ** GOTO lbl46
                if (!(var2_4 instanceof CustomAdInitTimeoutCallback)) ** GOTO lbl44
                try {
                    ((CustomAdInitTimeoutCallback)var2_4).onAdapterInitTimeout(var1_1, var3_6);
                    continue;
lbl44:
                    // 1 sources

                    var2_4.onAdapterInitFailed(var1_1, var3_6);
                    continue;
lbl46:
                    // 1 sources

                    var2_4.onAdapterInitFailed(var1_1, var3_6);
                }
                catch (Throwable var2_5) {
                    CrashUtil.getSingleton().saveException(var2_5);
                }
            }
            return;
lbl-1000:
            // 8 sources

            {
                catch (Throwable v4) {
                    throw v4;
                }
            }
        }

        void onTimeoutCallbackRequest(int n2, long l2, CustomAdInitCallback customAdInitCallback) {
            InitCallbackManager initCallbackManager = initCallbackManager2;
            initCallbackManager2.removeMessages(n2);
            InitCallbackManager initCallbackManager2 = Message.obtain((Handler)initCallbackManager, (int)n2);
            ((Message)initCallbackManager2).what = n2;
            ((Message)initCallbackManager2).arg1 = (int)l2;
            ((Message)initCallbackManager2).obj = customAdInitCallback;
            initCallbackManager.sendMessageDelayed((Message)initCallbackManager2, l2);
        }

        public void handleMessage(Message object) {
            Message message = object;
            int n2 = message.what;
            String string = AdapterUtil.getAdapterNameFromCache(n2);
            Object object2 = message.obj;
            if (!(object2 instanceof CustomAdInitCallback)) {
                return;
            }
            InitCallbackManager initCallbackManager = customAdInitCallback;
            int n3 = object.arg1;
            CustomAdInitCallback customAdInitCallback = (CustomAdInitCallback)object2;
            object = AdapterErrorBuilder.buildInitError("", string, 132, "timeout");
            MLog.d(AdapterUtil.TAG, string + " init failed, timeout after " + n3 + " ms");
            initCallbackManager.handleInitTimeout(n2, n3, customAdInitCallback, (AdapterError)object);
        }

        @Override
        public void onAdapterInitSucceed(int n2) {
            try {
                this.removeMessages(n2);
                this.handleInitSucceed(n2);
            }
            catch (Throwable throwable) {
                CrashUtil.getSingleton().saveException(throwable);
            }
        }

        @Override
        public void onAdapterInitFailed(int n2, AdapterError adapterError) {
            InitCallbackManager initCallbackManager = string;
            int n3 = n2;
            AdapterError adapterError2 = adapterError;
            InitCallbackManager initCallbackManager2 = string;
            int n4 = n2;
            int n5 = n4;
            String string = AdapterUtil.getAdapterNameFromCache(n4);
            try {
                MLog.w(AdapterUtil.TAG, (String)string + " init failed");
                initCallbackManager2.removeMessages(n5);
                initCallbackManager.handleInitFailed(n3, adapterError2);
            }
            catch (Throwable throwable) {
                CrashUtil.getSingleton().saveException(throwable);
            }
        }
    }
}

