/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;

public class DensityUtil {
    private DensityUtil() {
    }

    public static int dip2px(Context context, float f2) {
        context = context.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)1, (float)f2, (DisplayMetrics)context);
    }

    public static int px2dip(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().densityDpi;
        return (int)(f2 * 160.0f / f3 + 0.5f);
    }

    public static int getDirection(Context context) {
        if (context == null) {
            return 0;
        }
        return context.getResources().getConfiguration().orientation;
    }

    public static DisplayMetrics getDisplay(Context context) {
        if (context == null) {
            return null;
        }
        return context.getResources().getDisplayMetrics();
    }

    public static int getPhoneWidth(Context context) {
        return DensityUtil.getDisplay((Context)context).widthPixels;
    }

    public static int getPhoneHeight(Context context) {
        return DensityUtil.getDisplay((Context)context).heightPixels;
    }

    public static int getDensityDpi(Context context) {
        return DensityUtil.getDisplay((Context)context).densityDpi;
    }

    public static int getDimSize() {
        return Resources.getSystem().getConfiguration().screenLayout & 0xF;
    }

    public static int getXdpi(Context context) {
        return (int)DensityUtil.getDisplay((Context)context).xdpi;
    }

    public static int getYdpi(Context context) {
        return (int)DensityUtil.getDisplay((Context)context).ydpi;
    }

    public static int getScreenDensity() {
        int n2 = Resources.getSystem().getDisplayMetrics().densityDpi;
        int n3 = 140;
        int n4 = 200;
        if (n2 == 0) {
            return 1;
        }
        if (n2 < n3) {
            return 0;
        }
        if (n2 > n4) {
            return 2;
        }
        return 1;
    }

    public static int getScreenSize() {
        switch (Resources.getSystem().getConfiguration().screenLayout & 0xF) {
            default: {
                return 0;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 1: 
        }
        return 1;
    }
}

