/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class IOUtil {
    private static final String TAG = "IOUtil";

    private IOUtil() {
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                MLog.d(TAG, TAG, exception);
                CrashUtil.getSingleton().saveException(exception);
            }
        }
    }

    public static void flushQuietly(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                MLog.d(TAG, TAG, exception);
                CrashUtil.getSingleton().saveException(exception);
            }
        }
    }

    public static BufferedInputStream toBufferedInputStream(InputStream inputStream) {
        InputStream inputStream2;
        if (inputStream instanceof BufferedInputStream) {
            inputStream = (BufferedInputStream)inputStream;
            inputStream2 = inputStream;
        } else {
            BufferedInputStream bufferedInputStream;
            inputStream2 = bufferedInputStream;
            bufferedInputStream = new BufferedInputStream(inputStream);
        }
        return inputStream2;
    }

    public static BufferedOutputStream toBufferedOutputStream(OutputStream outputStream) {
        OutputStream outputStream2;
        if (outputStream instanceof BufferedOutputStream) {
            outputStream = (BufferedOutputStream)outputStream;
            outputStream2 = outputStream;
        } else {
            BufferedOutputStream bufferedOutputStream;
            outputStream2 = bufferedOutputStream;
            bufferedOutputStream = new BufferedOutputStream(outputStream);
        }
        return outputStream2;
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        Reader reader2;
        if (reader instanceof BufferedReader) {
            reader = (BufferedReader)reader;
            reader2 = reader;
        } else {
            BufferedReader bufferedReader;
            reader2 = bufferedReader;
            bufferedReader = new BufferedReader(reader);
        }
        return reader2;
    }

    public static BufferedWriter toBufferedWriter(Writer writer) {
        Writer writer2;
        if (writer instanceof BufferedWriter) {
            writer = (BufferedWriter)writer;
            writer2 = writer;
        } else {
            BufferedWriter bufferedWriter;
            writer2 = bufferedWriter;
            bufferedWriter = new BufferedWriter(writer);
        }
        return writer2;
    }

    public static InputStream toInputStream(CharSequence charSequence) {
        return new ByteArrayInputStream(charSequence.toString().getBytes(Charset.forName("UTF-8")));
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtil.toInputStream(charSequence, Charset.forName(string));
    }

    public static InputStream toInputStream(CharSequence object, Charset charset) {
        object = object.toString().getBytes(charset);
        return new ByteArrayInputStream((byte[])object);
    }

    public static InputStreamReader toInputStreamReader(InputStream inputStream) {
        return new InputStreamReader(inputStream, Charset.forName("UTF-8"));
    }

    public static InputStreamReader toInputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        return new InputStreamReader(inputStream, string);
    }

    public static String toString(InputStream inputStream) throws IOException {
        return new String(IOUtil.toByteArray(inputStream), Charset.forName("UTF-8"));
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        return new String(IOUtil.toByteArray(inputStream), string);
    }

    public static String toString(InputStream inputStream, Charset charset) throws IOException {
        return new String(IOUtil.toByteArray(inputStream), charset);
    }

    public static String toString(Reader reader) throws IOException {
        return new String(IOUtil.toByteArray(reader), Charset.forName("UTF-8"));
    }

    public static String toString(Reader reader, String string) throws IOException {
        return new String(IOUtil.toByteArray(reader), string);
    }

    public static String toString(Reader reader, Charset charset) throws IOException {
        return new String(IOUtil.toByteArray(reader), charset);
    }

    public static String toString(byte[] byArray) {
        return new String(byArray, Charset.forName("UTF-8"));
    }

    public static String toString(byte[] byArray, String string) {
        return IOUtil.toString(byArray, Charset.forName(string));
    }

    public static String toString(byte[] byArray, Charset charset) {
        return new String(byArray, charset);
    }

    public static byte[] toByteArray(CharSequence charSequence) {
        if (charSequence == null) {
            return new byte[0];
        }
        return charSequence.toString().getBytes(Charset.forName("UTF-8"));
    }

    public static byte[] toByteArray(CharSequence charSequence, String string) {
        return IOUtil.toByteArray(charSequence, Charset.forName(string));
    }

    public static byte[] toByteArray(CharSequence charSequence, Charset charset) {
        if (charSequence == null) {
            return new byte[0];
        }
        return charSequence.toString().getBytes(charset);
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2;
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream3();
        IOUtil.write(inputStream, (OutputStream)byteArrayOutputStream3);
        byteArrayOutputStream.close();
        inputStream.close();
        return byteArrayOutputStream2.toByteArray();
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) throws IOException {
        if (n2 >= 0) {
            int n3;
            int n4;
            if (n2 == 0) {
                return new byte[0];
            }
            byte[] byArray = new byte[n2];
            for (n3 = 0; n3 < n2; n3 += n4) {
                n4 = n2 - n3;
                if ((n4 = inputStream.read(byArray, n3, n4)) == -1) break;
            }
            if (n3 == n2) {
                return byArray;
            }
            throw new IOException("Unexpected byte count size. current: " + n3 + ", excepted: " + n2);
        }
        throw new IllegalArgumentException("Size must be equal or greater than zero: " + n2);
    }

    public static byte[] toByteArray(Reader reader) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.write(reader, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(Reader reader, String string) throws IOException {
        return IOUtil.toByteArray(reader, Charset.forName(string));
    }

    public static byte[] toByteArray(Reader reader, Charset charset) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtil.write(reader, (OutputStream)byteArrayOutputStream, charset);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static char[] toCharArray(CharSequence charSequence) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtil.write((Writer)charArrayWriter, charSequence);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream closeable) throws IOException {
        CharArrayWriter charArrayWriter;
        InputStream inputStream = closeable;
        closeable = charArrayWriter;
        IOUtil.write(inputStream, (Writer)new CharArrayWriter());
        return ((CharArrayWriter)closeable).toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) throws IOException {
        return IOUtil.toCharArray(inputStream, Charset.forName(string));
    }

    public static char[] toCharArray(InputStream closeable, Charset charset) throws IOException {
        CharArrayWriter charArrayWriter;
        InputStream inputStream = closeable;
        closeable = charArrayWriter;
        IOUtil.write(inputStream, (Writer)new CharArrayWriter(), charset);
        return ((CharArrayWriter)closeable).toCharArray();
    }

    public static char[] toCharArray(Reader closeable) throws IOException {
        CharArrayWriter charArrayWriter;
        Reader reader = closeable;
        closeable = charArrayWriter;
        IOUtil.write(reader, (Writer)new CharArrayWriter());
        return ((CharArrayWriter)closeable).toCharArray();
    }

    public static List<String> readLines(InputStream inputStream, String string) throws IOException {
        return IOUtil.readLines(inputStream, Charset.forName(string));
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) throws IOException {
        return IOUtil.readLines(new InputStreamReader(inputStream, charset));
    }

    public static List<String> readLines(InputStream inputStream) throws IOException {
        return IOUtil.readLines(new InputStreamReader(inputStream, Charset.forName("UTF-8")));
    }

    public static List<String> readLines(Reader reader) throws IOException {
        ArrayList<String> arrayList;
        reader = IOUtil.toBufferedReader(reader);
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        String string = ((BufferedReader)reader).readLine();
        while (string != null) {
            arrayList2.add(string);
            string = ((BufferedReader)reader).readLine();
        }
        return arrayList2;
    }

    public static void write(OutputStream outputStream, byte[] byArray) throws IOException {
        if (byArray != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(byArray);
            outputStream2.flush();
        }
    }

    public static void write(Writer object, byte[] byArray) throws IOException {
        if (byArray != null) {
            String string;
            Writer writer = object;
            object = string;
            string = new String(byArray, Charset.forName("UTF-8"));
            writer.write((String)object);
            writer.flush();
        }
    }

    public static void write(Writer writer, byte[] byArray, String string) throws IOException {
        IOUtil.write(writer, byArray, Charset.forName(string));
    }

    public static void write(Writer object, byte[] byArray, Charset charset) throws IOException {
        if (byArray != null) {
            String string;
            Writer writer = object;
            object = string;
            string = new String(byArray, charset);
            writer.write((String)object);
            writer.flush();
        }
    }

    public static void write(Writer writer, char[] cArray) throws IOException {
        if (cArray != null) {
            Writer writer2 = writer;
            writer2.write(cArray);
            writer2.flush();
        }
    }

    public static void write(OutputStream outputStream, char[] cArray) throws IOException {
        if (cArray != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(new String(cArray).getBytes(Charset.forName("UTF-8")));
            outputStream2.flush();
        }
    }

    public static void write(OutputStream outputStream, char[] cArray, String string) throws IOException {
        IOUtil.write(outputStream, cArray, Charset.forName(string));
    }

    public static void write(OutputStream outputStream, char[] cArray, Charset charset) throws IOException {
        if (cArray != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(new String(cArray).getBytes(charset));
            outputStream2.flush();
        }
    }

    public static void write(Writer writer, CharSequence charSequence) throws IOException {
        if (charSequence != null) {
            Writer writer2 = writer;
            writer2.write(charSequence.toString());
            writer2.flush();
        }
    }

    public static void write(OutputStream outputStream, CharSequence charSequence) throws IOException {
        if (charSequence != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(charSequence.toString().getBytes(Charset.forName("UTF-8")));
            outputStream2.flush();
        }
    }

    public static void write(OutputStream outputStream, CharSequence charSequence, String string) throws IOException {
        IOUtil.write(outputStream, charSequence, Charset.forName(string));
    }

    public static void write(OutputStream outputStream, CharSequence charSequence, Charset charset) throws IOException {
        if (charSequence != null) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(charSequence.toString().getBytes(charset));
            outputStream2.flush();
        }
    }

    public static void write(Reader closeable, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter;
        Reader reader = closeable;
        closeable = outputStreamWriter;
        outputStreamWriter = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        IOUtil.write(reader, (Writer)closeable);
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            OutputStream outputStream2 = outputStream;
            outputStream2.write(byArray, 0, n2);
            outputStream2.flush();
        }
    }

    public static void write(InputStream inputStream, Writer writer) throws IOException {
        IOUtil.write((Reader)new InputStreamReader(inputStream, Charset.forName("UTF-8")), writer);
    }

    public static void write(Reader reader, OutputStream outputStream, String string) throws IOException {
        IOUtil.write(reader, outputStream, Charset.forName(string));
    }

    public static void write(Reader closeable, OutputStream outputStream, Charset charset) throws IOException {
        OutputStreamWriter outputStreamWriter;
        Reader reader = closeable;
        closeable = outputStreamWriter;
        outputStreamWriter = new OutputStreamWriter(outputStream, charset);
        IOUtil.write(reader, (Writer)closeable);
    }

    public static void write(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        IOUtil.write(inputStream, outputStream, Charset.forName(string));
    }

    public static void write(InputStream inputStream, OutputStream outputStream, Charset charset) throws IOException {
        IOUtil.write((Reader)new InputStreamReader(inputStream, charset), outputStream);
    }

    public static void write(InputStream inputStream, Writer writer, String string) throws IOException {
        IOUtil.write(inputStream, writer, Charset.forName(string));
    }

    public static void write(InputStream inputStream, Writer writer, Charset charset) throws IOException {
        IOUtil.write((Reader)new InputStreamReader(inputStream, charset), writer);
    }

    public static void write(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[4096];
        while (-1 != (n2 = reader.read(cArray))) {
            Writer writer2 = writer;
            writer2.write(cArray, 0, n2);
            writer2.flush();
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.flush();
    }

    public static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        if (file != null && file.exists()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static void writeToFile(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = fileOutputStream;
        fileOutputStream2(file);
        IOUtil.copy(inputStream, fileOutputStream2);
        IOUtil.closeQuietly(fileOutputStream);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToFile(byte[] byArray, File file) throws IOException {
        void var0_3;
        FileOutputStream fileOutputStream;
        block6: {
            byte[] byArray2;
            FileOutputStream fileOutputStream2;
            Object var2_5 = null;
            fileOutputStream = fileOutputStream2;
            try {
                byArray2 = byArray;
                fileOutputStream(file);
            }
            catch (Throwable throwable) {
                fileOutputStream = var2_5;
                break block6;
            }
            try {
                fileOutputStream2.write(byArray2);
            }
            catch (Throwable throwable) {
                break block6;
            }
            IOUtil.closeQuietly(fileOutputStream2);
            return;
        }
        if (fileOutputStream != null) {
            IOUtil.closeQuietly(fileOutputStream);
        }
        throw var0_3;
    }
}

