/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;

public class MLog {
    private static final String TAG = "MLog";
    private static final String MAIN_THREAD = "Main";
    private static final String DEF_PROCESS = "Def";
    private static final int MAX_CHAR_SIZE_PER_LOG = 3000;
    private static final int ERROR = 0;
    private static final int WARN = 1;
    private static final int INFO = 2;
    private static final int DEBUG = 3;
    private static final int VERBOSE = 4;
    private static int sLogLevel = 1;
    private static final long sMainThreadId = Looper.getMainLooper().getThread().getId();
    private static String sPrefix = "MINT";
    private static String sPackageNameSuffix;
    private static volatile String sProcess;

    public static void setLogLevel(int n2) {
        sLogLevel = n2;
    }

    public static int getLogLevel() {
        return sLogLevel;
    }

    public static void setDebugOn(boolean bl) {
        sLogLevel = bl ? 1000 : 1;
    }

    public static void setDebugOff() {
        sLogLevel = 1;
    }

    public static void init(Context context, String string) {
        MLog.init(context, string, true);
    }

    public static void init(final Context context, String object, boolean bl) {
        Runnable runnable;
        if (context != null && bl) {
            sPackageNameSuffix = MLog.getSuffix(context.getPackageName(), ".");
        }
        sPrefix = object;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                sProcess = MLog.getCurrentProcessName(context);
            }
        };
        new Thread((Runnable)object).start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getCurrentProcessName(Context context) {
        ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
        block13: {
            Object object;
            int n2;
            block12: {
                if (context == null) {
                    return null;
                }
                Context context2 = context;
                n2 = Process.myPid();
                object = (ActivityManager)context2.getSystemService("activity");
                if (object != null) break block12;
                return null;
            }
            object = object.getRunningAppProcesses().iterator();
            while (true) {
                if (!object.hasNext()) return null;
                runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo.pid != n2) continue;
                break;
            }
            if (TextUtils.isEmpty((CharSequence)runningAppProcessInfo.processName)) return String.valueOf(runningAppProcessInfo.pid);
            if (!TextUtils.equals((CharSequence)runningAppProcessInfo.processName, (CharSequence)context.getPackageName())) break block13;
            return DEF_PROCESS;
        }
        try {
            return MLog.getSuffix(runningAppProcessInfo.processName, ":");
        }
        catch (Exception exception) {
            MLog.e(TAG, "getCurrentProcessNameException", exception);
        }
        return null;
    }

    public static void setLogPrefix(String string) {
        sPrefix = string;
    }

    public static void d(String string, String string2) {
        if (sLogLevel >= 3) {
            MLog.log(MLog.addAdPrefix(string), string2, 3);
        }
    }

    public static void d(String string, String string2, Throwable throwable) {
        if (sLogLevel >= 3) {
            Log.d((String)MLog.addAdPrefix(string), (String)MLog.getPatternedMsg(string2, throwable));
        }
    }

    public static void e(String string, String string2) {
        if (sLogLevel >= 0) {
            MLog.log(MLog.addAdPrefix(string), string2, 0);
        }
    }

    public static void e(String string, String string2, Throwable throwable) {
        if (sLogLevel >= 0) {
            Log.e((String)MLog.addAdPrefix(string), (String)MLog.getPatternedMsg(string2, throwable));
        }
    }

    public static void w(String string, String string2) {
        if (sLogLevel >= 1) {
            MLog.log(MLog.addAdPrefix(string), string2, 1);
        }
    }

    public static void w(String string, String string2, Throwable throwable) {
        if (sLogLevel >= 1) {
            Log.w((String)MLog.addAdPrefix(string), (String)MLog.getPatternedMsg(string2, throwable));
        }
    }

    public static void i(String string, String string2) {
        if (sLogLevel >= 2) {
            MLog.log(MLog.addAdPrefix(string), string2, 2);
        }
    }

    public static void i(String string, String string2, Throwable throwable) {
        if (sLogLevel >= 2) {
            Log.i((String)MLog.addAdPrefix(string), (String)MLog.getPatternedMsg(string2, throwable));
        }
    }

    public static void v(String string, String string2) {
        if (sLogLevel >= 4) {
            MLog.log(MLog.addAdPrefix(string), string2, 4);
        }
    }

    public static void v(String string, String string2, Throwable throwable) {
        if (sLogLevel >= 4) {
            Log.v((String)MLog.addAdPrefix(string), (String)MLog.getPatternedMsg(string2, throwable));
        }
    }

    private static void log(String string, String string2, int n2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        int n3 = string2.length() / 3000;
        int n4 = 0;
        block7: while (n4 <= n3) {
            int n5 = n4 * 3000;
            int n6 = Math.min(string2.length(), ++n4 * 3000);
            if (n5 >= n6) continue;
            String string3 = string2.substring(n5, n6);
            switch (n2) {
                default: {
                    continue block7;
                }
                case 4: {
                    Log.v((String)string, (String)string3);
                    continue block7;
                }
                case 3: {
                    Log.d((String)string, (String)string3);
                    continue block7;
                }
                case 2: {
                    Log.i((String)string, (String)string3);
                    continue block7;
                }
                case 1: {
                    Log.w((String)string, (String)string3);
                    continue block7;
                }
                case 0: 
            }
            Log.e((String)string, (String)string3);
        }
    }

    private static String getSuffix(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            if (!string.contains(string2)) {
                return string;
            }
            String string3 = string;
            return string3.substring(string3.lastIndexOf(string2) + 1);
        }
        return null;
    }

    public static String addAdPrefix(String string) {
        StringBuilder stringBuilder;
        String string2 = sMainThreadId == Thread.currentThread().getId() ? MAIN_THREAD : (TextUtils.isEmpty((CharSequence)Thread.currentThread().getName()) ? String.valueOf(Thread.currentThread().getId()) : Thread.currentThread().getName());
        StringBuilder stringBuilder2 = stringBuilder;
        new StringBuilder().append(sPrefix).append("-").append(string).append("-");
        if (!TextUtils.isEmpty((CharSequence)sPackageNameSuffix)) {
            stringBuilder2.append(sPackageNameSuffix).append("-");
        }
        if (!TextUtils.isEmpty((CharSequence)sProcess)) {
            stringBuilder2.append("[").append(sProcess).append("]").append("-");
        }
        return stringBuilder2.append("[").append(string2).append("]").toString();
    }

    private static String getPatternedMsg(String string, Throwable throwable) {
        return string + "\n" + Patterns.IP_ADDRESS.matcher(Log.getStackTraceString((Throwable)throwable)).replaceAll("*.*.*.*");
    }
}

