/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.NamedThreadFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MintPoolExecuter {
    static final String TAG = "ThreadPool";
    private static final String POOL_NAME_PREFIX = "Mint";
    private static final long POOL_DEFAULT_KEEP_ALIVE_TIME_SECONDS = 60L;
    private static final boolean sThreadPoolDebugMode = false;
    private static final HashMap<ExecutorEnum, ThreadPoolExecutor> poolMap = new HashMap();

    public static void execute(ExecutorEnum executorEnum, Runnable runnable) {
        MintPoolExecuter.getExecutor(executorEnum).execute(runnable);
    }

    public static void submit(ExecutorEnum executorEnum, Runnable runnable) {
        MintPoolExecuter.getExecutor(executorEnum).submit(runnable);
    }

    public static void remove(ExecutorEnum executorEnum, Runnable runnable) {
        MintPoolExecuter.getExecutor(executorEnum).remove(runnable);
    }

    public static ScheduledFuture<?> scheduleInit(Runnable runnable, long l2, TimeUnit timeUnit) {
        return ((ScheduledThreadPoolExecutor)MintPoolExecuter.getExecutor(ExecutorEnum.Init)).schedule(runnable, l2, timeUnit);
    }

    public static ScheduledFuture<?> scheduleIns(Runnable runnable, long l2, TimeUnit timeUnit) {
        return ((ScheduledThreadPoolExecutor)MintPoolExecuter.getExecutor(ExecutorEnum.InsExecutor)).schedule(runnable, l2, timeUnit);
    }

    public static ScheduledFuture<?> scheduleWork(Runnable runnable, long l2, TimeUnit timeUnit) {
        return ((ScheduledThreadPoolExecutor)MintPoolExecuter.getExecutor(ExecutorEnum.WorkExecutor)).schedule(runnable, l2, timeUnit);
    }

    public static ScheduledFuture<?> scheduleHttp(Runnable runnable, long l2, TimeUnit timeUnit) {
        return ((ScheduledThreadPoolExecutor)MintPoolExecuter.getExecutor(ExecutorEnum.Http)).schedule(runnable, l2, timeUnit);
    }

    public static ScheduledFuture<?> scheduleEventWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return ((ScheduledThreadPoolExecutor)MintPoolExecuter.getExecutor(ExecutorEnum.EventExecutor)).scheduleWithFixedDelay(runnable, l2, l3, timeUnit);
    }

    @Deprecated
    public static ScheduledFuture<?> execute(ExecutorEnum executorEnum, Runnable runnable, long l2, TimeUnit timeUnit) {
        return ((ScheduledThreadPoolExecutor)MintPoolExecuter.getExecutor(executorEnum)).schedule(runnable, l2, timeUnit);
    }

    @Deprecated
    public static ScheduledFuture<?> scheduleWithFixedDelay(ExecutorEnum executorEnum, Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        return ((ScheduledThreadPoolExecutor)MintPoolExecuter.getExecutor(executorEnum)).scheduleWithFixedDelay(runnable, l2, l3, timeUnit);
    }

    private static synchronized ThreadPoolExecutor getExecutor(ExecutorEnum executorEnum) {
        ThreadPoolExecutor threadPoolExecutor;
        Object object;
        if (executorEnum == null) {
            executorEnum = ExecutorEnum.WorkExecutor;
            MLog.d(TAG, "unknown executor name, use default");
            new Exception().printStackTrace();
        }
        if ((object = poolMap.get((Object)executorEnum)) == null) {
            object = POOL_NAME_PREFIX + executorEnum.name();
            switch (2.$SwitchMap$com$zeus$gmc$sdk$mobileads$mintmediation$utils$ExecutorEnum[executorEnum.ordinal()]) {
                default: {
                    NamedThreadFactory namedThreadFactory;
                    ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                    threadPoolExecutor = scheduledThreadPoolExecutor;
                    Object object2 = namedThreadFactory;
                    namedThreadFactory = new NamedThreadFactory(POOL_NAME_PREFIX);
                    scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(30, (ThreadFactory)object2);
                    object2 = TimeUnit.SECONDS;
                    scheduledThreadPoolExecutor.setKeepAliveTime(60L, (TimeUnit)((Object)object2));
                    break;
                }
                case 7: {
                    ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                    int n2 = Runtime.getRuntime().availableProcessors();
                    threadPoolExecutor = scheduledThreadPoolExecutor;
                    ((ScheduledThreadPoolExecutor)threadPoolExecutor)(Math.max(2, Math.min(n2 - 1, 4)), new NamedThreadFactory((String)object));
                    scheduledThreadPoolExecutor.setMaximumPoolSize(n2 * 2 + 1);
                    TimeUnit timeUnit = TimeUnit.SECONDS;
                    scheduledThreadPoolExecutor.setKeepAliveTime(60L, timeUnit);
                    break;
                }
                case 6: {
                    NamedThreadFactory namedThreadFactory;
                    ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                    threadPoolExecutor = scheduledThreadPoolExecutor;
                    Object object3 = namedThreadFactory;
                    namedThreadFactory = new NamedThreadFactory((String)object);
                    new ScheduledThreadPoolExecutor(1, (ThreadFactory)object3).setMaximumPoolSize(1);
                    object3 = TimeUnit.SECONDS;
                    threadPoolExecutor.setKeepAliveTime(60L, (TimeUnit)((Object)object3));
                    break;
                }
                case 5: {
                    NamedThreadFactory namedThreadFactory;
                    LinkedBlockingQueue<Runnable> linkedBlockingQueue;
                    ThreadPoolExecutor threadPoolExecutor2;
                    threadPoolExecutor = threadPoolExecutor2;
                    TimeUnit timeUnit = TimeUnit.SECONDS;
                    LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
                    linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
                    NamedThreadFactory namedThreadFactory2 = namedThreadFactory;
                    namedThreadFactory = new NamedThreadFactory((String)object);
                    threadPoolExecutor2 = new ThreadPoolExecutor(1, 1, 60L, timeUnit, linkedBlockingQueue2, namedThreadFactory2);
                    break;
                }
                case 4: {
                    NamedThreadFactory namedThreadFactory;
                    SynchronousQueue<Runnable> synchronousQueue;
                    ThreadPoolExecutor threadPoolExecutor3;
                    threadPoolExecutor = threadPoolExecutor3;
                    TimeUnit timeUnit = TimeUnit.SECONDS;
                    SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
                    synchronousQueue = new SynchronousQueue<Runnable>();
                    NamedThreadFactory namedThreadFactory3 = namedThreadFactory;
                    namedThreadFactory = new NamedThreadFactory((String)object);
                    threadPoolExecutor3 = new ThreadPoolExecutor(5, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, namedThreadFactory3);
                    break;
                }
                case 3: {
                    NamedThreadFactory namedThreadFactory;
                    ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                    threadPoolExecutor = scheduledThreadPoolExecutor;
                    Object object4 = namedThreadFactory;
                    namedThreadFactory = new NamedThreadFactory((String)object);
                    scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(5, (ThreadFactory)object4);
                    object4 = TimeUnit.SECONDS;
                    scheduledThreadPoolExecutor.setKeepAliveTime(60L, (TimeUnit)((Object)object4));
                    break;
                }
                case 2: {
                    NamedThreadFactory namedThreadFactory;
                    ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                    threadPoolExecutor = scheduledThreadPoolExecutor;
                    Object object5 = namedThreadFactory;
                    namedThreadFactory = new NamedThreadFactory((String)object);
                    scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(30, (ThreadFactory)object5);
                    object5 = TimeUnit.SECONDS;
                    scheduledThreadPoolExecutor.setKeepAliveTime(60L, (TimeUnit)((Object)object5));
                    break;
                }
                case 1: {
                    NamedThreadFactory namedThreadFactory;
                    ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                    threadPoolExecutor = scheduledThreadPoolExecutor;
                    Object object6 = namedThreadFactory;
                    namedThreadFactory = new NamedThreadFactory((String)object);
                    scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(12, (ThreadFactory)object6);
                    object6 = TimeUnit.SECONDS;
                    scheduledThreadPoolExecutor.setKeepAliveTime(60L, (TimeUnit)((Object)object6));
                }
            }
            threadPoolExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler((String)object){
                final /* synthetic */ String val$poolName;
                {
                    this.val$poolName = string;
                }

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    MLog.d(MintPoolExecuter.TAG, "execute rejected, pool: " + this.val$poolName);
                }
            });
            poolMap.put(executorEnum, threadPoolExecutor);
        } else {
            threadPoolExecutor = object;
        }
        return threadPoolExecutor;
    }

    private static class PrintPoolStatusHandler
    extends Handler {
        private final int MSG_PRINT_TASK_FINISH;
        private final int MSG_PRINT_POOL_STATUS_DELAYED;
        private final Map<String, Integer> mMsgWhatMap = Collections.synchronizedMap(new HashMap());
        private final Map<String, ThreadPoolExecutor> mPools = Collections.synchronizedMap(new HashMap());

        PrintPoolStatusHandler() {
            super(Looper.getMainLooper());
            this.MSG_PRINT_TASK_FINISH = 1;
            this.MSG_PRINT_POOL_STATUS_DELAYED = 2;
        }

        private int createMsgWhatWithPoolName(String string) {
            Integer n2 = this.mMsgWhatMap.get(string);
            if (n2 == null) {
                PrintPoolStatusHandler printPoolStatusHandler = this;
                n2 = printPoolStatusHandler.mMsgWhatMap.size() + 1;
                printPoolStatusHandler.mMsgWhatMap.put(string, n2);
            }
            return n2;
        }

        private void printPoolStatus(String string, String string2, ThreadPoolExecutor threadPoolExecutor) {
            if (threadPoolExecutor == null) {
                return;
            }
            ThreadPoolExecutor threadPoolExecutor2 = threadPoolExecutor;
            int n2 = threadPoolExecutor2.getQueue().size();
            int n3 = threadPoolExecutor2.getActiveCount();
            int n4 = threadPoolExecutor2.getLargestPoolSize();
            int n5 = threadPoolExecutor2.getPoolSize();
            long l2 = threadPoolExecutor2.getTaskCount();
            long l3 = threadPoolExecutor2.getCompletedTaskCount();
            MLog.v(MintPoolExecuter.TAG, string + string2 + ", queue size: " + n2 + ", active size: " + n3 + ", pool size: " + n5 + ", largest pool size: " + n4 + ", task count: " + l2 + ", completed task count: " + l3);
        }

        public void handleMessage(@NonNull Message message) {
            super.handleMessage(message);
            String string = (String)message.obj;
            ThreadPoolExecutor threadPoolExecutor = this.mPools.get(string);
            if (threadPoolExecutor != null) {
                int n2 = message.what;
                if (n2 == 1) {
                    this.printPoolStatus("finish task: ", string, threadPoolExecutor);
                } else if (n2 == 2) {
                    this.printPoolStatus("pool status: ", string, threadPoolExecutor);
                }
            }
        }

        void onAddTask(String string, ThreadPoolExecutor threadPoolExecutor) {
            if (string != null && threadPoolExecutor != null) {
                PrintPoolStatusHandler printPoolStatusHandler = this;
                this.mPools.put(string, threadPoolExecutor);
                printPoolStatusHandler.removeMessages(printPoolStatusHandler.createMsgWhatWithPoolName(string));
                printPoolStatusHandler.printPoolStatus("add task: ", string, threadPoolExecutor);
                return;
            }
        }

        void onStartTask(String string, ThreadPoolExecutor threadPoolExecutor) {
            if (string != null && threadPoolExecutor != null) {
                PrintPoolStatusHandler printPoolStatusHandler = this;
                this.mPools.put(string, threadPoolExecutor);
                printPoolStatusHandler.removeMessages(printPoolStatusHandler.createMsgWhatWithPoolName(string));
                printPoolStatusHandler.printPoolStatus("pool status: ", string, threadPoolExecutor);
                return;
            }
        }

        void onTaskFinish(String string, ThreadPoolExecutor threadPoolExecutor, long l2) {
            if (string != null && threadPoolExecutor != null) {
                int n2;
                PrintPoolStatusHandler printPoolStatusHandler = printPoolStatusHandler4;
                PrintPoolStatusHandler printPoolStatusHandler2 = printPoolStatusHandler4;
                printPoolStatusHandler4.mPools.put(string, threadPoolExecutor);
                printPoolStatusHandler2.removeMessages(printPoolStatusHandler2.createMsgWhatWithPoolName(string));
                Message.obtain().what = n2 = printPoolStatusHandler.createMsgWhatWithPoolName(string);
                Message.obtain().obj = string;
                Message.obtain().arg1 = 1;
                printPoolStatusHandler.sendMessage(Message.obtain());
                if (l2 > 0L) {
                    PrintPoolStatusHandler printPoolStatusHandler3 = printPoolStatusHandler4;
                    PrintPoolStatusHandler printPoolStatusHandler4 = Message.obtain();
                    Message.obtain().what = n2;
                    Message.obtain().obj = string;
                    Message.obtain().arg1 = 2;
                    printPoolStatusHandler3.sendMessageDelayed((Message)printPoolStatusHandler4, l2);
                }
                return;
            }
        }
    }

    static class TaskTraceDelegate
    implements Runnable {
        static Map<Runnable, Runnable> sTaskMap = new ConcurrentHashMap<Runnable, Runnable>();
        static final long PRINT_POOL_STATUS_DELAY = 61000L;
        private final Runnable mTask;
        private final String mPoolName;
        private final ThreadPoolExecutor mPool;
        private final PrintPoolStatusHandler mPrintPoolStatusHandler;
        private long mShouldScheduleTime = -1L;
        private long mTaskAddTime = -1L;
        private long mTaskStartTime;
        private long mTaskFinishTime;

        TaskTraceDelegate(String string, ThreadPoolExecutor threadPoolExecutor, PrintPoolStatusHandler printPoolStatusHandler, Runnable runnable) {
            this.mPoolName = string;
            this.mPool = threadPoolExecutor;
            this.mPrintPoolStatusHandler = printPoolStatusHandler;
            this.mTask = runnable;
        }

        void onAddTask() {
            Runnable runnable = this.mTask;
            if (runnable != null) {
                sTaskMap.put(runnable, this);
            }
            this.mTaskAddTime = SystemClock.elapsedRealtime();
        }

        void onScheduleTask(long l2, TimeUnit timeUnit) {
            this.mShouldScheduleTime = SystemClock.elapsedRealtime() + timeUnit.toMillis(l2);
            Runnable runnable = this.mTask;
            if (runnable != null) {
                sTaskMap.put(runnable, this);
            }
        }

        @Override
        public void run() {
            block5: {
                Object object = this.mTask;
                if (object != null) {
                    sTaskMap.remove(object);
                }
                this.mTaskStartTime = SystemClock.elapsedRealtime();
                object = this.mPrintPoolStatusHandler;
                if (object != null) {
                    Runnable runnable = object;
                    TaskTraceDelegate taskTraceDelegate = this;
                    object = taskTraceDelegate.mPoolName;
                    ((PrintPoolStatusHandler)((Object)runnable)).onStartTask((String)object, taskTraceDelegate.mPool);
                }
                try {
                    if (this.mTask == null) break block5;
                }
                catch (Throwable throwable) {
                    this.mTaskFinishTime = SystemClock.elapsedRealtime();
                    this.printInfo();
                    throw throwable;
                }
                this.mTask.run();
            }
            this.mTaskFinishTime = SystemClock.elapsedRealtime();
            this.printInfo();
        }

        void printInfo() {
            TaskTraceDelegate taskTraceDelegate = string;
            long l2 = ((TaskTraceDelegate)((Object)string)).mTaskStartTime;
            long l3 = taskTraceDelegate.mTaskFinishTime - l2;
            long l4 = taskTraceDelegate.mShouldScheduleTime;
            if (l4 != -1L) {
                MLog.v(MintPoolExecuter.TAG, "task schedule offset:" + (l2 -= l4) + ", running time:" + l3);
            } else {
                l4 = ((TaskTraceDelegate)((Object)string)).mTaskAddTime;
                if (l4 != -1L) {
                    MLog.v(MintPoolExecuter.TAG, "task wait:" + (l2 -= l4) + ", running time:" + l3);
                }
            }
            PrintPoolStatusHandler printPoolStatusHandler = ((TaskTraceDelegate)((Object)string)).mPrintPoolStatusHandler;
            if (printPoolStatusHandler != null) {
                TaskTraceDelegate taskTraceDelegate2 = string;
                String string = taskTraceDelegate2.mPoolName;
                printPoolStatusHandler.onTaskFinish(string, taskTraceDelegate2.mPool, 61000L);
            }
        }
    }

    static class TraceThreadPoolExecutorWrapper
    extends ScheduledThreadPoolExecutor {
        private static PrintPoolStatusHandler sPrintPoolStatusHandler;
        private final String mPoolName;
        private final ThreadPoolExecutor mExecutor;

        public TraceThreadPoolExecutorWrapper(String string, ThreadPoolExecutor threadPoolExecutor) {
            TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper = this;
            super(0);
            traceThreadPoolExecutorWrapper.mPoolName = string;
            traceThreadPoolExecutorWrapper.mExecutor = threadPoolExecutor;
        }

        void onAddTask() {
            PrintPoolStatusHandler printPoolStatusHandler = sPrintPoolStatusHandler;
            if (printPoolStatusHandler != null) {
                TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper = string;
                String string = traceThreadPoolExecutorWrapper.mPoolName;
                printPoolStatusHandler.onAddTask(string, traceThreadPoolExecutorWrapper.mExecutor);
            }
        }

        @Override
        public void execute(Runnable runnable) {
            TaskTraceDelegate taskTraceDelegate;
            if (runnable == null) {
                return;
            }
            TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper = string;
            TaskTraceDelegate taskTraceDelegate2 = taskTraceDelegate;
            TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper2 = string;
            String string = traceThreadPoolExecutorWrapper2.mPoolName;
            ThreadPoolExecutor threadPoolExecutor = traceThreadPoolExecutorWrapper2.mExecutor;
            new TaskTraceDelegate(string, threadPoolExecutor, sPrintPoolStatusHandler, runnable).onAddTask();
            traceThreadPoolExecutorWrapper.mExecutor.execute(taskTraceDelegate2);
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            TaskTraceDelegate taskTraceDelegate;
            if (runnable == null) {
                return null;
            }
            TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper = string;
            TaskTraceDelegate taskTraceDelegate2 = taskTraceDelegate;
            TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper2 = string;
            String string = traceThreadPoolExecutorWrapper2.mPoolName;
            ThreadPoolExecutor threadPoolExecutor = traceThreadPoolExecutorWrapper2.mExecutor;
            new TaskTraceDelegate(string, threadPoolExecutor, sPrintPoolStatusHandler, runnable).onAddTask();
            return traceThreadPoolExecutorWrapper.mExecutor.submit(taskTraceDelegate2);
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
            TaskTraceDelegate taskTraceDelegate;
            if (runnable == null) {
                return null;
            }
            TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper = string;
            TaskTraceDelegate taskTraceDelegate2 = taskTraceDelegate;
            TraceThreadPoolExecutorWrapper traceThreadPoolExecutorWrapper2 = string;
            String string = traceThreadPoolExecutorWrapper2.mPoolName;
            ThreadPoolExecutor threadPoolExecutor = traceThreadPoolExecutorWrapper2.mExecutor;
            taskTraceDelegate2(string, threadPoolExecutor, sPrintPoolStatusHandler, runnable);
            taskTraceDelegate.onScheduleTask(l2, timeUnit);
            return ((ScheduledThreadPoolExecutor)traceThreadPoolExecutorWrapper.mExecutor).schedule(taskTraceDelegate2, l2, timeUnit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
            return ((ScheduledThreadPoolExecutor)this.mExecutor).scheduleWithFixedDelay(runnable, l2, l3, timeUnit);
        }

        @Override
        public boolean remove(Runnable runnable) {
            if (this.mExecutor.remove(runnable)) {
                return true;
            }
            return TaskTraceDelegate.sTaskMap.remove(runnable) != null;
        }

        @Override
        public BlockingQueue<Runnable> getQueue() {
            return this.mExecutor.getQueue();
        }

        @Override
        public int getLargestPoolSize() {
            return this.mExecutor.getLargestPoolSize();
        }

        @Override
        public int getPoolSize() {
            return this.mExecutor.getPoolSize();
        }
    }
}

