/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import android.net.Uri;
import android.text.TextUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.bid.MintBidResponse;
import com.zeus.gmc.sdk.mobileads.mintmediation.nativead.NativeAdOptions;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.JsonUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.DataCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.BaseInstance;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Configurations;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.ImpRecord;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Mediation;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Placement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PlacementUtils {
    private static final String TAG = "PlacementUtils";

    private PlacementUtils() {
        throw new IllegalStateException("PlacementUtils class");
    }

    public static Map<String, String> getNativePlacementInfo(String string, BaseInstance baseInstance, String string2, NativeAdOptions nativeAdOptions) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>(PlacementUtils.getPlacementInfo(string, baseInstance, string2));
        if (nativeAdOptions != null) {
            hashMap2.put("adChoicesPlacement", String.valueOf(nativeAdOptions.getAdChoicesPlacement()));
        }
        return hashMap2;
    }

    public static Map<String, String> getPlacementInfo(String string, BaseInstance baseInstance, String string2) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2;
        Configurations configurations = DataCache.getInstance().getFromMem("Config", Configurations.class);
        HashMap<String, String> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put("AppKey", ((Mediation)configurations.getMs().get(baseInstance.getMediationId())).getK());
        hashMap3.put("PlacementId", string);
        hashMap2.put("InstanceKey", baseInstance.getKey());
        hashMap2.put("InstanceId", String.valueOf(baseInstance.getId()));
        hashMap.put("Expired", String.valueOf(baseInstance.isAdExpiredByMint()));
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            hashMap2.put("pay_load", string2);
        }
        return hashMap2;
    }

    public static Map<String, Object> getPlacementInfoMap(String string, BaseInstance baseInstance, String string2) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        Configurations configurations = DataCache.getInstance().getFromMem("Config", Configurations.class);
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2();
        hashMap3.put("AppKey", ((Mediation)configurations.getMs().get(baseInstance.getMediationId())).getK());
        hashMap3.put("PlacementId", string);
        hashMap2.put("InstanceKey", baseInstance.getKey());
        hashMap2.put("InstanceId", String.valueOf(baseInstance.getId()));
        hashMap2.put("Expired", String.valueOf(baseInstance.isAdExpiredByMint()));
        hashMap.put("pt", String.valueOf(baseInstance.getPt()));
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            hashMap2.put("pay_load", string2);
        }
        return hashMap2;
    }

    public static Map<String, Object> getLoadExtrasMap(BaseInstance baseInstance, MintBidResponse mintBidResponse) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap = new HashMap<String, Object>();
        if (mintBidResponse != null && !TextUtils.isEmpty((CharSequence)mintBidResponse.getPayLoad())) {
            hashMap2.put("pay_load", mintBidResponse.getPayLoad());
        }
        if (baseInstance != null) {
            hashMap2.put("InstanceId", String.valueOf(baseInstance.getId()));
            hashMap2.put("pt", String.valueOf(baseInstance.getPt()));
        }
        return hashMap2;
    }

    public static Placement getPlacement(int n2) {
        ArrayList<Placement> arrayList;
        Configurations object2 = DataCache.getInstance().getFromMem("Config", Configurations.class);
        if (object2 == null) {
            return null;
        }
        Map<String, Placement> map = object2.getPls();
        if (map == null) {
            return null;
        }
        ArrayList<Placement> arrayList2 = arrayList;
        arrayList = new ArrayList<Placement>();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Placement placement = map.get(iterator.next());
            if (placement == null || placement.getT() != n2) continue;
            arrayList2.add(placement);
        }
        for (Placement placement : arrayList2) {
            if (placement.getMain() != 1) continue;
            return placement;
        }
        return arrayList2.isEmpty() ? null : (Placement)arrayList2.get(0);
    }

    public static Placement getPlacement(String string) {
        Object object = DataCache.getInstance().getFromMem("Config", Configurations.class);
        if (object == null) {
            return null;
        }
        if ((object = ((Configurations)object).getPls()) == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        return (Placement)object.get(string);
    }

    public static String getAdTypeName(int n2) {
        switch (n2) {
            default: {
                return "unknown";
            }
            case 6: {
                return "RewardedInterstitial";
            }
            case 4: {
                return "Splash";
            }
            case 3: {
                return "Interstitial";
            }
            case 2: {
                return "RewardedVideo";
            }
            case 1: {
                return "Native";
            }
            case 0: 
        }
        return "Banner";
    }

    public static JSONObject placementEventParams(String string) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject();
        Placement placement = PlacementUtils.getPlacement(string);
        if (placement != null) {
            JsonUtil.put(jSONObject2, "abt", placement.getWfAbt());
        }
        JSONObject jSONObject3 = jSONObject2;
        JsonUtil.put(jSONObject3, "pid", string);
        return jSONObject3;
    }

    protected static ImpRecord parseFromJson(String object) {
        HashMap hashMap;
        JSONObject jSONObject;
        ImpRecord impRecord;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        MLog.d(TAG, "imp string : " + (String)object);
        ImpRecord impRecord2 = impRecord;
        impRecord = new ImpRecord();
        MLog.d(TAG, "PlacementUtils imp string : " + Uri.decode((String)object));
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject(Uri.decode((String)object));
        object = hashMap;
        hashMap = new HashMap();
        Iterator iterator = jSONObject.keys();
        while (true) {
            if (!iterator.hasNext()) break;
            JSONObject jSONObject3 = jSONObject2;
            String string = (String)iterator.next();
            Map<String, ImpRecord.Imp> map = PlacementUtils.jsonToImps(jSONObject3.optJSONArray(string));
            if (map == null) continue;
            if (map.isEmpty()) continue;
            object.put(string, map);
        }
        try {
            ImpRecord impRecord3 = impRecord2;
            impRecord3.setImpMap((Map<String, Map<String, ImpRecord.Imp>>)object);
            return impRecord3;
        }
        catch (JSONException jSONException) {
            MLog.d(TAG, TAG, jSONException);
            CrashUtil.getSingleton().saveException(jSONException);
            return null;
        }
    }

    private static Map<String, ImpRecord.Imp> jsonToImps(JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            HashMap<String, ImpRecord.Imp> hashMap;
            HashMap<String, ImpRecord.Imp> hashMap2 = hashMap;
            hashMap = new HashMap<String, ImpRecord.Imp>();
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                ImpRecord.Imp imp;
                Object object = jSONArray.optJSONObject(i2);
                ImpRecord.Imp imp2 = imp;
                JSONObject jSONObject = object;
                imp2();
                imp2.setLashImpTime(object.optLong("last_imp_time"));
                imp2.setImpCount(object.optInt("imp_count"));
                imp2.setTime(object.optString("time"));
                object = object.optString("pkg_name");
                imp2.setPkgName((String)object);
                imp.setPlacmentId(jSONObject.optString("placement_id"));
                hashMap2.put((String)object, imp2);
            }
            return hashMap2;
        }
        return null;
    }

    private static List<ImpRecord.DayImp> jsonToDayImps(JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() != 0) {
            ArrayList<ImpRecord.DayImp> arrayList;
            ArrayList<ImpRecord.DayImp> arrayList2 = arrayList;
            arrayList = new ArrayList<ImpRecord.DayImp>();
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                ImpRecord.DayImp dayImp;
                JSONObject jSONObject = jSONArray.optJSONObject(i2);
                ImpRecord.DayImp dayImp2 = dayImp;
                dayImp2();
                dayImp2.setImpCount(jSONObject.optInt("imp_count"));
                dayImp.setTime(jSONObject.optString("time"));
                arrayList2.add(dayImp);
            }
            return arrayList2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void savePlacementImprCount(String var0) {
        block22: {
            block23: {
                var1_2 = new SimpleDateFormat("yyyyMMdd", Locale.US).format(new Date());
                v0 = DataCache.getInstance();
                var2_3 = PlacementUtils.parseDayImpFromJson(v0.get("DayImpRecord", String.class));
                if (var2_3 != null) ** GOTO lbl11
                var2_3 = v1;
                v1 = new ImpRecord();
lbl11:
                // 2 sources

                if ((var3_4 = var2_3.getDayImp()) != null) ** GOTO lbl15
                var3_4 = v2;
                v2 = new HashMap<String, List<ImpRecord.DayImp>>();
lbl15:
                // 2 sources

                v3 = var3_4;
                var0 = var0.trim().concat("day_impr");
                var4_5 = (List)v3.get(var0);
                if (var4_5 == null) break block22;
                if (var4_5.isEmpty()) break block22;
                var5_6 = (ImpRecord.DayImp)var4_5.get(0);
                if (var5_6 != null) ** GOTO lbl31
                var5_6 = v4;
                var5_6();
                v4.setTime(var1_2);
                v4.setImpCount(1);
                ** GOTO lbl44
lbl31:
                // 1 sources

                if (!var1_2.equals(var5_6.getTime())) ** GOTO lbl39
                v5 = var5_6;
                v6 = v5;
                v7 = v5.getImpCount();
                v6.setImpCount(v7 + 1);
                break block23;
lbl39:
                // 1 sources

                v8 = var5_6;
                v8.setTime(var1_2);
                v8.setImpCount(1);
            }
            var4_5.clear();
lbl44:
            // 2 sources

            v9 = var4_5.add(var5_6);
lbl45:
            // 2 sources

            while (true) {
                ** GOTO lbl57
                break;
            }
        }
        var4_5 = v10;
        v10 = new ArrayList<ImpRecord.Imp>();
        v11 = new ImpRecord.Imp();
        v11.setTime(var1_2);
        v11.setImpCount(1);
        v9 = v10.add(v11);
        ** continue;
lbl57:
        // 1 sources

        v12 = var2_3;
        v13 = var3_4;
        v14 = v13;
        v13.put(var0, var4_5);
        v12.setDayImp(v14);
        v15 = DataCache.getInstance();
        try {
            v15.set("DayImpRecord", Uri.encode((String)PlacementUtils.transDayImpToString(var2_3)));
        }
        catch (Throwable var0_1) {
            MLog.d("PlacementUtils", "PlacementUtils", var0_1);
            CrashUtil.getSingleton().saveException(var0_1);
        }
    }

    public static int getPlacementImprCount(String object) {
        block13: {
            Object object2;
            String string;
            block12: {
                block11: {
                    try {
                        string = new SimpleDateFormat("yyyyMMdd", Locale.US).format(new Date());
                    }
                    catch (Throwable throwable) {
                        MLog.d(TAG, TAG, throwable);
                        CrashUtil.getSingleton().saveException(throwable);
                        return 0;
                    }
                    DataCache dataCache = DataCache.getInstance();
                    object2 = PlacementUtils.parseDayImpFromJson(dataCache.get("DayImpRecord", String.class));
                    if (object2 != null) break block11;
                    return 0;
                }
                object2 = ((ImpRecord)object2).getDayImp();
                if (object2 != null) break block12;
                return 0;
            }
            object = (List)object2.get(((String)object).trim().concat("day_impr"));
            if (object == null) break block13;
            if (object.isEmpty()) break block13;
            object = (ImpRecord.DayImp)object.get(0);
            if (object == null) break block13;
            if (!((ImpRecord.DayImp)object).getTime().equals(string)) break block13;
            return ((ImpRecord.DayImp)object).getImpCount();
        }
        return 0;
    }

    private static ImpRecord parseDayImpFromJson(String object) {
        HashMap hashMap;
        JSONObject jSONObject;
        ImpRecord impRecord;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        ImpRecord impRecord2 = impRecord;
        impRecord = new ImpRecord();
        JSONObject jSONObject2 = jSONObject;
        jSONObject = new JSONObject(Uri.decode((String)object));
        object = hashMap;
        hashMap = new HashMap();
        Iterator iterator = jSONObject.keys();
        while (true) {
            if (!iterator.hasNext()) break;
            JSONObject jSONObject3 = jSONObject2;
            String string = (String)iterator.next();
            List<ImpRecord.DayImp> list = PlacementUtils.jsonToDayImps(jSONObject3.optJSONArray(string));
            if (list == null) continue;
            if (list.isEmpty()) continue;
            object.put(string, list);
        }
        try {
            ImpRecord impRecord3 = impRecord2;
            impRecord3.setDayImp((Map<String, List<ImpRecord.DayImp>>)object);
            return impRecord3;
        }
        catch (JSONException jSONException) {
            MLog.d(TAG, TAG, jSONException);
            CrashUtil.getSingleton().saveException(jSONException);
            return null;
        }
    }

    private static String transDayImpToString(ImpRecord impRecord) {
        JSONObject jSONObject;
        ImpRecord impRecord2 = impRecord;
        impRecord = jSONObject;
        jSONObject = new JSONObject();
        Map<String, List<ImpRecord.DayImp>> map = impRecord2.getDayImp();
        Iterator<String> iterator = map.keySet().iterator();
        while (true) {
            JSONArray jSONArray;
            if (!iterator.hasNext()) break;
            Map<String, List<ImpRecord.DayImp>> map2 = map;
            String string = iterator.next();
            JSONArray jSONArray2 = map2.get(string);
            if (jSONArray2 == null) continue;
            if (jSONArray2.isEmpty()) continue;
            JSONArray jSONArray3 = jSONArray2;
            jSONArray2 = jSONArray;
            jSONArray = new JSONArray();
            Iterator iterator2 = jSONArray3.iterator();
            while (true) {
                JSONObject jSONObject2;
                if (!iterator2.hasNext()) break;
                Object object = (ImpRecord.DayImp)iterator2.next();
                if (object == null) continue;
                JSONArray jSONArray4 = jSONArray2;
                JSONObject jSONObject3 = jSONObject2;
                ImpRecord.DayImp dayImp = object;
                JSONObject jSONObject4 = jSONObject3;
                ImpRecord.DayImp dayImp2 = object;
                jSONObject3();
                object = "imp_count";
                jSONObject4.put((String)object, dayImp2.getImpCount());
                object = "time";
                jSONObject2.put((String)object, (Object)dayImp.getTime());
                jSONArray4.put((Object)jSONObject2);
            }
            impRecord.put(string, jSONArray2);
        }
        try {
            return impRecord.toString();
        }
        catch (Exception exception) {
            MLog.d(TAG, TAG, exception);
            CrashUtil.getSingleton().saveException(exception);
            return null;
        }
    }
}

