/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils;

import android.app.Application;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.TextUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.PermissionUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.error.Error;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.error.ErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.util.NetworkChecker;
import java.util.Arrays;
import java.util.regex.Pattern;

public class SdkUtil {
    private static final String TAG = "SdkUtil";
    private static final String[] MINT_PERMISSIONS = new String[]{"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE"};
    private static final Pattern ACCEPTED_URI_SCHEME = Pattern.compile("(?i)((?:http|https|ftp|file)://|(?:inline|data|about|javascript):|(?:.*:.*@))(.*)");
    private static final String sMetaDataAutoIntoMode = "com.zeus.gmc.sdk.mobileads.mintmediation.AUTOMATIC_SDK_INITIALIZATION";

    public static Error banRun(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Error error = ErrorBuilder.build(113);
            MLog.e(TAG, "init error appKey is empty");
            return error;
        }
        if (!PermissionUtil.isGranted(context, MINT_PERMISSIONS)) {
            Error error = ErrorBuilder.build(114);
            MLog.e(TAG, "init error permission is not granted");
            return error;
        }
        if (!NetworkChecker.isAvailable(context)) {
            Error error = ErrorBuilder.build(121);
            MLog.e(TAG, "init error network is not available");
            return error;
        }
        return null;
    }

    public static boolean isAcceptedScheme(String string) {
        return ACCEPTED_URI_SCHEME.matcher(string.toLowerCase()).matches();
    }

    public static boolean copy(String string) {
        try {
            ((ClipboardManager)ContextProvider.INSTANCE.getContext().getSystemService("clipboard")).setPrimaryClip(ClipData.newPlainText((CharSequence)"Label", (CharSequence)string));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isAutoInitMode(Context context) {
        block5: {
            if (!(context instanceof Application)) {
                return false;
            }
            try {
                context = (Application)context;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            context = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (context != null) break block5;
            return true;
        }
        return context.getBoolean(sMetaDataAutoIntoMode, true);
    }

    public static void printApiLog(String string, Object ... objectArray) {
        MLog.d("API_CALL", string + "," + Arrays.toString(objectArray));
    }
}

