/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import androidx.annotation.StringRes;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SharedPreferencesUtils {
    private static final String TAG = "SharedPreferencesUtils";
    private static SharedPreferencesUtils sSharedPreferencesUtils;
    private static SharedPreferences sSharedPreferences;
    private static SharedPreferences.Editor sEditor;
    private static final String DEFAULT_SP_NAME = "MintSharedPreferences";
    private static final int DEFAULT_INT = 0;
    private static final float DEFAULT_FLOAT = 0.0f;
    private static final String DEFAULT_STRING = "";
    private static final boolean DEFAULT_BOOLEAN = false;
    private static final Set<String> DEFAULT_STRING_SET;
    private Context mContext;

    private SharedPreferencesUtils(Context context) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        sharedPreferencesUtils.initWithContext(context);
    }

    public static SharedPreferencesUtils getInstance() {
        Application application;
        if (sSharedPreferencesUtils == null) {
            sSharedPreferencesUtils = new SharedPreferencesUtils((Context)ContextProvider.INSTANCE.getApplication());
        }
        if (SharedPreferencesUtils.sSharedPreferencesUtils.mContext == null && (application = ContextProvider.INSTANCE.getApplication()) != null) {
            sSharedPreferencesUtils.initWithContext((Context)application);
        }
        return sSharedPreferencesUtils;
    }

    private void initWithContext(Context context) {
        if (context == null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        sSharedPreferences = this.mContext.getSharedPreferences(DEFAULT_SP_NAME, 0);
        sEditor = sSharedPreferences.edit();
    }

    private void checkIsInit() {
        if (sSharedPreferences == null) {
            new NullPointerException("SharedPreferencesUtils is not init").printStackTrace();
        }
    }

    static {
        DEFAULT_STRING_SET = new HashSet<String>(0);
    }

    public SharedPreferencesUtils put(@StringRes int n2, Object object) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.put(sharedPreferencesUtils.mContext.getString(n2), object);
    }

    public SharedPreferencesUtils put(String string, Object object) {
        this.checkIsInit();
        if (object instanceof String) {
            sEditor.putString(string, (String)object);
        } else if (object instanceof Integer) {
            sEditor.putInt(string, ((Integer)object).intValue());
        } else if (object instanceof Boolean) {
            sEditor.putBoolean(string, ((Boolean)object).booleanValue());
        } else if (object instanceof Float) {
            sEditor.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            sEditor.putLong(string, ((Long)object).longValue());
        } else {
            sEditor.putString(string, object.toString());
        }
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public Object get(@StringRes int n2, Object object) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.get(sharedPreferencesUtils.mContext.getString(n2), object);
    }

    public Object get(String string, Object object) {
        this.checkIsInit();
        if (object instanceof String) {
            return sSharedPreferences.getString(string, (String)object);
        }
        if (object instanceof Integer) {
            return sSharedPreferences.getInt(string, ((Integer)object).intValue());
        }
        if (object instanceof Boolean) {
            return sSharedPreferences.getBoolean(string, ((Boolean)object).booleanValue());
        }
        if (object instanceof Float) {
            return Float.valueOf(sSharedPreferences.getFloat(string, ((Float)object).floatValue()));
        }
        if (object instanceof Long) {
            return sSharedPreferences.getLong(string, ((Long)object).longValue());
        }
        return null;
    }

    public SharedPreferencesUtils putInt(String string, int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        sharedPreferencesUtils.checkIsInit();
        sEditor.putInt(string, n2);
        sEditor.apply();
        return sharedPreferencesUtils;
    }

    public SharedPreferencesUtils putInt(@StringRes int n2, int n3) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.putInt(sharedPreferencesUtils.mContext.getString(n2), n3);
    }

    public int getInt(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getInt(sharedPreferencesUtils.mContext.getString(n2));
    }

    public int getInt(@StringRes int n2, int n3) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getInt(sharedPreferencesUtils.mContext.getString(n2), n3);
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public int getInt(String string, int n2) {
        this.checkIsInit();
        return sSharedPreferences.getInt(string, n2);
    }

    public SharedPreferencesUtils putFloat(@StringRes int n2, float f2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.putFloat(sharedPreferencesUtils.mContext.getString(n2), f2);
    }

    public SharedPreferencesUtils putFloat(String string, float f2) {
        this.checkIsInit();
        sEditor.putFloat(string, f2);
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f2) {
        this.checkIsInit();
        return sSharedPreferences.getFloat(string, f2);
    }

    public float getFloat(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getFloat(sharedPreferencesUtils.mContext.getString(n2));
    }

    public float getFloat(@StringRes int n2, float f2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getFloat(sharedPreferencesUtils.mContext.getString(n2), f2);
    }

    public SharedPreferencesUtils putLong(@StringRes int n2, long l2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.putLong(sharedPreferencesUtils.mContext.getString(n2), l2);
    }

    public SharedPreferencesUtils putLong(String string, long l2) {
        this.checkIsInit();
        sEditor.putLong(string, l2);
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    public long getLong(String string, long l2) {
        this.checkIsInit();
        return sSharedPreferences.getLong(string, l2);
    }

    public long getLong(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getLong(sharedPreferencesUtils.mContext.getString(n2));
    }

    public long getLong(@StringRes int n2, long l2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getLong(sharedPreferencesUtils.mContext.getString(n2), l2);
    }

    public SharedPreferencesUtils putString(@StringRes int n2, String string) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.putString(sharedPreferencesUtils.mContext.getString(n2), string);
    }

    public SharedPreferencesUtils putString(String string, String string2) {
        this.checkIsInit();
        sEditor.putString(string, string2);
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public String getString(String string) {
        return this.getString(string, DEFAULT_STRING);
    }

    public String getString(String string, String string2) {
        this.checkIsInit();
        return sSharedPreferences.getString(string, string2);
    }

    public String getString(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getString(sharedPreferencesUtils.mContext.getString(n2), DEFAULT_STRING);
    }

    public String getString(@StringRes int n2, String string) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getString(sharedPreferencesUtils.mContext.getString(n2), string);
    }

    public SharedPreferencesUtils putBoolean(@StringRes int n2, boolean bl) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.putBoolean(sharedPreferencesUtils.mContext.getString(n2), bl);
    }

    public SharedPreferencesUtils putBoolean(String string, boolean bl) {
        this.checkIsInit();
        sEditor.putBoolean(string, bl);
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        this.checkIsInit();
        return sSharedPreferences.getBoolean(string, bl);
    }

    public boolean getBoolean(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getBoolean(sharedPreferencesUtils.mContext.getString(n2));
    }

    public boolean getBoolean(@StringRes int n2, boolean bl) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getBoolean(sharedPreferencesUtils.mContext.getString(n2), bl);
    }

    public SharedPreferencesUtils putStringSet(@StringRes int n2, Set<String> set) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.putStringSet(sharedPreferencesUtils.mContext.getString(n2), set);
    }

    public SharedPreferencesUtils putStringSet(String string, Set<String> set) {
        this.checkIsInit();
        sEditor.putStringSet(string, set);
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public Set<String> getStringSet(String string) {
        return this.getStringSet(string, DEFAULT_STRING_SET);
    }

    public Set<String> getStringSet(String string, Set<String> set) {
        this.checkIsInit();
        return sSharedPreferences.getStringSet(string, set);
    }

    public Set<String> getStringSet(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getStringSet(sharedPreferencesUtils.mContext.getString(n2));
    }

    public Set<String> getStringSet(@StringRes int n2, Set<String> set) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.getStringSet(sharedPreferencesUtils.mContext.getString(n2), set);
    }

    public boolean contains(String string) {
        this.checkIsInit();
        return sSharedPreferences.contains(string);
    }

    public boolean contains(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.contains(sharedPreferencesUtils.mContext.getString(n2));
    }

    public Map<String, ?> getAll() {
        this.checkIsInit();
        return sSharedPreferences.getAll();
    }

    public SharedPreferencesUtils remove(@StringRes int n2) {
        SharedPreferencesUtils sharedPreferencesUtils = this;
        return sharedPreferencesUtils.remove(sharedPreferencesUtils.mContext.getString(n2));
    }

    public SharedPreferencesUtils remove(String string) {
        this.checkIsInit();
        sEditor.remove(string);
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public SharedPreferencesUtils clear() {
        this.checkIsInit();
        sEditor.clear();
        sEditor.apply();
        return sSharedPreferencesUtils;
    }

    public void putObject(String string, Object object) throws Exception {
        block5: {
            String string2;
            ByteArrayOutputStream byteArrayOutputStream;
            ((SharedPreferencesUtils)((Object)byteArrayOutputStream2)).checkIsInit();
            MLog.e(TAG, "putObject: ");
            if (!(object instanceof Serializable)) break block5;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            new ObjectOutputStream(byteArrayOutputStream2).writeObject(object);
            object = string2;
            string2 = new String(Base64.encode((byte[])byteArrayOutputStream2.toByteArray(), (int)0));
            sEditor.putString(string, (String)object);
            try {
                sEditor.commit();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                MLog.e(TAG, "putObject Exception: ", iOException);
            }
            return;
        }
        throw new Exception("User must implements Serializable");
    }

    public <T> T getObject(String object) {
        ByteArrayInputStream byteArrayInputStream;
        ((SharedPreferencesUtils)object2).checkIsInit();
        Object object2 = sSharedPreferences.getString((String)object, DEFAULT_STRING);
        object = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(Base64.decode((byte[])((String)object2).getBytes(), (int)0));
        object2 = null;
        try {
            object2 = new ObjectInputStream((InputStream)object).readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return (T)object2;
    }
}

