/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.helper.PubSubHelper;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.RequestBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CrashUtil
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = CrashUtil.class.getSimpleName();
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private boolean isNe = true;

    private CrashUtil() {
    }

    public static CrashUtil getSingleton() {
        return CrashUtilHolder.INSTANCE;
    }

    private static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter;
        Object object;
        if (throwable == null) {
            return "";
        }
        Throwable throwable2 = new Throwable("1.9.2.1", throwable);
        for (object = v735; object != null; object = ((Throwable)object).getCause()) {
            if (!(object instanceof UnknownHostException)) continue;
            return "";
        }
        object = stringWriter;
        stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)object);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private static String getErrorType(String object) {
        String string;
        block7: {
            block6: {
                string = "";
                object = Pattern.compile(".*?(Exception|Error|Death)", 2).matcher((CharSequence)object);
                if (!((Matcher)object).find()) break block6;
                string = ((Matcher)object).group(0);
            }
            if (TextUtils.isEmpty((CharSequence)string)) break block7;
            try {
                string = string.replaceAll("Caused by:", "").replaceAll(" ", "");
            }
            catch (Exception exception) {
                MLog.d(TAG, "CrashUtil", exception);
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(Context context) {
        try {
            if (!(Thread.getDefaultUncaughtExceptionHandler() instanceof CrashUtil)) {
                this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
            }
            Thread.setDefaultUncaughtExceptionHandler(this);
            return;
        }
        catch (Exception exception) {
            MLog.e(TAG, "CrashUtil", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
        try {
            if (throwable instanceof UndeclaredThrowableException) {
                return;
            }
            CrashUtil crashUtil = this;
            crashUtil.saveException(throwable);
            if (crashUtil.mDefaultHandler == null) return;
            if (this.mDefaultHandler == this) return;
        }
        catch (Throwable throwable2) {
            throw throwable2;
        }
        catch (Exception exception) {
            MLog.d(TAG, "CrashUtil", exception);
            return;
        }
        if (this.mDefaultHandler instanceof CrashUtil) return;
        this.mDefaultHandler.uncaughtException(thread, throwable);
    }

    public void setNe(int n2) {
        n2 = n2 != 1 ? 1 : 0;
        this.isNe = n2;
    }

    public void saveException(final Throwable throwable) {
        Runnable runnable;
        if (!this.isNe) {
            return;
        }
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            /*
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Object object = "1.9.2.1".concat(":").concat(CrashUtil.getStackTraceString(object.throwable));
                if (!TextUtils.isEmpty((CharSequence)object) && ((String)object).contains("com.zeus.gmc.sdk.mobileads.mintmediation")) {
                    Throwable throwable2;
                    block7: {
                        block6: {
                            String string = CrashUtil.getErrorType((String)object);
                            if (TextUtils.isEmpty((CharSequence)string)) {
                                string = "UnknownError";
                            }
                            object = ((String)object).replaceAll("\u0001", " ");
                            try {
                                PubSubHelper.INSTANCE.publishError(RequestBuilder.buildErrorRequestBody(new String[]{string, object}));
                                break block6;
                                catch (Throwable throwable2) {
                                    break block7;
                                }
                            }
                            catch (Exception exception) {
                                MLog.d(TAG, "CrashUtil", exception);
                            }
                        }
                        return;
                    }
                    throw throwable2;
                }
            }
        };
        MintPoolExecuter.execute(ExecutorEnum.WorkExecutor, runnable2);
    }

    private static class CrashUtilHolder {
        private static final CrashUtil INSTANCE = new CrashUtil();

        private CrashUtilHolder() {
        }
    }
}

