/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.debug;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Debugger {
    private static final String TAG = "Debugger";
    private static volatile boolean sIsRegistered;
    private static final AtomicBoolean isDebugMode;
    private static final AtomicBoolean isStagingMode;
    private static final AtomicBoolean sUseCachedConfig;
    private static final BroadcastReceiver RECEIVER;

    private Debugger() {
    }

    public static synchronized void register(Context context) {
        IntentFilter intentFilter;
        if (sIsRegistered) {
            return;
        }
        Context context2 = context;
        sIsRegistered = true;
        context = intentFilter;
        try {
            new IntentFilter().addAction("com.mint.ad.intent.DEBUG_ON");
            context.addAction("com.mint.ad.intent.DEBUG_OFF");
            context.addAction("com.mint.ad.intent.STAGING_ON");
            context.addAction("com.mint.ad.intent.STAGING_OFF");
            context2.registerReceiver(RECEIVER, (IntentFilter)context);
        }
        catch (Throwable throwable) {
            sIsRegistered = false;
            throwable.printStackTrace();
        }
    }

    public static void setDebugMode(boolean bl) {
        isDebugMode.set(bl);
        MLog.setDebugOn(bl);
    }

    public static boolean isDebugMode() {
        return isDebugMode.get();
    }

    public static void setStagingMode(boolean bl) {
        isStagingMode.set(bl);
    }

    public static boolean isStagingMode() {
        return isStagingMode.get();
    }

    public static void setUseCachedConfig(boolean bl) {
        sUseCachedConfig.set(bl);
    }

    public static boolean getUseCachedConfig() {
        return sUseCachedConfig.get();
    }

    static {
        isDebugMode = new AtomicBoolean(false);
        isStagingMode = new AtomicBoolean(false);
        sUseCachedConfig = new AtomicBoolean(false);
        RECEIVER = new BroadcastReceiver(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onReceive(Context context, Intent intent) {
                void var2_4;
                if (var2_4 == null) {
                    return;
                }
                try {
                    String string = var2_4.getAction();
                    MLog.i(Debugger.TAG, "action = " + string);
                    if ("com.mint.ad.intent.DEBUG_ON".equals(string)) {
                        MLog.setDebugOn(true);
                        isDebugMode.set(true);
                        return;
                    }
                    if ("com.mint.ad.intent.DEBUG_OFF".equals(string)) {
                        MLog.setDebugOff();
                        isDebugMode.set(false);
                        return;
                    }
                    if ("com.mint.ad.intent.STAGING_ON".equals(string)) {
                        isStagingMode.set(true);
                        return;
                    }
                    if ("com.mint.ad.intent.STAGING_OFF".equals(string)) {
                        isStagingMode.set(false);
                        return;
                    }
                    Log.w((String)Debugger.TAG, (String)("Unknown action: " + string));
                    return;
                }
                catch (Throwable throwable) {
                    Log.e((String)Debugger.TAG, (String)"BroadcastReceiver exception: ", (Throwable)throwable);
                    return;
                }
            }
        };
    }
}

