/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.device;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingIdClient {
    private static final String TAG = "AdvertisingIdClient";

    private AdvertisingIdClient() {
    }

    public static void getGaid(OnGetGaidListener onGetGaidListener) {
        Object object = AdvertisingIdClient.getAdvertisingIdInfo(ContextProvider.INSTANCE.getContext());
        if (onGetGaidListener != null) {
            object = object != null ? ((AdInfo)object).advertisingId : "";
            onGetGaidListener.onGetGaid((String)object);
        }
    }

    public static void getGaid(Context object, OnGetGaidListener onGetGaidListener) {
        object = AdvertisingIdClient.getAdvertisingIdInfo(object);
        if (onGetGaidListener != null) {
            object = object != null ? ((AdInfo)object).advertisingId : "";
            onGetGaidListener.onGetGaid((String)object);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AdInfo getAdvertisingIdInfo(Context context) {
        Object object;
        Object object2;
        block16: {
            block15: {
                block17: {
                    AdInfo adInfo;
                    AdvertisingInterface advertisingInterface;
                    Intent intent;
                    AdvertisingConnection advertisingConnection;
                    AdvertisingConnection advertisingConnection2;
                    if (Looper.myLooper() == Looper.getMainLooper()) {
                        MLog.d(TAG, "getAdvertisingIdInfo Cannot be called from the main thread");
                        return null;
                    }
                    Context context2 = context;
                    object2 = null;
                    try {
                        context2.getPackageManager().getPackageInfo("com.android.vending", 0);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                        break block15;
                    }
                    catch (Exception exception) {
                        object = object2;
                        break block16;
                    }
                    object = advertisingConnection2;
                    {
                        advertisingConnection2 = new AdvertisingConnection();
                    }
                    try {
                        advertisingConnection = object;
                        intent = new Intent("com.google.android.gms.ads.identifier.service.START");
                        intent.setPackage("com.google.android.gms");
                    }
                    catch (Throwable throwable) {
                        object2 = object;
                        object = throwable;
                        break block15;
                    }
                    catch (Exception exception) {
                        break block16;
                    }
                    {
                        if (!context2.bindService(intent, (ServiceConnection)advertisingConnection, 1)) break block17;
                    }
                    object2 = advertisingInterface;
                    {
                        advertisingInterface = new AdvertisingInterface(((AdvertisingConnection)object).getBinder());
                        MLog.d(TAG, "Gaid:" + ((AdvertisingInterface)object2).getId());
                    }
                    AdInfo adInfo2 = adInfo;
                    {
                        Object object3 = object2;
                        object2 = ((AdvertisingInterface)object3).getId();
                        adInfo2((String)object2, ((AdvertisingInterface)object3).isLimitAdTrackingEnabled(true));
                        context.unbindService((ServiceConnection)object);
                    }
                    return adInfo;
                }
                context.unbindService((ServiceConnection)object);
                return null;
            }
            if (object2 != null) {
                context.unbindService(object2);
            }
            throw object;
        }
        object2 = null;
        if (object != null) {
            context.unbindService((ServiceConnection)object);
        }
        return object2;
    }

    public static interface OnGetGaidListener {
        public void onGetGaid(String var1);
    }

    private static final class AdvertisingInterface
    implements IInterface {
        private final IBinder binder;

        AdvertisingInterface(IBinder iBinder) {
            this.binder = iBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        public String getId() throws RemoteException {
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, parcel, parcel2, 0);
            }
            catch (Throwable throwable) {
                parcel2.recycle();
                parcel.recycle();
                throw throwable;
            }
            parcel2.readException();
            String string = parcel2.readString();
            parcel2.recycle();
            parcel.recycle();
            return string;
        }

        boolean isLimitAdTrackingEnabled(boolean bl) throws RemoteException {
            int n2;
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                n2 = bl ? 1 : 0;
            }
            catch (Throwable throwable) {
                parcel2.recycle();
                parcel.recycle();
                throw throwable;
            }
            Parcel parcel3 = parcel2;
            Parcel parcel4 = parcel3;
            Parcel parcel5 = parcel3;
            parcel.writeInt(n2);
            this.binder.transact(2, parcel, parcel2, 0);
            parcel4.readException();
            boolean bl2 = parcel5.readInt() != 0;
            parcel2.recycle();
            parcel.recycle();
            return bl2;
        }
    }

    private static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue;

        private AdvertisingConnection() {
            LinkedBlockingQueue linkedBlockingQueue;
            LinkedBlockingQueue linkedBlockingQueue2 = linkedBlockingQueue;
            linkedBlockingQueue = new LinkedBlockingQueue(1);
            v1.queue = linkedBlockingQueue2;
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this.queue.put(iBinder);
            }
            catch (Throwable throwable) {
                MLog.d(AdvertisingIdClient.TAG, AdvertisingIdClient.TAG, throwable);
                CrashUtil.getSingleton().saveException(throwable);
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        IBinder getBinder() throws InterruptedException {
            if (!this.retrieved) {
                this.retrieved = true;
                return this.queue.take();
            }
            throw new IllegalStateException();
        }
    }

    public static final class AdInfo {
        private final String advertisingId;
        private final boolean limitAdTrackingEnabled;

        AdInfo(String string, boolean bl) {
            this.advertisingId = string;
            this.limitAdTrackingEnabled = bl;
        }

        public String getId() {
            return this.advertisingId;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }
    }
}

