/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.device;

import android.content.Context;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.SharedPreferencesUtils;
import java.io.IOException;

public class AdvertisingIdUtil {
    private static final String DEFAULT_GAID = "00000000-0000-0000-0000-000000000000";
    private static String sGaid;
    private static String KEY_Time = "KEY_Time";

    private AdvertisingIdUtil() {
        throw new IllegalStateException("AdvertisingIdUtil class");
    }

    public static String getGaid() {
        return AdvertisingIdUtil.getGaid(null);
    }

    public static String getGaid(final Context context) {
        boolean bl = System.currentTimeMillis() / 1000L > SharedPreferencesUtils.getInstance().getLong(KEY_Time) + 86400L;
        String string = SharedPreferencesUtils.getInstance().getString("AdvertisingId", DEFAULT_GAID);
        if (!DEFAULT_GAID.equals(string) && !bl) {
            return string;
        }
        string = sGaid;
        if (string == null || string.isEmpty() || bl) {
            sGaid = string = SharedPreferencesUtils.getInstance().getString("AdvertisingId", DEFAULT_GAID);
            if (DEFAULT_GAID.equals(string) || bl) {
                MintPoolExecuter.execute(ExecutorEnum.WorkExecutor, new Runnable(){

                    @Override
                    public void run() {
                        AdvertisingIdUtil.requestAdvertisingId(context);
                    }
                });
            }
        }
        return sGaid;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void requestAdvertisingId(Context object) {
        void var0_2;
        if (object == null) {
            Context context = ContextProvider.INSTANCE.getContext();
        }
        if (var0_2 == null) {
            return;
        }
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)var0_2);
        if (info == null) return;
        sGaid = info.getId();
        SharedPreferencesUtils sharedPreferencesUtils = SharedPreferencesUtils.getInstance();
        sharedPreferencesUtils.put("AdvertisingId", (Object)sGaid);
        long l2 = System.currentTimeMillis() / 1000L;
        SharedPreferencesUtils sharedPreferencesUtils2 = SharedPreferencesUtils.getInstance();
        long l3 = l2;
        String string = KEY_Time;
        try {
            sharedPreferencesUtils2.put(string, (Object)l3);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            googlePlayServicesRepairableException.printStackTrace();
            return;
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            googlePlayServicesNotAvailableException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return;
    }
}

