/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.device;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.webkit.WebSettings;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.DataCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.device.AdvertisingIdUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class DeviceUtil {
    private static final String TAG = "DeviceUtil";
    private static String mSessionId;
    private static long mSessionTime;
    private static String mAppVersion = "";

    private DeviceUtil() {
    }

    public static boolean isActivityAvailable(Activity activity) {
        if (activity == null) {
            return false;
        }
        boolean bl = false;
        if (Build.VERSION.SDK_INT >= 17 ? !activity.isDestroyed() : !activity.isFinishing()) {
            bl = true;
        }
        return bl;
    }

    public static Map<String, Object> preFetchDeviceInfo(Context object) {
        HashMap hashMap;
        object = hashMap;
        hashMap = new HashMap();
        String string = AdvertisingIdUtil.getGaid();
        MLog.d(TAG, "Gaid:" + string);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            object.put("AdvertisingId", string);
        }
        return object;
    }

    public static Map<String, Object> getLocaleInfo() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("langname", Locale.getDefault().getDisplayLanguage());
        hashMap.put("lcountry", Locale.getDefault().getCountry());
        hashMap.put("lang", Locale.getDefault().getLanguage());
        return hashMap;
    }

    public static String getSystemProperties(String object) {
        block6: {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            Method method = clazz.getMethod("get", classArray);
            object = method.invoke(null, object);
            if (object == null) break block6;
            try {
                return object.toString();
            }
            catch (Exception exception) {
                MLog.d(TAG, TAG, exception);
                CrashUtil.getSingleton().saveException(exception);
            }
        }
        return null;
    }

    public static String getUserAgent(Context object) {
        StringBuilder stringBuilder;
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                object = WebSettings.getDefaultUserAgent((Context)object);
            }
            catch (Throwable throwable) {
                object = System.getProperty("http.agent");
            }
        } else {
            object = System.getProperty("http.agent");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (object != null) {
            int n2 = ((String)object).length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = ((String)object).charAt(i2);
                if (c2 > '\u001f' && c2 < '\u007f') {
                    stringBuilder2.append(c2);
                    continue;
                }
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = (int)c2;
                stringBuilder2.append(String.format("\\u%04x", objectArray2));
            }
        }
        return stringBuilder2.toString();
    }

    private static boolean isFacebookInstall(Context context) {
        try {
            return context.getPackageManager().getPackageInfo("com.facebook.katana", 256) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int isGpInstall(Context context) {
        try {
            return context.getPackageManager().getPackageInfo("com.android.vending", 256) != null ? 0 : 1;
        }
        catch (Exception exception) {
            MLog.d(TAG, TAG, exception);
            return 1;
        }
    }

    public static int getTimeZoneOffset() {
        return TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 60000;
    }

    public static String getTimeZone() {
        return TimeZone.getDefault().getID();
    }

    public static String getVersionName(Context context) {
        if (context == null) {
            return mAppVersion;
        }
        try {
            mAppVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            MLog.e(TAG, "getVersionName", nameNotFoundException);
        }
        return mAppVersion;
    }

    public static String getUid() {
        String string;
        if (DataCache.getInstance().containsKey("uid")) {
            string = DataCache.getInstance().get("uid", String.class);
        } else {
            string = DeviceUtil.generateUid();
            DataCache.getInstance().set("uid", string);
            DataCache.getInstance().set("flt", System.currentTimeMillis());
        }
        return string;
    }

    public static long getFlt() {
        return DataCache.getInstance().containsKey("flt") ? DataCache.getInstance().get("flt", Long.TYPE) / 1000L : 0L;
    }

    public static long getFit() {
        Object object;
        block8: {
            PackageManager packageManager;
            block7: {
                block6: {
                    try {
                        object = ContextProvider.INSTANCE.getContext();
                        if (object != null) break block6;
                        return 0L;
                    }
                    catch (Exception exception) {
                        return 0L;
                    }
                }
                Context context = object;
                Context context2 = context;
                object = context.getPackageName();
                packageManager = context2.getPackageManager();
                if (packageManager != null) break block7;
                return 0L;
            }
            object = packageManager.getPackageInfo((String)object, 256);
            if (object != null) break block8;
            return 0L;
        }
        return object.firstInstallTime / 1000L;
    }

    public static void initSessionTime() {
        mSessionTime = SystemClock.elapsedRealtime();
    }

    public static String getSessionId() {
        if (mSessionId == null) {
            mSessionId = new UUID(DeviceUtil.getUid().hashCode(), System.currentTimeMillis()).toString();
        }
        return mSessionId;
    }

    public static long getSessionStartTime() {
        return mSessionTime;
    }

    public static long getSessionOffset() {
        long l2 = DeviceUtil.getSessionStartTime();
        if (l2 == 0L) {
            return -1L;
        }
        return SystemClock.elapsedRealtime() - l2;
    }

    public static long getBtime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    private static String generateUid() {
        return UUID.randomUUID().toString();
    }

    public static boolean isPersonalizedAdEnabled(Context context) {
        block11: {
            Class<?> clazz;
            block10: {
                clazz = Class.forName("android.provider.MiuiSettings$Ad");
                if (clazz.getDeclaredMethods().length != 0) break block10;
                MLog.e(TAG, "No get systemPersonalizedAdEnabled");
                return true;
            }
            Class[] classArray = new Class[1];
            classArray[0] = ContentResolver.class;
            Method method = clazz.getDeclaredMethod("isPersonalizedAdEnabled", classArray);
            Object[] objectArray = new Object[1];
            int n2 = 0;
            objectArray[n2] = context.getContentResolver();
            Object object = method.invoke(null, objectArray);
            if (!(object instanceof Boolean)) break block11;
            try {
                return (Boolean)object;
            }
            catch (Exception exception) {
                MLog.d(TAG, "isPersonalizedAdEnabled exception: ", exception);
            }
        }
        return true;
    }
}

