/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.device;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class SensorManager {
    private static final String TAG = "SensorManager";
    private final BitSet mSensorsType = new BitSet(6);
    private android.hardware.SensorManager mSensorManager;
    private List<SensorListener> mSensorEventListenerList;
    private JSONArray mSensorArrays;

    public static SensorManager getSingleton() {
        return SmHolder.singleton;
    }

    private SensorManager() {
        Context context = ContextProvider.INSTANCE.getContext();
        SensorManager sensorManager = this;
        sensorManager.mSensorEventListenerList = new ArrayList<SensorListener>();
        sensorManager.mSensorsType.set(1);
        sensorManager.mSensorsType.set(2);
        sensorManager.mSensorsType.set(4);
        this.mSensorManager = (android.hardware.SensorManager)context.getSystemService("sensor");
        MintPoolExecuter.execute(ExecutorEnum.WorkExecutor, new RegisterSensorListenerRunnable());
        ExecutorEnum executorEnum = ExecutorEnum.WorkExecutor;
        UnRegisterSensorListenerRunnable unRegisterSensorListenerRunnable = new UnRegisterSensorListenerRunnable();
        try {
            MintPoolExecuter.execute(executorEnum, unRegisterSensorListenerRunnable, 10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            CrashUtil.getSingleton().saveException(throwable);
            MLog.e(TAG, "SensorManager error:", throwable);
        }
    }

    private List<Float> array2List(float[] fArray) throws Exception {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(fArray.length);
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(Float.valueOf(fArray[i2]));
        }
        return arrayList2;
    }

    private static double valuesPow(float[] fArray, float[] fArray2) throws Exception {
        double d2 = 0.0;
        for (int i2 = 0; i2 < Math.min(fArray.length, fArray2.length); ++i2) {
            d2 += StrictMath.pow(fArray[i2] - fArray2[i2], 2.0);
        }
        return Math.sqrt(d2);
    }

    static /* synthetic */ double access$700(float[] fArray, float[] fArray2) throws Exception {
        return SensorManager.valuesPow(fArray, fArray2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONArray getSensorData() {
        JSONArray jSONArray;
        Object object;
        block5: {
            ArrayList arrayList;
            object = this.mSensorArrays;
            if (object != null && object.length() > 0) {
                return this.mSensorArrays;
            }
            object = arrayList;
            arrayList = new ArrayList();
            try {
                if (this.mSensorEventListenerList.isEmpty()) break block5;
                for (SensorListener sensorListener : this.mSensorEventListenerList) {
                    MLog.d(TAG, "UNRegisterListener:" + sensorListener.mSensorName);
                    this.mSensorManager.unregisterListener((SensorEventListener)sensorListener);
                    object.add(sensorListener.getData());
                }
            }
            catch (Throwable throwable) {
                CrashUtil.getSingleton().saveException(throwable);
                MLog.e(TAG, "SensorManager getSensors error:", throwable);
            }
            {
                continue;
                break;
            }
        }
        JSONArray jSONArray2 = jSONArray;
        jSONArray2((Collection)object);
        this.mSensorArrays = jSONArray2;
        return jSONArray;
    }

    class SensorListener
    implements SensorEventListener {
        private int mSensorType;
        private String mSensorName;
        private String mSensorVendor;
        private float[][] mSensorValues;
        private double mValuePow;
        private long mNowTime;
        final /* synthetic */ SensorManager this$0;

        private SensorListener(SensorManager sensorManager, Sensor sensor) {
            SensorListener sensorListener = this;
            this.this$0 = sensorManager;
            try {
                this.mSensorType = sensor.getType();
                this.mSensorName = sensor.getName();
                sensorListener.mSensorVendor = sensor.getVendor();
                sensorListener.mSensorValues = new float[2][];
            }
            catch (Throwable throwable) {
                MLog.e(SensorManager.TAG, "SensorManager error:", throwable);
                CrashUtil.getSingleton().saveException(throwable);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void onSensorChanged(SensorEvent var1_4) {
            block25: {
                block26: {
                    if (var1_4 == null) break block25;
                    if (var1_4.values == null) break block25;
                    var2_7 /* !! */  = var1_4.sensor;
                    if (var2_7 /* !! */  == null) break block25;
                    if (var2_7 /* !! */ .getName() == null) break block25;
                    if (var2_7 /* !! */ .getVendor() == null) break block25;
                    v0 = this;
                    v1 = var1_4;
                    v2 = v1;
                    v3 = v1;
                    v4 = v1;
                    v5 = v1;
                    var1_5 = v1.sensor.getType();
                    var2_7 /* !! */  = v3.sensor.getName();
                    var3_9 = v4.sensor.getVendor();
                    var4_10 = v5.timestamp;
                    var6_11 = v2.values;
                    if (v0.mSensorType != var1_5) break block25;
                    if (!this.mSensorName.equals(var2_7 /* !! */ )) break block25;
                    if (!this.mSensorVendor.equals(var3_9)) break block25;
                    var1_6 = this.mSensorValues[0];
                    if (var1_6 != null) ** GOTO lbl42
                    v6 = this.mSensorValues;
                    var0_1 = 0;
                    v6[var0_1] = Arrays.copyOf(var6_11, var6_11.length);
                    return;
lbl42:
                    // 1 sources

                    v7 = this.mSensorValues[1];
                    var2_7 /* !! */  = (Sensor)v7;
                    if (v7 == null) {
                        v8 = this;
                        v9 = var1_6;
                        var1_6 = Arrays.copyOf(var6_11, var6_11.length);
                        this.mSensorValues[1] = var1_6;
                        v8.mValuePow = SensorManager.access$700(v9, var1_6);
                    }
                    if (50000000L > var4_10 - this.mNowTime) break block25;
                    this.mNowTime = var4_10;
                    if (!Arrays.equals((float[])var2_7 /* !! */ , var6_11)) break block26;
                    return;
                }
                var2_8 = SensorManager.access$700(var1_6, var6_11);
                if (!(v10 > this.mValuePow)) break block25;
                v11 = this;
                v12 = var2_8;
                v13 = this.mSensorValues;
                var0_2 = 1;
                try {
                    v13[var0_2] = Arrays.copyOf(var6_11, var6_11.length);
                    v11.mValuePow = v12;
                }
                catch (Throwable var0_3) {
                    MLog.e("SensorManager", "SensorManager onSensorChanged error:", var0_3);
                    CrashUtil.getSingleton().saveException(var0_3);
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int n2) {
        }

        public JSONObject getData() {
            float[] fArray;
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            Object object = "sT";
            jSONObject2.put((String)object, this.mSensorType);
            object = "sN";
            jSONObject2.put((String)object, (Object)this.mSensorName);
            object = "sV";
            jSONObject.put((String)object, (Object)this.mSensorVendor);
            float[] fArray2 = this.mSensorValues[0];
            object = fArray2;
            if (fArray2 != null) {
                jSONObject2.put("sVS", (Object)new JSONArray((Collection)this.this$0.array2List((float[])object)));
            }
            try {
                fArray = this.mSensorValues[1];
            }
            catch (Throwable throwable) {
                MLog.e(SensorManager.TAG, "SensorManager getData error:", throwable);
                CrashUtil.getSingleton().saveException(throwable);
            }
            object = fArray;
            if (fArray != null) {
                jSONObject2.put("sVE", (Object)new JSONArray((Collection)this.this$0.array2List((float[])object)));
            }
            return jSONObject2;
        }
    }

    class UnRegisterSensorListenerRunnable
    implements Runnable {
        UnRegisterSensorListenerRunnable() {
        }

        @Override
        public void run() {
            SensorManager.this.getSensorData();
        }
    }

    class RegisterSensorListenerRunnable
    implements Runnable {
        RegisterSensorListenerRunnable() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Iterator iterator;
            if (SensorManager.this.mSensorManager == null) return;
            try {
                iterator = SensorManager.this.mSensorManager.getSensorList(-1).iterator();
            }
            catch (Throwable throwable) {
                MLog.e(SensorManager.TAG, "SensorManager RegisterSensorListenerRunnable error:", throwable);
                CrashUtil.getSingleton().saveException(throwable);
            }
            while (true) {
                SensorListener sensorListener;
                if (!iterator.hasNext()) return;
                RegisterSensorListenerRunnable registerSensorListenerRunnable = this;
                Sensor sensor = (Sensor)iterator.next();
                if (!registerSensorListenerRunnable.SensorManager.this.mSensorsType.get(sensor.getType())) continue;
                RegisterSensorListenerRunnable registerSensorListenerRunnable2 = this;
                RegisterSensorListenerRunnable registerSensorListenerRunnable3 = registerSensorListenerRunnable2;
                RegisterSensorListenerRunnable registerSensorListenerRunnable4 = registerSensorListenerRunnable2;
                SensorListener sensorListener2 = sensorListener;
                sensorListener = new SensorListener(SensorManager.this, sensor);
                registerSensorListenerRunnable3.SensorManager.this.mSensorEventListenerList.add(sensorListener2);
                MLog.d(SensorManager.TAG, "RegisterListener:" + sensorListener2.mSensorName);
                registerSensorListenerRunnable4.SensorManager.this.mSensorManager.registerListener((SensorEventListener)sensorListener2, sensor, 0);
            }
        }
    }

    private static class SmHolder {
        private static final SensorManager singleton = new SensorManager();

        private SmHolder() {
        }
    }
}

