/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.event;

import android.content.Context;
import com.zeus.gmc.sdk.mobileads.mintmediation.a.q;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.device.DeviceUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.event.DataBaseEventsStorage;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.event.Event;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.helper.PubSubHelper;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Configurations;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Events;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.RequestBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class EventUploadManager {
    private static final String TAG = "EventMgr";
    private final AtomicBoolean isReporting;
    private final AtomicInteger mMaxReportEventsCount;
    private ConcurrentLinkedQueue<Event> mEvents;
    private final Queue<Event> mDelayEvents;
    private DataBaseEventsStorage mEventDataBase;
    private List<Integer> mAllowedEvents;
    private ConcurrentLinkedQueue<Event> mReportEvents;
    private Events mEventsSettings;

    private EventUploadManager() {
        ConcurrentLinkedQueue concurrentLinkedQueue;
        AtomicInteger atomicInteger;
        AtomicBoolean atomicBoolean;
        Object object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.isReporting = object;
        object = atomicInteger;
        atomicInteger = new AtomicInteger(5);
        v1.mMaxReportEventsCount = object;
        object = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        v1.mDelayEvents = object;
    }

    public static EventUploadManager getInstance() {
        return DataBaseUtilHolder.INSTANCE;
    }

    private void loadEvents() {
        if (this.mEvents == null) {
            ConcurrentLinkedQueue concurrentLinkedQueue;
            ConcurrentLinkedQueue concurrentLinkedQueue2 = concurrentLinkedQueue;
            concurrentLinkedQueue = new ConcurrentLinkedQueue();
            this.mEvents = concurrentLinkedQueue2;
        }
        this.mEvents.addAll(this.mEventDataBase.loadEvents());
    }

    private void uploadEvent(Event event) {
        Object object = ((EventUploadManager)((Object)dataBaseEventsStorage)).mAllowedEvents;
        if (object == null) {
            EventUploadManager eventUploadManager = dataBaseEventsStorage;
            eventUploadManager.mDelayEvents.add(event);
            DataBaseEventsStorage dataBaseEventsStorage = eventUploadManager.mEventDataBase;
            if (dataBaseEventsStorage != null) {
                dataBaseEventsStorage.addEvent(event);
            }
            return;
        }
        if (object.isEmpty()) {
            ((EventUploadManager)((Object)dataBaseEventsStorage)).mDelayEvents.clear();
            return;
        }
        if (!((EventUploadManager)((Object)dataBaseEventsStorage)).mAllowedEvents.contains(event.getEid())) {
            return;
        }
        if (((EventUploadManager)((Object)dataBaseEventsStorage)).mEvents == null) {
            ConcurrentLinkedQueue concurrentLinkedQueue;
            object = concurrentLinkedQueue;
            concurrentLinkedQueue = new ConcurrentLinkedQueue();
            ((EventUploadManager)((Object)dataBaseEventsStorage)).mEvents = object;
        }
        Object object2 = dataBaseEventsStorage;
        MLog.v(TAG, "save event " + event.toString());
        ((EventUploadManager)object2).mEvents.add(event);
        object = ((EventUploadManager)object2).mEventDataBase;
        if (object != null) {
            ((DataBaseEventsStorage)((Object)object)).addEvent(event);
        }
        if (((EventUploadManager)((Object)dataBaseEventsStorage)).mEvents.size() >= ((EventUploadManager)((Object)dataBaseEventsStorage)).mMaxReportEventsCount.get()) {
            MLog.d(TAG, "update events by reached max events count");
            super.uploadEvents();
        }
    }

    private void uploadEventDelay() {
        if (!this.mDelayEvents.isEmpty()) {
            Iterator iterator = this.mDelayEvents.iterator();
            while (iterator.hasNext()) {
                this.uploadEvent((Event)iterator.next());
            }
            this.mDelayEvents.clear();
        }
    }

    private Event buildEvent(int n2, JSONObject jSONObject) {
        Event event;
        Event event2 = event;
        event = new Event(jSONObject);
        if (n2 != 0) {
            event2.setEid(n2);
        }
        Event event3 = event2;
        event3.setTs(System.currentTimeMillis());
        event3.setAppv(DeviceUtil.getVersionName(ContextProvider.INSTANCE.getContext()));
        event3.setSessionId(DeviceUtil.getSessionId());
        long l2 = DeviceUtil.getSessionOffset();
        if (l2 >= 0L) {
            event2.setSt(l2);
        }
        return event2;
    }

    /*
     * Unable to fully structure code
     */
    private void uploadEvents() {
        block17: {
            block16: {
                if (this.mEventsSettings == null) ** GOTO lbl42
                if (this.mEvents == null) ** GOTO lbl42
                if (this.mEvents.isEmpty()) ** GOTO lbl42
                if (this.isReporting.get()) ** GOTO lbl42
                v0 = this;
                v0.isReporting.set(true);
                var1_1 = v0.mEvents.iterator();
                var2_3 = 0;
                while (true) {
                    block15: {
                        if (var2_3 >= this.mMaxReportEventsCount.get()) break;
                        if (!var1_1.hasNext()) break block15;
                        this.mReportEvents.add(var1_1.next());
                    }
                    ++var2_3;
                }
                if (!this.mReportEvents.isEmpty()) break block16;
                return;
            }
            var1_1 = RequestBuilder.buildEventRequestJSON(this.mReportEvents);
            if (var1_1 != null) ** GOTO lbl35
            MLog.d("EventMgr", "build events request data error");
            return;
lbl35:
            // 1 sources

            v1 = this;
            PubSubHelper.INSTANCE.publishEvent(var1_1.toString());
            v1.clearEvents();
            v1.isReporting.set(false);
            if (v1.mEvents.size() < this.mMaxReportEventsCount.get()) break block17;
            try {
                block18: {
                    break block18;
lbl42:
                    // 4 sources

                    return;
                }
                MLog.d("EventMgr", "update events after upload success");
                this.uploadEvents();
            }
            catch (Exception var1_2) {
                var2_4 = this.mReportEvents;
                if (var2_4 != null) {
                    var2_4.clear();
                }
                this.isReporting.set(false);
                MLog.d("EventMgr", "update events exception : " + var1_2.getMessage());
                CrashUtil.getSingleton().saveException(var1_2);
            }
        }
    }

    private void clearEvents() {
        Object object = this.mReportEvents;
        if (object != null && !((ConcurrentLinkedQueue)object).isEmpty()) {
            object = this.mEvents;
            if (object != null) {
                ((ConcurrentLinkedQueue)object).removeAll(this.mReportEvents);
            }
            if ((object = this.mEventDataBase) != null) {
                ((DataBaseEventsStorage)((Object)object)).clearEvents(this.mReportEvents);
            }
            this.mReportEvents.clear();
            return;
        }
    }

    public void init(Context context) {
        ConcurrentLinkedQueue concurrentLinkedQueue;
        if (this.mEvents == null) {
            ConcurrentLinkedQueue concurrentLinkedQueue2;
            concurrentLinkedQueue = concurrentLinkedQueue2;
            concurrentLinkedQueue2 = new ConcurrentLinkedQueue();
            this.mEvents = concurrentLinkedQueue;
        }
        EventUploadManager eventUploadManager = this;
        eventUploadManager.mDelayEvents.clear();
        if (eventUploadManager.mReportEvents == null) {
            ConcurrentLinkedQueue concurrentLinkedQueue3;
            concurrentLinkedQueue = concurrentLinkedQueue3;
            concurrentLinkedQueue3 = new ConcurrentLinkedQueue();
            this.mReportEvents = concurrentLinkedQueue;
        }
        if (this.mEventDataBase == null) {
            this.mEventDataBase = DataBaseEventsStorage.getInstance(context);
            this.mEventDataBase.createTable();
        }
        MintPoolExecuter.execute(ExecutorEnum.EventExecutor, new LastStayEvent());
    }

    public void uploadEvent(int n2, JSONObject jSONObject) {
        if (!q.h().y()) {
            return;
        }
        MintPoolExecuter.execute(ExecutorEnum.EventExecutor, () -> {
            EventUploadManager eventUploadManager = this;
            eventUploadManager.uploadEvent(eventUploadManager.buildEvent(n2, jSONObject));
        });
    }

    public synchronized void updateReportSettings(Configurations object) {
        this.mAllowedEvents = new ArrayList<Integer>();
        if (((Configurations)object).getEvents() == null) {
            return;
        }
        EventUploadManager eventUploadManager = this;
        object = ((Configurations)object).getEvents();
        eventUploadManager.mEventsSettings = object;
        eventUploadManager.mMaxReportEventsCount.set(((Events)object).getMn());
        if (eventUploadManager.mEventsSettings.getIds() != null) {
            this.mAllowedEvents.addAll(this.mEventsSettings.getIds());
        }
        if (this.mEventsSettings.getCi() != 0) {
            MintPoolExecuter.scheduleEventWithFixedDelay(new EventRunnable(), this.mEventsSettings.getCi(), this.mEventsSettings.getCi(), TimeUnit.SECONDS);
        }
        if (!this.mAllowedEvents.isEmpty()) {
            this.uploadEventDelay();
        }
    }

    private class LastStayEvent
    implements Runnable {
        private LastStayEvent() {
        }

        @Override
        public void run() {
            if (EventUploadManager.this.mEventDataBase != null) {
                EventUploadManager.this.loadEvents();
            }
        }
    }

    private class EventRunnable
    implements Runnable {
        private EventRunnable() {
        }

        @Override
        public void run() {
            if (!EventUploadManager.this.mEvents.isEmpty()) {
                MLog.d(EventUploadManager.TAG, "update events by reached interval");
                EventUploadManager.this.uploadEvents();
            }
        }
    }

    private static class DataBaseUtilHolder {
        private static final EventUploadManager INSTANCE = new EventUploadManager();

        private DataBaseUtilHolder() {
        }
    }
}

