/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.helper;

import android.text.TextUtils;
import android.util.SparseArray;
import com.zeus.gmc.sdk.mobileads.mintmediation.a.x.b.a;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.AdapterUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.Gzip;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.SharedPreferencesUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.error.ErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.ApiConfigurations;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.BaseInstance;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Configurations;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Events;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Instance;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Mediation;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Placement;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Scene;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.HeaderUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.RequestBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.AdRequest;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.ByteRequestBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Headers;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Request;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Response;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigurationHelper {
    private static final String TAG = "ConfigurationHelper";
    public static final int SOURCE_SERVER = 0;
    public static final int SOURCE_CACHED = 1;
    public static final int SOURCE_DEFAULT = 2;
    private static int sSource = 1;
    private static JSONObject sDefaultConfig;
    private static String sLocalConfig;
    private static Configurations sConfigurations;
    private static ApiConfigurations sApiConfigurations;
    private static SparseArray<Mediation> sMediationSparseArray;
    private static Map<String, Placement> sPlacementMap;

    private ConfigurationHelper() {
    }

    public static void getConfiguration(String string, Request.OnRequestCallback onRequestCallback) throws Exception {
        if (onRequestCallback == null) {
            MLog.e(TAG, "requestCallback == null, return");
            return;
        }
        JSONArray jSONArray = AdapterUtil.getAdns();
        if (ConfigurationHelper.shouldUseCachedInitConfig()) {
            MLog.v(TAG, "getConfiguration: use cached configuration");
            onRequestCallback.onRequestSuccess(null);
        }
        if (TextUtils.isEmpty((CharSequence)(string = RequestBuilder.buildInitUrl(string)))) {
            onRequestCallback.onRequestFailed(ErrorBuilder.build(133));
            MLog.e(TAG, "initUrl is empty, return");
            return;
        }
        MLog.d(TAG, "start invoke url");
        AdRequest.post().url(string).headers(HeaderUtils.getBaseHeaders()).body(new ByteRequestBody(RequestBuilder.buildConfigRequestBody(jSONArray))).connectTimeout(30000).readTimeout(60000).encryptBody(true).gzip(true).instanceFollowRedirects(true).callback(onRequestCallback).performRequest(ContextProvider.INSTANCE.getContext());
    }

    public static Configurations getConfigurations() {
        return sConfigurations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] checkResponse(Response object) {
        byte[] byArray = null;
        if (object == null) {
            return null;
        }
        if (((Response)object).code() != 200) {
            return null;
        }
        Object object2 = object;
        Object object3 = object2;
        byArray = ((Response)object2).body().byteArray();
        object = ((Response)object3).headers();
        if (object == null) return byArray;
        if (!"gzip".equals(((Headers)object).getFirst("Content-Encoding"))) return byArray;
        Object object4 = object;
        byArray = Gzip.unGZip(byArray);
        try {
            ((Headers)object4).remove("gzip");
        }
        catch (Exception exception) {
            CrashUtil.getSingleton().saveException(exception);
        }
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    public static Configurations parseFormServerResponse(String var0) {
        block8: {
            block9: {
                block7: {
                    try {
                        if (ConfigurationHelper.sConfigurations != null) break block7;
                    }
                    catch (Exception var0_1) {
                        CrashUtil.getSingleton().saveException(var0_1);
                        return null;
                    }
                    ConfigurationHelper.sConfigurations = new Configurations();
                }
                var1_2 = v0;
                v0 = new JSONObject((String)var0);
                ConfigurationHelper.sConfigurations.setD(var1_2.optInt("d"));
                ConfigurationHelper.sConfigurations.setCoa(var1_2.optInt("coa"));
                ConfigurationHelper.sConfigurations.setCountry(var1_2.optString("country"));
                ConfigurationHelper.sConfigurations.setIp(var1_2.optString("ip"));
                ConfigurationHelper.sConfigurations.setApi(ConfigurationHelper.parseApiConfiguration(var1_2.optJSONObject("api")));
                var0 = v0.optJSONObject("events");
                if (var0 == null) ** GOTO lbl22
                ConfigurationHelper.sConfigurations.setEvents(new Events((JSONObject)var0));
                break block9;
lbl22:
                // 1 sources

                ConfigurationHelper.sConfigurations.setEvents(new Events());
            }
            ConfigurationHelper.sConfigurations.setCet(var1_2.optLong("config_expired_time"));
            ConfigurationHelper.sConfigurations.setIt(var1_2.optInt("init_type"));
            var2_3 = var1_2.optLong("tsit");
            if (var2_3 <= 0L) break block8;
            var2_3 *= 1000L;
        }
        ConfigurationHelper.sConfigurations.setTsit(var2_3);
        ConfigurationHelper.sConfigurations.setAvc(var1_2.optInt("avc"));
        var0 = ConfigurationHelper.parseMediationConfigurations(var1_2.optJSONArray("ms"));
        ConfigurationHelper.sConfigurations.setMs(var0);
        ConfigurationHelper.sConfigurations.setPls(ConfigurationHelper.formatPlacement(var0, var1_2.optJSONArray("pls")));
        ConfigurationHelper.sConfigurations.setBidExpireTime(var1_2.optInt("bet"));
        ConfigurationHelper.sConfigurations.setWfExpireTime(var1_2.optInt("wet"));
        ConfigurationHelper.sConfigurations.setInsreResquestNum(var1_2.optInt("irn"));
        ConfigurationHelper.sConfigurations.setFullRequestNum(var1_2.optInt("frn"));
        return ConfigurationHelper.sConfigurations;
    }

    private static ApiConfigurations parseApiConfiguration(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        if (sApiConfigurations == null) {
            sApiConfigurations = new ApiConfigurations();
        }
        sApiConfigurations.setWf(jSONObject.optString("wf"));
        sApiConfigurations.setLr(jSONObject.optString("lr"));
        sApiConfigurations.setEr(jSONObject.optString("er"));
        sApiConfigurations.setIc(jSONObject.optString("ic"));
        sApiConfigurations.setIap(jSONObject.optString("iap"));
        sApiConfigurations.setHb(jSONObject.optString("hb"));
        sApiConfigurations.setLrTopic(jSONObject.optString("lrTopic"));
        sApiConfigurations.setEventTopic(jSONObject.optString("eventTopic"));
        sApiConfigurations.setErrorTopic(jSONObject.optString("errorTopic"));
        return sApiConfigurations;
    }

    private static Map<String, Placement> formatPlacement(SparseArray<Mediation> sparseArray, JSONArray jSONArray) {
        int n2;
        if (sPlacementMap == null) {
            sPlacementMap = new ConcurrentHashMap<String, Placement>();
        }
        if ((n2 = jSONArray.length()) == 0) {
            return sPlacementMap;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Placement placement;
            JSONObject jSONObject = jSONArray.optJSONObject(i2);
            String string = String.valueOf(jSONObject.optInt("id"));
            int n3 = jSONObject.optInt("t");
            if (sPlacementMap.containsKey(string) && sPlacementMap.get(string) != null) {
                placement = sPlacementMap.get(string);
            } else {
                Placement placement2;
                placement = placement2;
                placement2 = new Placement();
            }
            if (placement == null) continue;
            placement.setOriData(jSONObject.toString());
            placement.setId(string);
            placement.setT(n3);
            placement.setFrequencyCap(jSONObject.optInt("fc"));
            placement.setFrequencyUnit(jSONObject.optInt("fu") * 60 * 60 * 1000);
            placement.setFrequencyInterval(jSONObject.optInt("fi") * 1000);
            placement.setRf(jSONObject.optInt("rf"));
            SparseArray<BaseInstance> sparseArray2 = jSONObject.optJSONObject("rfs");
            if (sparseArray2 != null) {
                TreeMap<Integer, Integer> treeMap;
                TreeMap<Integer, Integer> treeMap2 = treeMap;
                treeMap = new TreeMap<Integer, Integer>();
                Iterator iterator = sparseArray2.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Object object = string2;
                    object = Integer.valueOf((String)object);
                    treeMap2.put((Integer)object, sparseArray2.optInt(string2));
                }
                placement.setRfs(treeMap2);
            }
            placement.setCs(jSONObject.optInt("cs", 1));
            placement.setBs(jSONObject.optInt("bs"));
            placement.setFo(jSONObject.optInt("fo"));
            placement.setPt(jSONObject.optInt("pt"));
            placement.setRlw(jSONObject.optInt("rlw"));
            boolean bl = jSONObject.optInt("hb") == 1;
            placement.setHasHb(bl);
            placement.setMain(jSONObject.optInt("main"));
            placement.setScenes(ConfigurationHelper.formatScenes(jSONObject.optJSONArray("scenes")));
            jSONObject = jSONObject.optJSONArray("ins");
            sparseArray2 = placement.getInsMap();
            placement.setInsMap(ConfigurationHelper.formatInstances(string, sparseArray, n3, (JSONArray)jSONObject, sparseArray2));
            sPlacementMap.put(string, placement);
        }
        return sPlacementMap;
    }

    private static Map<String, Scene> formatScenes(JSONArray jSONArray) {
        HashMap<String, Scene> hashMap;
        HashMap<String, Scene> hashMap2 = hashMap;
        hashMap = new HashMap<String, Scene>();
        if (jSONArray != null && jSONArray.length() > 0) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                Scene scene;
                Scene scene2 = scene;
                hashMap2.put(new Scene(jSONArray.optJSONObject(i2)).getN(), scene2);
            }
        }
        return hashMap2;
    }

    private static SparseArray<BaseInstance> formatInstances(String string, SparseArray<Mediation> sparseArray, int n2, JSONArray jSONArray, SparseArray<BaseInstance> sparseArray2) {
        if (sparseArray2 == null) {
            SparseArray sparseArray3;
            sparseArray2 = sparseArray3;
            sparseArray3 = new SparseArray();
        }
        if (jSONArray != null && jSONArray.length() != 0) {
            int n3 = jSONArray.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = jSONArray.optJSONObject(i2);
                int n4 = object.optInt("id");
                int n5 = object.optInt("m");
                int n6 = object.optInt("pt", n2);
                Mediation mediation = (Mediation)sparseArray.get(n5);
                if (mediation == null) continue;
                BaseInstance baseInstance = (BaseInstance)sparseArray2.get(n4);
                if (baseInstance == null) {
                    baseInstance = ConfigurationHelper.createInstance(n6, n5);
                }
                if (n2 == 0 || n2 == 1 || n2 == 4) {
                    baseInstance.setPath(AdapterUtil.getAdapterPathWithType(n6, mediation.getId()));
                }
                JSONObject jSONObject = object;
                JSONObject jSONObject2 = object;
                JSONObject jSONObject3 = object;
                JSONObject jSONObject4 = object;
                JSONObject jSONObject5 = object;
                BaseInstance baseInstance2 = baseInstance;
                baseInstance.setAppKey(mediation.getK());
                object = object.optString("k");
                baseInstance2.setPt(n6);
                baseInstance2.setKey((String)object);
                baseInstance.setId(n4);
                baseInstance.setPlacementId(string);
                baseInstance.setMediationId(n5);
                baseInstance.setFrequencyCap(jSONObject5.optInt("fc"));
                baseInstance.setFrequencyUnit(jSONObject4.optInt("fu") * 60 * 60 * 1000);
                baseInstance.setFrequencyInterval(jSONObject3.optInt("fi") * 1000);
                baseInstance.setHb(jSONObject2.optInt("hb"));
                int n7 = jSONObject.optInt("hbt");
                if (n7 < 1000) {
                    n7 = 5000;
                }
                baseInstance.setHbt(n7);
                if (n6 == 1) {
                    baseInstance.setAdapter(AdapterUtil.geNativeAdAdapter(n5, baseInstance.getPath()));
                } else {
                    baseInstance.setAdapter(AdapterUtil.getCustomAdsAdapter(n5));
                }
                sparseArray2.put(n4, (Object)baseInstance);
            }
            return sparseArray2;
        }
        return sparseArray2;
    }

    private static BaseInstance createInstance(int n2, int n3) {
        Instance instance;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    if (n2 != 6) {
                        Instance instance2;
                        instance = instance2;
                        instance2 = new Instance();
                    } else {
                        com.zeus.gmc.sdk.mobileads.mintmediation.a.x.d.a a2;
                        instance = a2;
                        a2 = new com.zeus.gmc.sdk.mobileads.mintmediation.a.x.d.a(true);
                    }
                } else {
                    a a3;
                    instance = a3;
                    a3 = new a();
                }
            } else {
                com.zeus.gmc.sdk.mobileads.mintmediation.a.x.d.a a4;
                instance = a4;
                a4 = new com.zeus.gmc.sdk.mobileads.mintmediation.a.x.d.a();
            }
        } else {
            com.zeus.gmc.sdk.mobileads.mintmediation.a.x.c.a a5;
            instance = a5;
            a5 = new com.zeus.gmc.sdk.mobileads.mintmediation.a.x.c.a();
        }
        return instance;
    }

    private static SparseArray<Mediation> parseMediationConfigurations(JSONArray jSONArray) throws Exception {
        if (sMediationSparseArray == null) {
            sMediationSparseArray = new SparseArray();
        }
        if (jSONArray != null && jSONArray.length() != 0) {
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                Mediation mediation;
                Object object = jSONArray.getJSONObject(i2);
                Mediation mediation2 = mediation;
                JSONObject jSONObject = object;
                mediation2();
                object = jSONObject.optString("k");
                int n3 = jSONObject.optInt("id");
                String string = jSONObject.optString("n");
                long l2 = jSONObject.optLong("aet");
                mediation2.setK((String)object);
                mediation2.setId(n3);
                mediation2.setN(string);
                try {
                    mediation.setAet(l2 * 60L * 1000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                sMediationSparseArray.put(n3, (Object)mediation2);
            }
            return sMediationSparseArray;
        }
        return sMediationSparseArray;
    }

    public static void setLocalDefault(String string) {
        sLocalConfig = string;
    }

    public static boolean hasLocalDefaultConfig() {
        return sLocalConfig != null;
    }

    public static String getLocalDefaultConfig() {
        if (sLocalConfig != null) {
            try {
                sDefaultConfig = new JSONObject(sLocalConfig);
                return sDefaultConfig.optString("initData");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static boolean shouldUseCachedInitConfig() {
        return SharedPreferencesUtils.getInstance().getInt("InitType", 1) == 1 && (SharedPreferencesUtils.getInstance().contains("InitResponse") || ConfigurationHelper.hasLocalDefaultConfig());
    }

    public static void setCachedInitConfig(String string) {
        MLog.d(TAG, "update cached init config");
        SharedPreferencesUtils.getInstance().putString("InitResponse", string);
    }

    public static String getCachedInitConfig() {
        return SharedPreferencesUtils.getInstance().getString("InitResponse");
    }

    public static JSONObject getDefaultConfig() {
        if (sDefaultConfig == null && sLocalConfig != null) {
            try {
                sDefaultConfig = new JSONObject(sLocalConfig);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return sDefaultConfig;
    }

    public static int getSource() {
        return sSource;
    }

    public static void setSource(int n2) {
        sSource = n2;
    }
}

