/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.helper;

import android.util.SparseArray;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterError;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.CustomAdInitCallback;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.AdapterUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.DataCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Mediation;

public class InitAllAdNetworkHelper
implements CustomAdInitCallback {
    private int mInitIndex;
    private int mMaxParallelCount;
    private int mCurrentInitCount;
    private volatile boolean mInitStart = false;

    public static InitAllAdNetworkHelper getInstance() {
        return SingletonHolder.sInstance;
    }

    private InitAllAdNetworkHelper() {
    }

    private void initAdNetworkInterval() {
        SparseArray<Mediation> sparseArray = (SparseArray<Mediation>)DataCache.getInstance().getFromMem("Config", null);
        if (sparseArray != null && (sparseArray = sparseArray.getMs()) != null) {
            if (this.mCurrentInitCount >= this.mMaxParallelCount) {
                return;
            }
            if (this.mInitIndex >= sparseArray.size()) {
                this.mInitStart = false;
                return;
            }
            int n2 = this.mInitIndex;
            this.mInitIndex = n2 + 1;
            Mediation mediation = (Mediation)sparseArray.valueAt(n2);
            if (mediation == null) {
                this.initAdNetworkInterval();
                return;
            }
            ++this.mCurrentInitCount;
            this.initAdNetwork(mediation.getId(), this);
            return;
        }
    }

    public void startAllAdNetworkInit() {
        if (this.mInitStart) {
            return;
        }
        this.mInitIndex = 0;
        this.mMaxParallelCount = 2;
        this.mInitStart = true;
        this.initAdNetworkInterval();
    }

    public void initAdNetwork(int n2, CustomAdInitCallback customAdInitCallback) {
        AdapterUtil.initAdNetworkWithDefaultConfig(ContextProvider.INSTANCE.getContext(), n2, customAdInitCallback);
    }

    @Override
    public void onAdapterInitSucceed(int n2) {
        InitAllAdNetworkHelper initAllAdNetworkHelper = this;
        --initAllAdNetworkHelper.mCurrentInitCount;
        initAllAdNetworkHelper.initAdNetworkInterval();
    }

    @Override
    public void onAdapterInitFailed(int n2, AdapterError adapterError) {
        InitAllAdNetworkHelper initAllAdNetworkHelper = this;
        --initAllAdNetworkHelper.mCurrentInitCount;
        initAllAdNetworkHelper.initAdNetworkInterval();
    }

    private static class SingletonHolder {
        private static final InitAllAdNetworkHelper sInstance = new InitAllAdNetworkHelper();

        private SingletonHolder() {
        }
    }
}

