/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.model;

import android.os.SystemClock;
import android.text.TextUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.bid.MintBidResponse;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.AdapterError;
import com.zeus.gmc.sdk.mobileads.mintmediation.mediation.BaseAdsAdapter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.AdRateUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.AdValueUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ContextProvider;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.DensityUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.JsonUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.PlacementUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.cache.DataCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.event.EventUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Configurations;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Frequency;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.InstanceLoadStatus;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Mediation;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Placement;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.model.Scene;
import java.math.BigDecimal;
import java.util.UUID;
import org.json.JSONObject;

public class BaseInstance
extends Frequency {
    private static final String TAG = "BaseInstance";
    public static final int LOAD_TYPE_NORMAL = 0;
    public static final int LOAD_TYPE_RETRY = 1;
    public static final int LOAD_TYPE_TIMEOUT = 2;
    protected int id;
    protected int pt;
    protected int mediationId;
    protected String key;
    private String path;
    private int grpIndex;
    protected int index;
    private boolean isFirst;
    private Object object;
    private long start;
    private String appKey;
    private int hb;
    private int hbt;
    private BID_STATE bidState = BID_STATE.NOT_BIDDING;
    private int wfAbt;
    private MintBidResponse bidResponse;
    protected long mInitStart;
    protected long mLoadStart;
    protected long mShowStart;
    protected String mPlacementId;
    protected BaseAdsAdapter mAdapter;
    protected InstanceLoadStatus mLastLoadStatus;
    private String rid;
    private int precisiontype;
    private String price;
    private long readyTime;
    private int mInsLoadType;
    private boolean isAvailable;

    public static JSONObject buildReportData(BaseInstance object, String string, String string2, long l2) {
        JSONObject jSONObject;
        Object object2;
        JSONObject jSONObject2;
        block35: {
            block34: {
                block33: {
                    JSONObject jSONObject3;
                    BaseInstance baseInstance;
                    if (object == null) {
                        return null;
                    }
                    try {
                        baseInstance = object;
                    }
                    catch (Throwable throwable) {
                        MLog.d(TAG, "buildReportData exception : ", throwable);
                        return null;
                    }
                    jSONObject2 = jSONObject3;
                    BaseInstance baseInstance2 = object;
                    jSONObject2();
                    object2 = "pid";
                    JsonUtil.put(jSONObject3, (String)object2, baseInstance2.mPlacementId);
                    JsonUtil.put(jSONObject3, "iid", ((BaseInstance)object).id);
                    JsonUtil.put(jSONObject3, "mid", ((BaseInstance)object).mediationId);
                    JsonUtil.put(jSONObject3, "pt", ((BaseInstance)object).pt);
                    if (baseInstance.mAdapter == null) break block33;
                    try {
                        JsonUtil.put(jSONObject2, "adapterv", ((BaseInstance)object).mAdapter.getAdapterVersion());
                    }
                    catch (Throwable throwable) {}
                    try {
                        JsonUtil.put(jSONObject2, "msdkv", ((BaseInstance)object).mAdapter.getMediationVersion());
                    }
                    catch (Throwable throwable) {}
                }
                JsonUtil.put(jSONObject2, "priority", ((BaseInstance)object).index);
                object2 = PlacementUtils.getPlacement(((BaseInstance)object).mPlacementId);
                if (object2 == null) break block34;
                JsonUtil.put(jSONObject2, "cs", ((Placement)object2).getCs());
            }
            JSONObject jSONObject4 = jSONObject2;
            JsonUtil.put(jSONObject4, "abt", ((BaseInstance)object).wfAbt);
            JsonUtil.put(jSONObject4, "bid", ((BaseInstance)object).hb);
            if (((BaseInstance)object).bidResponse == null) break block35;
            JSONObject jSONObject5 = jSONObject2;
            JsonUtil.put(jSONObject5, "price", ((BaseInstance)object).bidResponse.getPrice());
            JsonUtil.put(jSONObject5, "cur", ((BaseInstance)object).bidResponse.getCur());
        }
        String string3 = string;
        object2 = jSONObject;
        jSONObject = new JSONObject();
        if (string3 != null) {
            JsonUtil.put((JSONObject)object2, "code", string);
        }
        if (string2 != null) {
            JsonUtil.put((JSONObject)object2, "message", string2);
        }
        if (string != null || string2 != null) {
            JsonUtil.put(jSONObject2, "msg", object2);
        }
        JSONObject jSONObject6 = jSONObject2;
        BaseInstance baseInstance = object;
        JSONObject jSONObject7 = jSONObject2;
        string = "duration";
        JsonUtil.put(jSONObject2, string, l2);
        string = "rid";
        JsonUtil.put(jSONObject7, string, ((BaseInstance)object).rid);
        JsonUtil.put(jSONObject7, "precisiontype", ((BaseInstance)object).precisiontype);
        object = "price";
        JsonUtil.put(jSONObject6, (String)object, baseInstance.price);
        return jSONObject6;
    }

    public static JSONObject buildReportData(BaseInstance baseInstance) {
        return BaseInstance.buildReportData(baseInstance, null, null, -1L);
    }

    private void setLoadStatus(long l2, AdapterError adapterError) {
        l2 /= 1000L;
        if (adapterError == null) {
            this.mLastLoadStatus = null;
        } else if (adapterError.isLoadFailFromAdn()) {
            InstanceLoadStatus instanceLoadStatus;
            InstanceLoadStatus instanceLoadStatus2 = instanceLoadStatus;
            instanceLoadStatus2();
            instanceLoadStatus2.setIid(this.id);
            instanceLoadStatus2.setLts(this.mLoadStart);
            instanceLoadStatus2.setDur(l2);
            instanceLoadStatus2.setCode(adapterError.getCode());
            instanceLoadStatus.setMsg(adapterError.getMessage());
            this.mLastLoadStatus = instanceLoadStatus;
        } else {
            this.mLastLoadStatus = null;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailable(boolean bl) {
        this.isAvailable = bl;
    }

    public boolean isAdExpiredByMint() {
        if (7 == this.mediationId) {
            return false;
        }
        Object object = DataCache.getInstance().getFromMem("Config", Configurations.class);
        if (object != null && ((Configurations)object).getMs() != null && (object = (Mediation)((Configurations)object).getMs().get(this.mediationId)) != null) {
            long l2 = ((Mediation)object).getAet();
            if (l2 > 0L && this.readyTime > 0L) {
                return SystemClock.elapsedRealtime() - this.readyTime > l2;
            }
            return false;
        }
        return false;
    }

    public void setLoadType(int n2) {
        this.mInsLoadType = n2;
    }

    public int getInsLoadType() {
        return this.mInsLoadType;
    }

    public void setInitStart(long l2) {
        this.mInitStart = l2;
    }

    public long getInitStartTime() {
        return this.mInitStart;
    }

    public void setLoadStart(long l2) {
        this.mLoadStart = l2;
    }

    public long getLoadStartTime() {
        return this.mLoadStart;
    }

    public long getReadyTime() {
        return this.readyTime;
    }

    public int getPt() {
        return this.pt;
    }

    public void setPt(int n2) {
        this.pt = n2;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public int getMediationId() {
        return this.mediationId;
    }

    public void setMediationId(int n2) {
        this.mediationId = n2;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setGrpIndex(int n2) {
        this.grpIndex = n2;
    }

    public int getGrpIndex() {
        return this.grpIndex;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public int getIndex() {
        return this.index;
    }

    public void setFirst(boolean bl) {
        this.isFirst = bl;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setStart(long l2) {
        this.start = l2;
    }

    public long getStart() {
        return this.start;
    }

    public void setAppKey(String string) {
        this.appKey = string;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setPlacementId(String string) {
        this.mPlacementId = string;
    }

    public String getPlacementId() {
        return this.mPlacementId;
    }

    public void setHb(int n2) {
        this.hb = n2;
    }

    public int getHb() {
        return this.hb;
    }

    public void setHbt(int n2) {
        this.hbt = n2;
    }

    public int getHbt() {
        return this.hbt;
    }

    public void setBidState(BID_STATE bID_STATE) {
        this.bidState = bID_STATE;
    }

    public BID_STATE getBidState() {
        return this.bidState;
    }

    public void setAdapter(BaseAdsAdapter baseAdsAdapter) {
        this.mAdapter = baseAdsAdapter;
    }

    public BaseAdsAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setWfAbt(int n2) {
        this.wfAbt = n2;
    }

    public int getWfAbt() {
        return this.wfAbt;
    }

    public void setBidResponse(MintBidResponse mintBidResponse) {
        MintBidResponse mintBidResponse2 = this.bidResponse;
        if (mintBidResponse2 != null && !mintBidResponse2.isAlreadyReport()) {
            if (mintBidResponse != null) {
                MLog.w(TAG, "" + this.getId() + " hb not report");
                MLog.d(TAG, "replace bid resp " + this.bidResponse.hashCode() + " to " + mintBidResponse.hashCode());
            }
        } else if (mintBidResponse != null) {
            MLog.d(TAG, "set bid resp " + mintBidResponse.hashCode());
        }
        this.bidResponse = mintBidResponse;
    }

    public MintBidResponse getBidResponse() {
        return this.bidResponse;
    }

    public double getBidPrice() {
        if (((BaseInstance)this).hb == 1 && (this = ((BaseInstance)this).bidResponse) != null) {
            return ((MintBidResponse)this).getPrice();
        }
        return 0.0;
    }

    public String getBidCur() {
        if (((BaseInstance)this).hb == 1 && (this = ((BaseInstance)this).bidResponse) != null) {
            return ((MintBidResponse)this).getCur();
        }
        return "USD";
    }

    public double getBidShowRevenue(int n2) {
        try {
            return new BigDecimal(this.getBidPrice()).divide(new BigDecimal(1000.0)).setScale(n2, 4).doubleValue();
        }
        catch (Exception exception) {
            MLog.e(TAG, "Instance getRevenue Error: " + exception.getMessage());
            return 0.0;
        }
    }

    public InstanceLoadStatus getLastLoadStatus() {
        return this.mLastLoadStatus;
    }

    public String getRid() {
        return this.rid;
    }

    public void generateRid() {
        BaseInstance baseInstance = string;
        String string = "" + ((BaseInstance)((Object)string)).id + ((BaseInstance)((Object)string)).mediationId + ((BaseInstance)((Object)string)).index;
        baseInstance.rid = new UUID(string.hashCode(), System.currentTimeMillis()).toString();
    }

    public int getPrecisiontype() {
        return this.precisiontype;
    }

    public void setPrecisiontype(int n2) {
        this.precisiontype = n2;
    }

    public String getPrice() {
        return this.price;
    }

    public void setPrice(String string) {
        this.price = string;
    }

    public String toString() {
        return "Ins{id=" + this.id + ", index=" + this.index + ", pid=" + this.mPlacementId + ", mId=" + this.mediationId + '}';
    }

    public int hashCode() {
        BaseInstance baseInstance = this;
        int n2 = (31 + baseInstance.mediationId) * 31;
        int n3 = TextUtils.isEmpty((CharSequence)baseInstance.key) ? 0 : this.key.hashCode();
        return n2 + n3;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        object = (BaseInstance)object;
        return TextUtils.equals((CharSequence)this.key, (CharSequence)((BaseInstance)object).key) && this.id == ((BaseInstance)object).id;
    }

    public JSONObject buildReportData() {
        return BaseInstance.buildReportData(this);
    }

    public JSONObject buildReportDataWithScene(Scene object) {
        BaseInstance baseInstance = baseInstance.buildReportData();
        String string = "scene";
        object = object != null ? ((Scene)object).getId() : 0;
        BaseInstance baseInstance2 = baseInstance;
        JsonUtil.put((JSONObject)baseInstance2, string, object);
        JsonUtil.put((JSONObject)baseInstance2, "ot", DensityUtil.getDirection(ContextProvider.INSTANCE.getContext()));
        return baseInstance2;
    }

    public void reportInsLoad() {
        if (this.hb == 1) {
            EventUtil.getInstance().onBidInsLoadReport(this.buildReportData());
        } else {
            EventUtil.getInstance().onInsLoadReport(this.buildReportData());
        }
    }

    public void reportInsDestroyed() {
        EventUtil.getInstance().onInsDestroyedReport(this.buildReportData());
    }

    public void onInsLoadSuccess() {
        this.readyTime = SystemClock.elapsedRealtime();
        long l2 = this.mLoadStart > 0L ? SystemClock.elapsedRealtime() - this.mLoadStart : -1L;
        BaseInstance baseInstance = this;
        JSONObject jSONObject = BaseInstance.buildReportData(baseInstance, null, null, l2);
        if (baseInstance.getHb() == 1) {
            EventUtil.getInstance().onBidInsLoadSuccessReport(jSONObject);
        } else {
            EventUtil.getInstance().onInsLoadSuccessReport(jSONObject);
        }
        this.mLastLoadStatus = null;
    }

    public void onInsLoadTimeout(AdapterError adapterError) {
        long l2 = this.mLoadStart > 0L ? SystemClock.elapsedRealtime() - this.mLoadStart : -1L;
        String string = adapterError == null ? "timeout" : adapterError.getMessage();
        String string2 = adapterError == null ? null : adapterError.getCode();
        BaseInstance baseInstance = this;
        string = BaseInstance.buildReportData(baseInstance, string2, string, l2);
        if (baseInstance.getHb() == 1) {
            EventUtil.getInstance().onBidInsLoadTimeoutReport((JSONObject)string);
        } else {
            EventUtil.getInstance().onInsLoadTimeoutReport((JSONObject)string);
        }
        this.setLoadStatus(l2, adapterError);
    }

    public void onInsLoadFailed(AdapterError adapterError) {
        long l2 = this.mLoadStart > 0L ? SystemClock.elapsedRealtime() - this.mLoadStart : -1L;
        String string = adapterError == null ? "unknown" : adapterError.getMessage();
        String string2 = adapterError == null ? null : adapterError.getCode();
        BaseInstance baseInstance = this;
        string = BaseInstance.buildReportData(baseInstance, string2, string, l2);
        if (baseInstance.getHb() == 1) {
            EventUtil.getInstance().onBidInsLoadErrorReport((JSONObject)string);
        } else {
            EventUtil.getInstance().onInsLoadErrorReport((JSONObject)string);
        }
        this.setLoadStatus(l2, adapterError);
    }

    public void onInsReLoadFailed(AdapterError adapterError) {
        long l2 = this.mLoadStart > 0L ? SystemClock.elapsedRealtime() - this.mLoadStart : -1L;
        String string = adapterError == null ? "unknown" : adapterError.getMessage();
        String string2 = adapterError == null ? null : adapterError.getCode();
        BaseInstance baseInstance = this;
        string = BaseInstance.buildReportData(baseInstance, string2, string, l2);
        if (baseInstance.getHb() == 1) {
            EventUtil.getInstance().onBidInsReLoadErrorReport((JSONObject)string);
        } else {
            EventUtil.getInstance().onInsReLoadErrorReport((JSONObject)string);
        }
        this.setLoadStatus(l2, adapterError);
    }

    public void onInsShow(Scene scene) {
        BaseInstance baseInstance = this;
        baseInstance.mShowStart = SystemClock.elapsedRealtime();
        AdRateUtil.onInstancesShowed(baseInstance.mPlacementId, this.key);
        AdValueUtil.onInstancesShowed(baseInstance.mPlacementId, this.price);
        if (scene != null) {
            AdRateUtil.onSceneShowed(this.mPlacementId, scene);
        }
        EventUtil.getInstance().onInsShowReport(this.buildReportDataWithScene(scene));
    }

    public void onInsClosed(Scene scene) {
        BaseInstance baseInstance = this;
        scene = baseInstance.buildReportDataWithScene(scene);
        if (baseInstance.mShowStart > 0L) {
            JsonUtil.put((JSONObject)scene, "duration", SystemClock.elapsedRealtime() - this.mShowStart);
            this.mShowStart = 0L;
        }
        EventUtil.getInstance().onInsCloseReport((JSONObject)scene);
        if (this.bidResponse != null) {
            this.setBidResponse(null);
        }
    }

    public void onInsClick(Scene scene) {
        EventUtil.getInstance().onInsClickedReport(this.buildReportDataWithScene(scene));
    }

    public void onInsShowSuccess(Scene scene) {
        EventUtil.getInstance().onInsShowSuccessReport(this.buildReportDataWithScene(scene));
    }

    public void onInsShowFailed(AdapterError adapterError, Scene scene) {
        scene = this.buildReportDataWithScene(scene);
        if (adapterError != null) {
            JsonUtil.put((JSONObject)scene, "code", adapterError.getCode());
            JsonUtil.put((JSONObject)scene, "msg", adapterError.getMessage());
        }
        if (this.mShowStart > 0L) {
            JsonUtil.put((JSONObject)scene, "duration", SystemClock.elapsedRealtime() - this.mShowStart);
            this.mShowStart = 0L;
        }
        EventUtil.getInstance().onInsShowFailedReport((JSONObject)scene);
    }

    public static final class BID_STATE
    extends Enum<BID_STATE> {
        public static final /* enum */ BID_STATE NOT_INITIATED;
        public static final /* enum */ BID_STATE INIT_FAILED;
        public static final /* enum */ BID_STATE INITIATED;
        public static final /* enum */ BID_STATE BID_SUCCESS;
        public static final /* enum */ BID_STATE INIT_PENDING;
        public static final /* enum */ BID_STATE BID_PENDING;
        public static final /* enum */ BID_STATE BID_FAILED;
        public static final /* enum */ BID_STATE NOT_BIDDING;
        private static final /* synthetic */ BID_STATE[] $VALUES;
        private final int mValue;

        public static BID_STATE[] values() {
            return (BID_STATE[])$VALUES.clone();
        }

        public static BID_STATE valueOf(String string) {
            return Enum.valueOf(BID_STATE.class, string);
        }

        private BID_STATE(int n3) {
            this.mValue = n3;
        }

        static {
            BID_STATE bID_STATE;
            NOT_INITIATED = new BID_STATE(0);
            INIT_FAILED = new BID_STATE(1);
            INITIATED = new BID_STATE(2);
            BID_SUCCESS = new BID_STATE(3);
            INIT_PENDING = new BID_STATE(4);
            BID_PENDING = new BID_STATE(5);
            BID_FAILED = new BID_STATE(6);
            BID_STATE bID_STATE2 = bID_STATE;
            NOT_BIDDING = new BID_STATE(7);
            $VALUES = new BID_STATE[]{NOT_INITIATED, INIT_FAILED, INITIATED, BID_SUCCESS, INIT_PENDING, BID_PENDING, BID_FAILED, bID_STATE2};
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

