/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network;

import android.text.TextUtils;
import java.net.HttpCookie;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Headers {
    public static final String TIME_FORMAT_HTTP = "EEE, dd MMM y HH:mm:ss 'GMT'";
    public static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");
    public static final String KEY_ACCEPT = "Accept";
    public static final String VALUE_ACCEPT_ALL = "*/*";
    public static final String KEY_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String VALUE_ACCEPT_ENCODING = "gzip, deflate";
    public static final String KEY_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String KEY_ACCEPT_RANGE = "Accept-Range";
    public static final String KEY_COOKIE = "Cookie";
    public static final String KEY_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String KEY_CONTENT_ENCODING = "Content-Encoding";
    public static final String KEY_CONTENT_LENGTH = "Content-Length";
    public static final String KEY_CONTENT_RANGE = "Content-Range";
    public static final String KEY_CONTENT_TYPE = "Content-Type";
    public static final String VALUE_APPLICATION_URLENCODED = "application/x-www-form-urlencoded";
    public static final String VALUE_APPLICATION_FORM = "multipart/form-data";
    public static final String VALUE_APPLICATION_STREAM = "application/octet-stream";
    public static final String VALUE_APPLICATION_JSON = "application/json";
    public static final String VALUE_APPLICATION_XML = "application/xml";
    public static final String KEY_CACHE_CONTROL = "Cache-Control";
    public static final String KEY_CONNECTION = "Connection";
    public static final String VALUE_KEEP_ALIVE = "keep-alive";
    public static final String VALUE_CLOSE = "close";
    public static final String KEY_DATE = "Date";
    public static final String KEY_EXPIRES = "Expires";
    public static final String KEY_E_TAG = "ETag";
    public static final String KEY_HOST = "Host";
    public static final String KEY_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String KEY_IF_NONE_MATCH = "If-None-Match";
    public static final String KEY_LAST_MODIFIED = "Last-Modified";
    public static final String KEY_LOCATION = "Location";
    public static final String KEY_RANGE = "Range";
    public static final String KEY_SET_COOKIE = "Set-Cookie";
    public static final String KEY_USER_AGENT = "User-Agent";
    private final Map<String, List<String>> mSource;

    public Headers() {
        TreeMap treeMap;
        TreeMap treeMap2 = treeMap;
        treeMap = new TreeMap();
        v1.mSource = treeMap2;
    }

    public static Headers of(Map<String, List<String>> object) {
        Headers headers;
        Headers headers2 = headers;
        headers = new Headers();
        if (object != null && !object.isEmpty()) {
            for (Map.Entry entry : object.entrySet()) {
                List list = (List)entry.getValue();
                if (list != null && !list.isEmpty()) {
                    headers2.add((String)entry.getKey(), list);
                    continue;
                }
                headers2.set((String)entry.getKey(), "");
            }
            return headers2;
        }
        return headers2;
    }

    private long getDateField(String string) {
        if (!TextUtils.isEmpty((CharSequence)(this = ((Headers)this).getFirst(string)))) {
            try {
                return Headers.formatGMTToMillis((String)this);
            }
            catch (ParseException parseException) {}
        }
        return 0L;
    }

    public static String formatKey(String stringArray) {
        StringBuilder stringBuilder;
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            return null;
        }
        stringArray = stringArray.toLowerCase(Locale.ENGLISH).split("-");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            String string2 = string;
            string2 = string2.substring(1);
            stringBuilder2.append(string.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(string2).append("-");
        }
        if (stringBuilder2.length() > 0) {
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.deleteCharAt(stringBuilder3.lastIndexOf("-"));
        }
        return stringBuilder2.toString();
    }

    public static Headers fromJSONString(String object) throws JSONException {
        JSONObject jSONObject;
        Headers headers;
        Headers headers2 = headers;
        headers = new Headers();
        JSONObject jSONObject2 = jSONObject;
        object = new JSONObject((String)object).keys();
        while (object.hasNext()) {
            JSONArray jSONArray;
            String string = (String)object.next();
            String string2 = jSONObject2.optString(string);
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray(string2);
            for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                headers2.add(string, jSONArray2.optString(i2));
            }
        }
        return headers2;
    }

    public static String toJSONString(Headers headers) {
        JSONObject jSONObject;
        Headers headers2 = headers;
        headers = jSONObject;
        jSONObject = new JSONObject();
        for (Map.Entry<String, List<String>> entry : headers2.entrySet()) {
            Object object = entry;
            object = object.getValue();
            try {
                headers.put(entry.getKey(), new JSONArray((Collection)object));
            }
            catch (JSONException jSONException) {
            }
        }
        return headers.toString();
    }

    public static Map<String, String> getRequestHeaders(Headers object) {
        LinkedHashMap linkedHashMap;
        Headers headers = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            object.put(entry.getKey(), TextUtils.join((CharSequence)"; ", entry.getValue()));
        }
        return object;
    }

    public static List<HttpCookie> getHttpCookieList(Headers headers) {
        ArrayList<HttpCookie> arrayList;
        ArrayList<HttpCookie> arrayList2 = arrayList;
        arrayList = new ArrayList<HttpCookie>();
        for (String string : headers.keySet()) {
            if (!string.equalsIgnoreCase(KEY_SET_COOKIE)) continue;
            Iterator<String> iterator = headers.get(string).iterator();
            while (iterator.hasNext()) {
                arrayList2.addAll(HttpCookie.parse(iterator.next()));
            }
        }
        return arrayList2;
    }

    public static String parseSubValue(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            StringTokenizer stringTokenizer;
            StringTokenizer stringTokenizer2 = stringTokenizer;
            stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer2.hasMoreElements()) {
                string = stringTokenizer2.nextToken();
                int n2 = string.indexOf(61);
                if (n2 <= 0 || !string2.equalsIgnoreCase(string.substring(0, n2).trim())) continue;
                string3 = string.substring(n2 + 1).trim();
                break;
            }
        }
        return string3;
    }

    public static long formatGMTToMillis(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT_HTTP, Locale.US);
        simpleDateFormat.setTimeZone(TIME_ZONE_GMT);
        return simpleDateFormat.parse(string).getTime();
    }

    public static String formatMillisToGMT(long l2) {
        Date date;
        Date date2 = date;
        date = new Date(l2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT_HTTP, Locale.US);
        simpleDateFormat.setTimeZone(TIME_ZONE_GMT);
        return simpleDateFormat.format(date2);
    }

    public static long analysisCacheExpires(Headers headers) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        long l4 = 0L;
        String string = headers.getCacheControl();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            StringTokenizer stringTokenizer;
            StringTokenizer stringTokenizer2 = stringTokenizer;
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken().trim().toLowerCase(Locale.getDefault());
                if (!string2.equals("no-cache") && !string2.equals("no-store")) {
                    if (string2.startsWith("max-age=")) {
                        l3 = Long.parseLong(string2.substring(8)) * 1000L;
                        continue;
                    }
                    if (string2.startsWith("must-revalidate")) {
                        return 0L;
                    }
                    if (!string2.startsWith("stale-while-revalidate=")) continue;
                    l4 = Long.parseLong(string2.substring(23)) * 1000L;
                    continue;
                }
                return 0L;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            l2 += l3;
            if (l4 > 0L) {
                l2 += l4;
            }
            return l2;
        }
        l3 = headers.getExpires();
        if (l3 > (l4 = headers.getDate())) {
            return l2 + l3 - l4;
        }
        return 0L;
    }

    public Set<String> names() {
        return this.mSource.keySet();
    }

    public List<String> values(String string) {
        return this.mSource.get(string);
    }

    public void add(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            if (!this.mSource.containsKey(string)) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList(1);
                this.mSource.put(string, arrayList2);
            }
            this.mSource.get(string).add(string2);
        }
    }

    public void set(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            this.mSource.remove(string);
            this.add(string, string2);
        }
    }

    public void add(String string, List<String> object) {
        if (!TextUtils.isEmpty((CharSequence)string) && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                this.add(string, (String)object.next());
            }
        }
    }

    public void set(String string, List<String> list) {
        if (!TextUtils.isEmpty((CharSequence)string) && !list.isEmpty()) {
            this.mSource.put(string, list);
        }
    }

    public void add(Headers object) {
        for (Map.Entry<String, List<String>> entry : ((Headers)((Object)object)).mSource.entrySet()) {
            String string = entry.getKey();
            Iterator<String> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                this.add(string, iterator.next());
            }
        }
    }

    public List<String> remove(String string) {
        return this.mSource.remove(string);
    }

    public List<String> get(String string) {
        return this.mSource.get(string);
    }

    public String getFirst(String string) {
        List<String> list = ((Headers)((Object)list)).mSource.get(string);
        if (list != null && list.size() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    public boolean containsKey(String string) {
        return this.mSource.containsKey(string);
    }

    public void set(Headers object) {
        for (Map.Entry<String, List<String>> entry : this.mSource.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.mSource.entrySet();
    }

    public Set<String> keySet() {
        return this.mSource.keySet();
    }

    public int size() {
        return this.mSource.size();
    }

    public boolean isEmpty() {
        return this.mSource.isEmpty();
    }

    public void clear() {
        this.mSource.clear();
    }

    public Map<String, List<String>> toMap() {
        return this.mSource;
    }

    public String getCacheControl() {
        if ((list = ((Headers)((Object)list)).get(KEY_CACHE_CONTROL)) == null) {
            List list = Collections.emptyList();
        }
        return TextUtils.join((CharSequence)",", list);
    }

    public String getContentDisposition() {
        return this.getFirst(KEY_CONTENT_DISPOSITION);
    }

    public String getContentEncoding() {
        return this.getFirst(KEY_CONTENT_ENCODING);
    }

    public long getContentLength() {
        if (TextUtils.isEmpty((CharSequence)(object = ((Headers)object).getFirst(KEY_CONTENT_LENGTH)))) {
            Object object = "0";
        }
        return Long.parseLong((String)object);
    }

    public String getContentType() {
        return this.getFirst(KEY_CONTENT_TYPE);
    }

    public String getContentRange() {
        return this.getFirst(KEY_CONTENT_RANGE);
    }

    public long getDate() {
        return this.getDateField(KEY_DATE);
    }

    public String getETag() {
        return this.getFirst(KEY_E_TAG);
    }

    public long getExpires() {
        return this.getDateField(KEY_EXPIRES);
    }

    public long getLastModified() {
        return this.getDateField(KEY_LAST_MODIFIED);
    }

    public String getLocation() {
        return this.getFirst(KEY_LOCATION);
    }
}

