/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network;

import android.os.Build;
import com.mi.encrypt.okhttp.EncryptInterceptorV2;
import com.zeus.gmc.sdk.mobileads.columbus.remote.module.network.TLSSocketFactory;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.Gzip;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.IOUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.error.ErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.BaseTask;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.ByteRequestBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Headers;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.HttpRequestController;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Request;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.RequestBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Response;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.ResponseBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.RetryController;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.StreamBody;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class OkAsyncReq
extends BaseTask {
    public static final String TAG = "HTTP";
    public static final String HEADER_CONTENT_ENCODING_CUSTOM = "Custom-Content-Encoding";
    private static final Interceptor sEncryptInterceptor = new EncryptInterceptorV2.Builder().setDefaultEncrypt(true).build();
    private static final Interceptor sRemoveGzipHeaderInterceptor = new RemoveGzipHeaderInterceptor();
    private final BaseTask.OnTaskCallback mCallback;
    private final OkRetryController mController;

    OkAsyncReq(Request request, BaseTask.OnTaskCallback onTaskCallback) {
        super(request);
        ((OkAsyncReq)((Object)okRetryController2)).mCallback = onTaskCallback;
        if (request != null && request.getRetryConnectionTimes() != null) {
            OkRetryController okRetryController;
            OkAsyncReq okAsyncReq = okRetryController2;
            OkRetryController okRetryController2 = okRetryController;
            okRetryController = new OkRetryController();
            okAsyncReq.mController = okRetryController2;
        } else {
            ((OkAsyncReq)((Object)okRetryController2)).mController = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSyncRetryRequest(OkHttpClient var1_1, okhttp3.Request var2_2, int[] var3_3) {
        block8: {
            block9: {
                if (var1_1 == null) return;
                if (var2_2 == null) {
                    return;
                }
                var1_1 = var1_1.newCall(var2_2);
                var2_2 = null;
                v0 = var1_1.execute();
                {
                    catch (Throwable v1) {
                        break block8;
                    }
                    catch (IOException var4_4) {}
                    {
                        v2 = this;
                    }
                    var5_5 = v3;
                    {
                        v3 = new RetryClientCallback(var3_3, (Call)var1_1, this.mCallback);
                        if (v2.mController == null) ** GOTO lbl-1000
                        OkRetryController.access$102(this.mController, new WeakReference<RetryClientCallback>(var5_5));
                    }
lbl-1000:
                    // 2 sources

                    {
                        v4 = var2_2;
                        var5_5.onFailure((Call)var1_1, var4_4);
                        break block9;
                    }
                }
                var2_2 = v0;
                v4 = var2_2;
                {
                    OkAsyncReq.parseResponseAndCallback(v0, this.mCallback);
                }
            }
            IOUtil.closeQuietly((Closeable)v4);
            return;
        }
        IOUtil.closeQuietly((Closeable)var2_2);
        throw v1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSyncRequest(OkHttpClient okHttpClient, okhttp3.Request request) {
        Throwable throwable2;
        block6: {
            if (okHttpClient == null) return;
            if (request == null) {
                return;
            }
            OkHttpClient okHttpClient2 = okHttpClient;
            okHttpClient = null;
            okHttpClient = okHttpClient2.newCall(request).execute();
            {
                block7: {
                    catch (Throwable throwable2) {
                        break block6;
                    }
                    catch (IOException iOException) {}
                    {
                        String string = iOException.getMessage() == null ? "unknown error" : iOException.getMessage();
                        MLog.e(TAG, "request failed " + string);
                        if (this.mCallback == null) break block7;
                        this.mCallback.onError(ErrorBuilder.build(511, iOException.getMessage()));
                    }
                }
                IOUtil.closeQuietly((Closeable)okHttpClient);
                return;
            }
            {
                OkAsyncReq.parseResponseAndCallback((okhttp3.Response)okHttpClient, this.mCallback);
            }
            IOUtil.closeQuietly((Closeable)okHttpClient);
            return;
        }
        IOUtil.closeQuietly((Closeable)okHttpClient);
        throw throwable2;
    }

    private static void parseResponseAndCallback(okhttp3.Response response, BaseTask.OnTaskCallback onTaskCallback) throws IOException {
        if (onTaskCallback == null) {
            return;
        }
        okhttp3.Response response2 = response;
        Object object = response2.headers();
        String string = object.get("Content-Type");
        BufferedInputStream bufferedInputStream = null;
        Object object2 = response2.body();
        if (object2 != null) {
            StreamBody streamBody;
            ByteArrayInputStream byteArrayInputStream;
            BufferedInputStream bufferedInputStream2;
            okhttp3.Headers headers = object;
            object = object2.bytes();
            if ("gzip".equalsIgnoreCase(headers.get(HEADER_CONTENT_ENCODING_CUSTOM))) {
                object = Gzip.unGZip((byte[])object);
            }
            bufferedInputStream = bufferedInputStream2;
            object2 = byteArrayInputStream;
            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            bufferedInputStream2 = new BufferedInputStream((InputStream)object2);
            object = streamBody;
            streamBody = new StreamBody(string, bufferedInputStream);
        } else {
            object = bufferedInputStream;
        }
        onTaskCallback.onSuccess(Response.newBuilder().code(response.code()).headers(OkAsyncReq.convertHeader(response.headers())).body((ResponseBody)object).build());
    }

    private OkHttpClient createClientWithRequest() {
        OkHttpClient.Builder builder;
        block12: {
            block11: {
                OkHttpClient.Builder builder2;
                OkAsyncReq okAsyncReq;
                try {
                    okAsyncReq = this;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    noClassDefFoundError.printStackTrace();
                    return null;
                }
                builder = builder2;
                builder2 = new OkHttpClient.Builder();
                if (okAsyncReq.mRequest.getConnectTimeout() <= 0) break block11;
                OkHttpClient.Builder builder3 = builder;
                long l2 = this.mRequest.getConnectTimeout();
                builder3.connectTimeout(l2, TimeUnit.MILLISECONDS);
            }
            if (this.mRequest.getReadTimeout() <= 0) break block12;
            OkHttpClient.Builder builder4 = builder;
            long l3 = this.mRequest.getReadTimeout();
            builder4.readTimeout(l3, TimeUnit.MILLISECONDS);
        }
        OkHttpClient.Builder builder5 = builder;
        OkHttpClient.Builder builder6 = builder5;
        OkHttpClient.Builder builder7 = builder5;
        OkAsyncReq.enableTls(builder5);
        builder5.addNetworkInterceptor(sEncryptInterceptor);
        builder6.addNetworkInterceptor(sRemoveGzipHeaderInterceptor);
        return builder7.build();
    }

    private static Headers convertHeader(okhttp3.Headers object) {
        Headers headers;
        Headers headers2 = headers;
        headers = new Headers();
        if (object != null) {
            for (Map.Entry entry : object.toMultimap().entrySet()) {
                String string = (String)entry.getKey();
                List object2 = (List)entry.getValue();
                if (string == null) continue;
                headers2.add(string, object2);
            }
        }
        return headers2;
    }

    private okhttp3.Headers convertHeader(Headers object) {
        Headers.Builder builder;
        if (object == null) {
            return okhttp3.Headers.of((String[])new String[0]);
        }
        OkAsyncReq okAsyncReq = builder;
        builder = new Headers.Builder();
        for (Map.Entry<String, List<String>> entry : ((Headers)((Object)object)).entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            if (string == null || list == null) continue;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                okAsyncReq.add(string, iterator.next());
            }
        }
        return okAsyncReq.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void enableTls(OkHttpClient.Builder builder) {
        if (Build.VERSION.SDK_INT >= 22) return;
        TLSSocketFactory tLSSocketFactory = TLSSocketFactory.create();
        if (tLSSocketFactory == null) {
            return;
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray == null) return;
        int n2 = trustManagerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TrustManager trustManager = trustManagerArray[i2];
            if (!(trustManager instanceof X509TrustManager)) continue;
            try {
                builder.sslSocketFactory((SSLSocketFactory)tLSSocketFactory, (X509TrustManager)trustManager);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            catch (KeyStoreException keyStoreException) {
                MLog.e(TAG, "Failed to enable TLS 1.2", keyStoreException);
                return;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                MLog.e(TAG, "Failed to enable TLS 1.2", noSuchAlgorithmException);
                return;
            }
            continue;
        }
    }

    @Override
    public void run() {
        Object object;
        Object object2 = ((BaseTask)((Object)onTaskCallback)).mRequest;
        if (object2 == null) {
            BaseTask.OnTaskCallback onTaskCallback = ((OkAsyncReq)((Object)onTaskCallback)).mCallback;
            if (onTaskCallback != null) {
                onTaskCallback.onError(ErrorBuilder.build(530));
            }
            return;
        }
        object2 = ((Request)object2).getRequestBody();
        if (((BaseTask)((Object)onTaskCallback)).mRequest.isGzipBody() && object2 != null) {
            ByteRequestBody byteRequestBody;
            ByteArrayOutputStream byteArrayOutputStream;
            Object object3 = object2;
            object2 = byteArrayOutputStream;
            try {
                object3.writeTo(new ByteArrayOutputStream());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            object2 = Gzip.inGZip(((ByteArrayOutputStream)object2).toByteArray());
            object = byteRequestBody;
            byteRequestBody = new ByteRequestBody((byte[])object2);
            object2 = ((BaseTask)((Object)onTaskCallback)).mRequest.requestNewBuilder().body((RequestBody)object).build();
            ((BaseTask)((Object)onTaskCallback)).mRequest = object2;
            ((Request)object2).getHeaders().set("Accept-Encoding", "gzip");
        }
        object2 = ((BaseTask)((Object)onTaskCallback)).mRequest.getRequestBody();
        object = null;
        if (object2 instanceof ByteRequestBody) {
            Object object4 = object2;
            object2 = (ByteRequestBody)object4;
            object = okhttp3.RequestBody.create((MediaType)MediaType.parse((String)object4.contentType()), (byte[])((ByteRequestBody)object2).getBytes());
        }
        Object object5 = onTaskCallback;
        object2 = new Request.Builder().method(((BaseTask)((Object)onTaskCallback)).mRequest.getRequestMethod().toString(), object).headers(super.convertHeader(((BaseTask)object5).mRequest.getHeaders())).url(((BaseTask)((Object)onTaskCallback)).mRequest.getUrl());
        object = super.createClientWithRequest();
        if (object == null) {
            return;
        }
        int[] nArray = ((BaseTask)((Object)onTaskCallback)).mRequest.getRetryConnectionTimes();
        if (nArray != null) {
            super.processSyncRetryRequest((OkHttpClient)object, object2.build(), nArray);
        } else {
            super.processSyncRequest((OkHttpClient)object, object2.build());
        }
    }

    @Override
    HttpRequestController getRequestController() {
        return this.mController;
    }

    private static class RetryTask
    implements Runnable {
        private volatile boolean isCancelled = false;
        private final Call mCall;
        private final BaseTask.OnTaskCallback mCallback;
        private final Callback mOkHttpCallback;
        private final int mTimes;

        protected RetryTask(Call call, int n2, BaseTask.OnTaskCallback onTaskCallback, Callback callback) {
            this.mCall = call;
            this.mCallback = onTaskCallback;
            this.mOkHttpCallback = callback;
            this.mTimes = n2;
        }

        static /* synthetic */ boolean access$502(RetryTask retryTask, boolean bl) {
            retryTask.isCancelled = bl;
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (this.isCancelled) {
                return;
            }
            MLog.v("HTTP", "retry start, times " + this.mTimes);
            try {
                var1_1 = this.mCall.clone();
                var2_4 = null;
            }
            catch (Exception var1_3) {
                var1_3.printStackTrace();
                this = this.mCallback;
                if (this == null) return;
                this.onError(ErrorBuilder.build(511, var1_3.getMessage()));
                return;
            }
            v0 = var1_1.execute();
            {
                catch (Throwable var1_2) {
                    ** GOTO lbl-1000
                }
                catch (IOException var3_5) {}
                {
                    v1 = var2_4;
                    this.mOkHttpCallback.onFailure(var1_1, var3_5);
                    ** GOTO lbl-1000
                }
            }
            v1 = var2_4 = v0;
            {
                this.mOkHttpCallback.onResponse(var1_1, var2_4);
            }
lbl-1000:
            // 2 sources

            {
                IOUtil.closeQuietly((Closeable)v1);
                return;
            }
lbl-1000:
            // 1 sources

            {
                IOUtil.closeQuietly((Closeable)var2_4);
                throw var1_2;
            }
        }
    }

    private static class RemoveGzipHeaderInterceptor
    implements Interceptor {
        private RemoveGzipHeaderInterceptor() {
        }

        public okhttp3.Response intercept(Interceptor.Chain chain) throws IOException {
            Interceptor.Chain chain2 = chain;
            RemoveGzipHeaderInterceptor removeGzipHeaderInterceptor = chain2.proceed(chain2.request());
            if (removeGzipHeaderInterceptor.body() != null) {
                if ("gzip".equalsIgnoreCase(removeGzipHeaderInterceptor.header("Content-Encoding"))) {
                    removeGzipHeaderInterceptor = removeGzipHeaderInterceptor.newBuilder().removeHeader("Content-Encoding").addHeader("Content-Encoding", "identity").addHeader(OkAsyncReq.HEADER_CONTENT_ENCODING_CUSTOM, "gzip").build();
                } else {
                    return removeGzipHeaderInterceptor;
                }
            }
            return removeGzipHeaderInterceptor;
        }
    }

    static class RetryClientCallback
    implements Callback,
    RetryController {
        private final BaseTask.OnTaskCallback mCallback;
        private int mRetryCount = 0;
        private final int[] mRetryDelay;
        private final Call mCall;
        private final AtomicBoolean mAlreadyCallback;
        private volatile boolean mWaitRetry;
        private RetryTask mCurrentRetryTask;

        RetryClientCallback(int[] nArray, Call call, BaseTask.OnTaskCallback onTaskCallback) {
            AtomicBoolean atomicBoolean;
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean(false);
            v1.mAlreadyCallback = atomicBoolean2;
            v1.mWaitRetry = false;
            v1.mCallback = onTaskCallback;
            v1.mCall = call;
            v1.mRetryDelay = nArray;
        }

        static /* synthetic */ boolean access$202(RetryClientCallback retryClientCallback, boolean bl) {
            retryClientCallback.mWaitRetry = bl;
            return bl;
        }

        boolean shouldRetryWithException(int n2, IOException iOException) {
            BaseTask.OnTaskCallback onTaskCallback = ((RetryClientCallback)((Object)onTaskCallback)).mCallback;
            if (onTaskCallback instanceof BaseTask.RetryTaskCallback) {
                return ((BaseTask.RetryTaskCallback)onTaskCallback).shouldRetry(n2, iOException);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onFailure(Call object, IOException iOException) {
            void var2_4;
            block5: {
                int n2;
                Object object2 = var2_4 != null && var2_4.getMessage() != null ? var2_4.getMessage() : "unknown error";
                MLog.e(OkAsyncReq.TAG, "request failed " + (String)object2);
                object2 = ((RetryClientCallback)((Object)onTaskCallback)).mRetryDelay;
                if (((RetryClientCallback)((Object)onTaskCallback)).mRetryDelay != null && (n2 = ((RetryClientCallback)((Object)onTaskCallback)).mRetryCount) < ((Object)object2).length && ((RetryClientCallback)((Object)onTaskCallback)).shouldRetryWithException(n2, (IOException)var2_4)) {
                    1 v5;
                    BaseTask.OnTaskCallback onTaskCallback = onTaskCallback;
                    long l2 = 0L;
                    // MONITORENTER : onTaskCallback
                    if (((RetryClientCallback)((Object)onTaskCallback)).mRetryCount < ((RetryClientCallback)((Object)onTaskCallback)).mRetryDelay.length) {
                        BaseTask.OnTaskCallback onTaskCallback2 = onTaskCallback;
                        l2 = ((RetryClientCallback)((Object)onTaskCallback2)).mRetryDelay[((RetryClientCallback)((Object)onTaskCallback)).mRetryCount];
                        ++((RetryClientCallback)((Object)onTaskCallback2)).mRetryCount;
                    }
                    // MONITOREXIT : onTaskCallback
                    if (l2 <= 0L || object == null) break block5;
                    Object object3 = onTaskCallback;
                    MLog.v(OkAsyncReq.TAG, "failure retry, times " + ((RetryClientCallback)((Object)onTaskCallback)).mRetryCount);
                    Object object4 = onTaskCallback;
                    Call call = ((RetryClientCallback)object4).mCall;
                    int n3 = ((RetryClientCallback)object4).mRetryCount;
                    BaseTask.OnTaskCallback onTaskCallback3 = ((RetryClientCallback)object4).mCallback;
                    ((RetryClientCallback)object3).mCurrentRetryTask = new RetryTask(call, n3, onTaskCallback3, (Callback)onTaskCallback);
                    ((RetryClientCallback)object3).mWaitRetry = true;
                    1 var1_3 = v5;
                    var1_3((RetryClientCallback)((Object)onTaskCallback));
                    MintPoolExecuter.scheduleHttp(v5, l2, TimeUnit.SECONDS);
                    return;
                }
            }
            if (!((RetryClientCallback)((Object)onTaskCallback)).mAlreadyCallback.compareAndSet(false, true)) return;
            BaseTask.OnTaskCallback onTaskCallback = ((RetryClientCallback)((Object)onTaskCallback)).mCallback;
            if (onTaskCallback == null) return;
            onTaskCallback.onError(ErrorBuilder.build(511, var2_4.getMessage()));
        }

        public void onResponse(Call call, okhttp3.Response response) throws IOException {
            if (!this.mAlreadyCallback.compareAndSet(false, true)) {
                return;
            }
            OkAsyncReq.parseResponseAndCallback(response, this.mCallback);
        }

        @Override
        public void retryNow() {
            if (this.mWaitRetry) {
                RetryTask retryTask;
                this.mWaitRetry = false;
                RetryTask retryTask2 = this.mCurrentRetryTask;
                if (retryTask2 != null) {
                    RetryTask.access$502(retryTask2, true);
                    this.mCurrentRetryTask = null;
                }
                MLog.v(OkAsyncReq.TAG, "load retry, times " + this.mRetryCount);
                retryTask2 = retryTask;
                RetryClientCallback retryClientCallback = this;
                Call call = retryClientCallback.mCall;
                int n2 = retryClientCallback.mRetryCount;
                BaseTask.OnTaskCallback onTaskCallback = retryClientCallback.mCallback;
                retryTask = new RetryTask(call, n2, onTaskCallback, this);
                MintPoolExecuter.execute(ExecutorEnum.WorkExecutor, retryTask2);
                ++this.mRetryCount;
            }
        }
    }

    static class OkRetryController
    implements RetryController {
        private WeakReference<RetryClientCallback> mRequestCallback;

        OkRetryController() {
        }

        static /* synthetic */ WeakReference access$102(OkRetryController okRetryController, WeakReference weakReference) {
            okRetryController.mRequestCallback = weakReference;
            return weakReference;
        }

        @Override
        public void retryNow() {
            WeakReference<RetryClientCallback> weakReference = ((OkRetryController)((Object)weakReference)).mRequestCallback;
            if (weakReference == null) {
                return;
            }
            if ((weakReference = (RetryClientCallback)weakReference.get()) != null) {
                ((RetryClientCallback)((Object)weakReference)).retryNow();
            }
        }
    }
}

