/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.IOUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.error.Error;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.error.ErrorBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.AsyncReq;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.BaseTask;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Headers;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.HttpRequestController;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.OkAsyncReq;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.RequestBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Response;

public class Request {
    private final Method mMethod;
    private final Headers mHeaders;
    private final int mConnectTimeout;
    private final int mReadTimeout;
    private final String mUrl;
    private final boolean isInstanceFollowRedirects;
    private final boolean isCheckChain;
    private final OnRequestCallback mCallback;
    private final Object mTag;
    private boolean mShouldCallbackResponse;
    private final boolean isEncryptBody;
    private final boolean isGzipBody;
    private Context mContext;
    private final int[] mRetryConnectionDelays;
    private final RequestBody mRequestBody;

    static RequestBuilder newBuilder() {
        return new RequestBuilder();
    }

    private Request(RequestBuilder requestBuilder) {
        this.mMethod = requestBuilder.mMethod;
        this.mHeaders = requestBuilder.mHeaders;
        this.mConnectTimeout = requestBuilder.mConnectTimeout;
        this.mReadTimeout = requestBuilder.mReadTimeout;
        this.mUrl = requestBuilder.mUrl;
        this.mRequestBody = requestBuilder.mRequestBody;
        this.isInstanceFollowRedirects = requestBuilder.isInstanceFollowRedirects;
        this.isCheckChain = requestBuilder.isCheckChain;
        this.mCallback = requestBuilder.mCallback;
        this.mTag = requestBuilder.mTag;
        this.isEncryptBody = requestBuilder.isEncryptBody;
        this.isGzipBody = requestBuilder.isGzipBody;
        this.mContext = requestBuilder.mContext;
        this.mRetryConnectionDelays = requestBuilder.mRetryConnectionDelaySeconds;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private HttpRequestController performRequest(Context var1_1) {
        block8: {
            if (var1_1 /* !! */  == null) {
                v0 = this;
                v0.callbackError(v0.mCallback, ErrorBuilder.build(540));
                return null;
            }
            if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
                v1 = this;
                v1.callbackError(v1.mCallback, ErrorBuilder.build(540));
                return null;
            }
            this.mContext = var1_1 /* !! */ ;
            var1_1 /* !! */  = v2;
            v2 = new BaseTask.OnTaskCallback(){

                @Override
                public void onSuccess(Response response) {
                    if (Request.this.mCallback != null) {
                        Request.this.mCallback.onRequestSuccess(response);
                    } else {
                        IOUtil.closeQuietly(response);
                    }
                }

                @Override
                public void onError(Error error) {
                    if (Request.this.mCallback != null) {
                        Request.this.mCallback.onRequestFailed(error);
                    }
                }
            };
            var2_2 = null;
            if (Build.VERSION.SDK_INT >= 21) break block8;
            var3_3 = v3;
            v3 = new AsyncReq(this, (BaseTask.OnTaskCallback)var1_1 /* !! */ );
            ** GOTO lbl23
        }
        var3_3 = v4;
        v4 = new OkAsyncReq(this, (BaseTask.OnTaskCallback)var1_1 /* !! */ );
lbl23:
        // 2 sources

        var2_2 = var3_3.getRequestController();
        try {
            MintPoolExecuter.execute(ExecutorEnum.Http, var3_3);
        }
        catch (Throwable v5) {
            v5.printStackTrace();
        }
        return var2_2;
    }

    private void callbackError(OnRequestCallback onRequestCallback, Error error) {
        if (onRequestCallback != null) {
            onRequestCallback.onRequestFailed(error);
        }
    }

    public RequestBuilder requestNewBuilder() {
        return new RequestBuilder().method(this.mMethod).headers(this.mHeaders).connectTimeout(this.mConnectTimeout).url(this.mUrl).body(this.mRequestBody).instanceFollowRedirects(this.isInstanceFollowRedirects).isCheckChain(this.isCheckChain).tag(this.mTag).encryptBody(this.isEncryptBody).callback(this.mCallback).context(this.mContext).retryOnConnectFailedDelaySeconds(this.mRetryConnectionDelays).gzip(this.isGzipBody);
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Method getRequestMethod() {
        return this.mMethod;
    }

    public Headers getHeaders() {
        return this.mHeaders;
    }

    public RequestBody getRequestBody() {
        return this.mRequestBody;
    }

    public boolean isEncryptBody() {
        return this.isEncryptBody;
    }

    public int getConnectTimeout() {
        return this.mConnectTimeout;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public boolean isInstanceFollowRedirects() {
        return this.isInstanceFollowRedirects;
    }

    public boolean isCheckChain() {
        return this.isCheckChain;
    }

    public Context getContext() {
        return this.mContext;
    }

    public boolean shouldCallbackResponse() {
        return this.mShouldCallbackResponse || this.mCallback != null;
    }

    public int[] getRetryConnectionTimes() {
        return this.mRetryConnectionDelays;
    }

    public Object getTag() {
        return this.mTag;
    }

    public boolean isGzipBody() {
        return this.isGzipBody;
    }

    public static class RequestBuilder {
        private Method mMethod;
        private Headers mHeaders;
        private int mConnectTimeout;
        private int mReadTimeout;
        private String mUrl;
        private RequestBody mRequestBody;
        private OnRequestCallback mCallback;
        private boolean isInstanceFollowRedirects;
        private boolean isCheckChain;
        private boolean isGzipBody = false;
        private boolean isEncryptBody = false;
        private Object mTag;
        private Context mContext;
        private int[] mRetryConnectionDelaySeconds;

        public RequestBuilder retryOnConnectFailedDelaySeconds(int ... nArray) {
            this.mRetryConnectionDelaySeconds = nArray;
            return this;
        }

        public RequestBuilder method(Method method) {
            this.mMethod = method;
            return this;
        }

        public RequestBuilder headers(Headers headers) {
            this.mHeaders = headers;
            return this;
        }

        public RequestBuilder connectTimeout(int n2) {
            this.mConnectTimeout = n2;
            return this;
        }

        public RequestBuilder readTimeout(int n2) {
            this.mReadTimeout = n2;
            return this;
        }

        public RequestBuilder url(String string) {
            this.mUrl = string;
            return this;
        }

        public RequestBuilder body(RequestBody requestBody) {
            this.mRequestBody = requestBody;
            return this;
        }

        public RequestBuilder encryptBody(boolean bl) {
            this.isEncryptBody = bl;
            return this;
        }

        public RequestBuilder gzip(boolean bl) {
            this.isGzipBody = bl;
            return this;
        }

        public RequestBuilder instanceFollowRedirects(boolean bl) {
            this.isInstanceFollowRedirects = bl;
            return this;
        }

        public RequestBuilder isCheckChain(boolean bl) {
            this.isCheckChain = bl;
            return this;
        }

        public RequestBuilder callback(OnRequestCallback onRequestCallback) {
            this.mCallback = onRequestCallback;
            return this;
        }

        public RequestBuilder tag(Object object) {
            this.mTag = object;
            return this;
        }

        public RequestBuilder context(Context context) {
            this.mContext = context;
            return this;
        }

        public Request build() {
            return new Request(this);
        }

        public HttpRequestController performRequest(Context context) {
            return this.build().performRequest(context);
        }
    }

    public static interface OnRequestCallback {
        public void onRequestSuccess(Response var1);

        public void onRequestFailed(Error var1);
    }

    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GET;
        public static final /* enum */ Method POST;
        private static final /* synthetic */ Method[] $VALUES;
        private final String value;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String string) {
            return Enum.valueOf(Method.class, string);
        }

        private Method(String string2) {
            this.value = string2;
        }

        static {
            Method method;
            GET = new Method("GET");
            Method method2 = method;
            POST = new Method("POST");
            $VALUES = new Method[]{GET, method2};
        }

        public String toString() {
            return this.value;
        }
    }
}

