/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network;

import com.zeus.gmc.sdk.mobileads.mintmediation.utils.IOUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MLog;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Headers;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.ResponseBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.connect.AbstractUrlConnection;
import java.io.Closeable;
import java.io.IOException;

public final class Response
implements Closeable {
    private static final String TAG = "Response";
    private final int mCode;
    private Headers mHeaders;
    private final ResponseBody mBody;
    private AbstractUrlConnection mConnection;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Response(Builder builder) {
        this.mCode = builder.mCode;
        this.mHeaders = builder.mHeaders;
        this.mBody = builder.mBody;
        this.mConnection = builder.mConnection;
    }

    public Builder newResponseBuilder() {
        return new Builder().code(this.mCode).headers(this.mHeaders).body(this.mBody).connection(this.mConnection);
    }

    public int code() {
        return this.mCode;
    }

    public Headers headers() {
        return this.mHeaders;
    }

    public ResponseBody body() {
        return this.mBody;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.mConnection != null) {
                this.mConnection.cancel();
                this.mConnection = null;
            }
            if (this.mHeaders != null) {
                this.mHeaders.clear();
                this.mHeaders = null;
            }
            IOUtil.closeQuietly(this.mBody.stream());
            return;
        }
        catch (Exception exception) {
            MLog.d(TAG, "Response close", exception);
        }
    }

    public String toString() {
        return "Response{mCode=" + this.mCode + ", mHeaders=" + this.mHeaders + ", mBody=" + this.mBody + '}';
    }

    public static final class Builder {
        private int mCode;
        private Headers mHeaders;
        private ResponseBody mBody;
        private AbstractUrlConnection mConnection;

        Builder() {
        }

        public Builder code(int n2) {
            this.mCode = n2;
            return this;
        }

        public Builder headers(Headers headers) {
            this.mHeaders = headers;
            return this;
        }

        public Builder body(ResponseBody responseBody) {
            this.mBody = responseBody;
            return this;
        }

        public Builder connection(AbstractUrlConnection abstractUrlConnection) {
            this.mConnection = abstractUrlConnection;
            return this;
        }

        public Response build() {
            return new Response(this);
        }
    }
}

