/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.connect;

import android.text.TextUtils;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.ExecutorEnum;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.IOUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.MintPoolExecuter;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.RequestBuilder;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Request;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Response;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.connect.HttpsEncryptProtocol;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.connect.HttpsEncryptProtocolV2;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class HttpsEncryptHelper {
    private static final HttpsEncryptHelper sInstance = new HttpsEncryptHelper();
    private final HttpsEncryptProtocol mProtocol;
    private final Map<String, PublicKey> mKeys;
    private final HandshakePublicKeyParser mKeyProvider;

    public static HttpsEncryptHelper getInstance() {
        return sInstance;
    }

    private HttpsEncryptHelper() {
        HandshakePublicKeyParser handshakePublicKeyParser;
        ConcurrentHashMap concurrentHashMap;
        HttpsEncryptProtocolV2 httpsEncryptProtocolV2;
        Object object = httpsEncryptProtocolV2;
        httpsEncryptProtocolV2 = new HttpsEncryptProtocolV2();
        this.mProtocol = object;
        object = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        this.mKeys = object;
        object = handshakePublicKeyParser;
        handshakePublicKeyParser = new HandshakePublicKeyParser();
        this.mKeyProvider = object;
    }

    public void preloadPubKeyWithInitUrl() {
        MintPoolExecuter.execute(ExecutorEnum.WorkExecutor, new Runnable(){

            @Override
            public void run() {
                String string = RequestBuilder.getInitUrl();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    URL uRL;
                    1 v0;
                    try {
                        v0 = object;
                    }
                    catch (Exception exception) {}
                    Object object = uRL;
                    uRL = new URL(string);
                    HandshakePublicKeyParser handshakePublicKeyParser = v0.HttpsEncryptHelper.this.mKeyProvider;
                    Object object2 = object;
                    Object object3 = object2;
                    object = ((URL)object2).getHost();
                    handshakePublicKeyParser.handshakeGetPubKeyLocked((String)object, ((URL)object3).getDefaultPort(), null);
                }
            }
        });
    }

    Request encryptRequest(Request request) {
        PublicKey publicKey;
        block5: {
            URL uRL;
            HttpsEncryptHelper httpsEncryptHelper;
            if (request == null) {
                return null;
            }
            try {
                httpsEncryptHelper = this;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            Object object = uRL;
            uRL = new URL(request.getUrl());
            publicKey = httpsEncryptHelper.mKeys.get(((URL)object).getHost());
            if (publicKey != null) break block5;
            URL uRL2 = object;
            object = uRL2.getHost();
            publicKey = this.mKeyProvider.handshakeGetPubKeyLocked((String)object, uRL2.getDefaultPort(), null);
        }
        if (publicKey == null) {
            return null;
        }
        return this.mProtocol.encrypt(request, publicKey.getEncoded());
    }

    Response decryptResponse(Response response) {
        return this.mProtocol.decrypt(response);
    }

    private class HandshakePublicKeyParser {
        private SSLSocketFactory defaultSocketFactory;

        private HandshakePublicKeyParser() {
            SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
            try {
                sSLContext.init(null, null, new SecureRandom());
                this.defaultSocketFactory = sSLContext.getSocketFactory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private PublicKey handshakeGetPubKeyLocked(String string, int n2, SSLSocketFactory sSLSocketFactory) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            PublicKey publicKey = (PublicKey)HttpsEncryptHelper.this.mKeys.get(string);
            if (publicKey != null) {
                return publicKey;
            }
            HandshakePublicKeyParser handshakePublicKeyParser = this;
            String string2 = string.intern();
            {
                catch (Exception exception) {}
            }
            publicKey = (PublicKey)handshakePublicKeyParser.HttpsEncryptHelper.this.mKeys.get(string);
            if (publicKey == null) {
                // MONITOREXIT : string2
                return this.handshakeGetPubKey(string, n2, sSLSocketFactory);
            }
            // MONITOREXIT : string2
            return publicKey;
        }

        /*
         * Unable to fully structure code
         */
        private PublicKey handshakeGetPubKey(String var1_1, int var2_2, SSLSocketFactory var3_4) {
            block12: {
                block11: {
                    var4_5 = null;
                    if (!TextUtils.isEmpty((CharSequence)var1_1)) break block11;
                    IOUtil.closeQuietly(var4_5);
                    return null;
                }
                if (var3_4 == null) {
                    if (this.defaultSocketFactory != null) break block12;
                    IOUtil.closeQuietly(var4_5);
                    return null;
                }
            }
            if (var3_4 == null) {
                var3_4 = this.defaultSocketFactory;
            }
            v0 = this;
            var4_5 = (SSLSocket)var3_4.createSocket(var1_1, var2_2);
            try {
                var4_5.startHandshake();
                var2_3 = v0.parsePublicKey(var4_5.getSession());
                ** if (var2_3 == null) goto lbl-1000
            }
            catch (Throwable v3) {
                IOUtil.closeQuietly(var4_5);
                throw v3;
            }
            catch (Exception v4) {}
lbl-1000:
            // 1 sources

            {
                v1 = var2_3;
                v2 = var4_5;
                HttpsEncryptHelper.access$300(HttpsEncryptHelper.this).put(var1_1, var2_3);
                IOUtil.closeQuietly(v2);
                return v1;
            }
lbl-1000:
            // 1 sources

            {
            }
            IOUtil.closeQuietly(var4_5);
            return null;
        }

        private PublicKey parsePublicKey(SSLSession sSLSession) {
            Certificate[] certificateArray;
            try {
                certificateArray = sSLSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                certificateArray = null;
            }
            if (certificateArray != null && certificateArray.length > 0) {
                return certificateArray[0].getPublicKey();
            }
            return null;
        }
    }
}

