/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.connect;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.LruCache;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.EncryptUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.Gzip;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.IOUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.crash.CrashUtil;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.ByteRequestBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Headers;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Request;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.RequestBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.Response;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.ResponseBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.StreamBody;
import com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.connect.HttpsEncryptProtocol;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

class HttpsEncryptProtocolV2
implements HttpsEncryptProtocol {
    private static final String NAME_X_MI_XKEY = "X-MI-XKEY";
    private static final String NAME_X_MI_XFLAG = "X-MI-XFLAG";
    private static final String NAME_X_MI_XVERSION = "X-MI-XVERSION";
    private static final String NAME_X_MI_XPROTOCOL = "X-MI-XPROTOCOL";
    private static final String VALUE_REQ_1_RESP_1 = String.valueOf(1);
    private static final String X_VERSION = "2.4";
    private static final String X_PROTOCOL = "2";
    private final String[] ENCRYPT_HEADER;
    private final String[] RESERVE_QUERY_KEYS;
    private final RequestEncryptImpl mRequestEncryptImpl;
    private final KeyHolder mKeyHolder;

    HttpsEncryptProtocolV2() {
        KeyHolder keyHolder;
        RequestEncryptImpl requestEncryptImpl;
        Object object = new String[]{};
        v0.ENCRYPT_HEADER = object;
        String[] stringArray = new String[]{};
        v0.RESERVE_QUERY_KEYS = stringArray;
        RequestEncryptImpl requestEncryptImpl2 = requestEncryptImpl;
        requestEncryptImpl = new RequestEncryptImpl((String[])object, stringArray);
        v0.mRequestEncryptImpl = requestEncryptImpl2;
        object = keyHolder;
        keyHolder = new KeyHolder();
        object.mKeyHolder = object;
    }

    private Request encryptRequestBody(Request request) {
        HttpsEncryptProtocolV2 httpsEncryptProtocolV2 = object;
        Request request2 = null;
        httpsEncryptProtocolV2.mKeyHolder.genKeyAndIdIfNeed();
        if (!httpsEncryptProtocolV2.mKeyHolder.isSecretKeyEmpty()) {
            RequestEncryptImpl requestEncryptImpl = ((HttpsEncryptProtocolV2)object).mRequestEncryptImpl;
            Request request3 = request;
            HttpsEncryptProtocolV2 httpsEncryptProtocolV22 = object;
            HttpsEncryptProtocolV2 httpsEncryptProtocolV23 = httpsEncryptProtocolV22;
            Object object = httpsEncryptProtocolV22.mKeyHolder.mEncryptBodyKey;
            try {
                request2 = requestEncryptImpl.encryptRequest(request3, (byte[])object, httpsEncryptProtocolV23.mKeyHolder.mEncryptBodyIv);
            }
            catch (Exception exception) {
                CrashUtil.getSingleton().saveException(exception);
            }
        }
        return request2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean encryptSecretKey(Request request, byte[] object) {
        Throwable throwable222222;
        block7: {
            if (request == null) return false;
            if (object == null) {
                return false;
            }
            HttpsEncryptProtocolV2 httpsEncryptProtocolV2 = headers;
            Headers headers = request.getHeaders();
            boolean bl = false;
            String string = httpsEncryptProtocolV2.mKeyHolder.getEncryptedSecretKeyFor(object);
            object = string;
            if (string != null) {
                Object object2 = headers;
                ((Headers)object2).set(NAME_X_MI_XKEY, (String)object);
                ((Headers)object2).set(NAME_X_MI_XFLAG, VALUE_REQ_1_RESP_1);
                ((Headers)object2).set(NAME_X_MI_XPROTOCOL, X_PROTOCOL);
                ((Headers)object2).set(NAME_X_MI_XVERSION, X_VERSION);
                bl = true;
            }
            if (bl) return bl;
            Headers headers2 = headers;
            headers2.remove(NAME_X_MI_XKEY);
            headers2.remove(NAME_X_MI_XFLAG);
            headers2.remove(NAME_X_MI_XPROTOCOL);
            headers2.remove(NAME_X_MI_XVERSION);
            return bl;
            {
                Object object3;
                Object object4;
                Object object5;
                catch (Throwable throwable222222) {
                    break block7;
                }
                catch (Exception exception) {}
                {
                    Object object6 = headers;
                    object5 = object6;
                    object4 = object6;
                    object3 = object6;
                    CrashUtil.getSingleton().saveException(exception);
                    ((Headers)object6).remove(NAME_X_MI_XKEY);
                }
                ((Headers)object5).remove(NAME_X_MI_XFLAG);
                ((Headers)object4).remove(NAME_X_MI_XPROTOCOL);
                ((Headers)object3).remove(NAME_X_MI_XVERSION);
            }
            return bl;
        }
        Headers headers = headers;
        headers.remove(NAME_X_MI_XKEY);
        headers.remove(NAME_X_MI_XFLAG);
        headers.remove(NAME_X_MI_XPROTOCOL);
        headers.remove(NAME_X_MI_XVERSION);
        throw throwable222222;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response decryptBody(Response closeable) {
        BufferedInputStream bufferedInputStream;
        Throwable throwable222222;
        Headers headers;
        BufferedInputStream bufferedInputStream2;
        byte[] byArray;
        boolean bl;
        block10: {
            BufferedInputStream bufferedInputStream3;
            Closeable closeable2;
            block9: {
                closeable2 = ((Response)closeable).body();
                if (closeable2 == null) {
                    return closeable;
                }
                ResponseBody responseBody = closeable2;
                closeable2 = null;
                bl = false;
                byArray = null;
                bufferedInputStream2 = null;
                headers = ((Response)closeable).headers();
                bufferedInputStream2 = responseBody.stream();
                byArray = IOUtil.toByteArray(bufferedInputStream2);
                bl = true;
                Object object = EncryptUtil.decryptServerData(byArray, ((HttpsEncryptProtocolV2)object).mKeyHolder.mEncryptBodyKey, ((HttpsEncryptProtocolV2)object).mKeyHolder.mEncryptBodyIv);
                if (!"gzip".equalsIgnoreCase(headers.getContentEncoding())) break block9;
                object = Gzip.unGZip((byte[])object);
                headers.remove("Content-Encoding");
            }
            BufferedInputStream bufferedInputStream4 = bufferedInputStream2;
            Closeable closeable3 = closeable;
            BufferedInputStream bufferedInputStream5 = bufferedInputStream3;
            bufferedInputStream3 = new BufferedInputStream(new ByteArrayInputStream((byte[])object));
            closeable2 = ((Response)closeable3).newResponseBuilder().body(new StreamBody(headers.getContentType(), bufferedInputStream5)).build();
            IOUtil.closeQuietly(bufferedInputStream4);
            return closeable2;
            {
                BufferedInputStream bufferedInputStream6;
                catch (Throwable throwable222222) {
                    break block10;
                }
                catch (Exception exception) {}
                {
                    CrashUtil.getSingleton().saveException(exception);
                    IOUtil.closeQuietly(bufferedInputStream2);
                    if (!bl) return closeable2;
                    if (byArray == null) return closeable2;
                }
                BufferedInputStream bufferedInputStream7 = bufferedInputStream6;
                bufferedInputStream6 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                return ((Response)closeable).newResponseBuilder().body(new StreamBody(headers.getContentType(), bufferedInputStream7)).build();
            }
        }
        IOUtil.closeQuietly(bufferedInputStream2);
        if (!bl) throw throwable222222;
        if (byArray == null) throw throwable222222;
        Closeable closeable4 = closeable;
        closeable = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        ((Response)closeable4).newResponseBuilder().body(new StreamBody(headers.getContentType(), (BufferedInputStream)closeable)).build();
        throw throwable222222;
    }

    @Override
    public Request encrypt(Request request, byte[] byArray) {
        if (!request.isEncryptBody()) {
            return null;
        }
        if ((request = this.encryptRequestBody(request)) != null && !this.encryptSecretKey(request, byArray)) {
            return null;
        }
        return request;
    }

    @Override
    public Response decrypt(Response response) {
        if (response != null && response.body() != null && response.headers() != null) {
            String string = response.headers().getFirst(NAME_X_MI_XFLAG);
            if (string != null && !string.isEmpty()) {
                if (!VALUE_REQ_1_RESP_1.equals(string)) {
                    return response;
                }
                return this.decryptBody(response);
            }
            return response;
        }
        return response;
    }

    private static class KeyHolder {
        private final LruCache<String, String> mEncryptedKeyCache;
        private final Object KEY_LOCK;
        private volatile String mSecretKeyId;
        private volatile byte[] mSecretKey;
        private volatile byte[] mEncryptBodyKey;
        private volatile byte[] mEncryptBodyIv;

        private KeyHolder() {
            Object object;
            LruCache lruCache;
            Object object2 = lruCache;
            lruCache = new LruCache(3);
            v1.mEncryptedKeyCache = object2;
            object2 = object;
            object = new Object();
            v1.KEY_LOCK = object2;
        }

        private boolean isSecretKeyEmpty() {
            return this.mSecretKey == null || this.mSecretKeyId == null || this.mEncryptBodyKey == null || this.mEncryptBodyIv == null;
        }

        private void genKeyAndIdIfNeed() {
            if (this.isSecretKeyEmpty()) {
                this.genKeyAndIDLocked();
            }
        }

        private String getEncryptedSecretKeyFor(byte[] byArray) throws Exception {
            String string = this.getEncryptedSecretKeyCacheKey(byArray);
            if (string == null) {
                return null;
            }
            String string2 = (String)this.mEncryptedKeyCache.get((Object)string);
            if (string2 == null) {
                KeyHolder keyHolder = this;
                string2 = this.mSecretKeyId + Base64.encodeToString((byte[])EncryptUtil.publicKeyEncryption(keyHolder.mSecretKey, byArray), (int)2);
                keyHolder.mEncryptedKeyCache.put((Object)string, (Object)string2);
            }
            return string2;
        }

        private String getEncryptedSecretKeyCacheKey(byte[] byArray) {
            if (this.isSecretKeyEmpty()) {
                return null;
            }
            return this.mSecretKeyId + Base64.encodeToString((byte[])byArray, (int)2);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void genKeyAndIDLocked() {
            KeyHolder keyHolder = this;
            Object object = keyHolder.KEY_LOCK;
            // MONITORENTER : object
            try {
                if (!keyHolder.isSecretKeyEmpty()) return;
                KeyHolder keyHolder2 = this;
                keyHolder2.mSecretKey = EncryptUtil.genSymmetricKey();
                keyHolder2.mSecretKeyId = UUID.randomUUID().toString().replace("-", "");
                keyHolder2.mEncryptBodyKey = Arrays.copyOfRange(keyHolder2.mSecretKey, 0, 16);
                keyHolder2.mEncryptBodyIv = Arrays.copyOfRange(keyHolder2.mSecretKey, 16, this.mSecretKey.length);
                return;
            }
            catch (Exception exception) {
                KeyHolder keyHolder3 = this;
                keyHolder3.mSecretKey = null;
                keyHolder3.mSecretKeyId = null;
                keyHolder3.mEncryptBodyKey = null;
                keyHolder3.mEncryptBodyIv = null;
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    private static class RequestEncryptImpl {
        private static final String J_METHOD = "method";
        private static final String J_BODY = "body";
        private static final String J_QUERY = "query";
        private static final String J_HEADERS = "headers";
        private final String[] mEncryptHeaderKeys;
        private final String[] reservedQueryKeys;

        private RequestEncryptImpl(String[] stringArray, String[] stringArray2) {
            this.mEncryptHeaderKeys = stringArray;
            this.reservedQueryKeys = stringArray2;
        }

        private String getUrlWithReservedQuery(String string) {
            string = Uri.parse((String)string);
            Uri.Builder builder = new Uri.Builder().scheme(string.getScheme()).authority(string.getHost()).path(string.getPath());
            Set set = string.getQueryParameterNames();
            if (set != null && !set.isEmpty()) {
                HashSet<String> hashSet;
                Set set2 = set;
                set = hashSet;
                hashSet = new HashSet<String>(Arrays.asList(((RequestEncryptImpl)this).reservedQueryKeys));
                for (String string2 : set2) {
                    if (!((HashSet)set).contains(string2)) continue;
                    builder.appendQueryParameter(string2, string.getQueryParameter(string2));
                }
            }
            return builder.build().toString();
        }

        private JSONObject getEncryptHeaders(Headers headers) throws Exception {
            HashSet<String> hashSet;
            JSONObject jSONObject;
            RequestEncryptImpl requestEncryptImpl = requestEncryptImpl2;
            RequestEncryptImpl requestEncryptImpl2 = jSONObject;
            jSONObject = new JSONObject();
            Object object = requestEncryptImpl.mEncryptHeaderKeys;
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>();
            if (requestEncryptImpl.mEncryptHeaderKeys != null) {
                object = Arrays.asList(object);
                if (headers != null) {
                    for (String string : headers.names()) {
                        JSONArray jSONArray;
                        if (!object.contains(string)) continue;
                        Object object2 = headers.values(string);
                        JSONArray jSONArray2 = jSONArray;
                        jSONArray = new JSONArray();
                        if (object2 != null) {
                            object2 = object2.iterator();
                            while (object2.hasNext()) {
                                jSONArray2.put((Object)((String)object2.next()));
                            }
                        }
                        requestEncryptImpl2.put(string, jSONArray2);
                        hashSet2.add(string);
                    }
                }
            }
            return requestEncryptImpl2;
        }

        private String parseQueryFromUrl(String string) {
            int n2;
            int n3;
            block3: {
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return null;
                }
                String string2 = string;
                n3 = string2.indexOf(63) + 1;
                int n4 = string2.length();
                for (n2 = n3; n2 < string.length(); ++n2) {
                    if (string.charAt(n2) != '#') {
                        continue;
                    }
                    break block3;
                }
                n2 = n4;
            }
            return string.substring(n3, n2);
        }

        Request encryptRequest(Request object, byte[] object2, byte[] byArray) throws Exception {
            ByteRequestBody byteRequestBody;
            Headers headers;
            Object object3;
            Request request = object;
            String string = request.getRequestMethod().toString();
            String string2 = request.getUrl();
            String string3 = ((RequestEncryptImpl)object4).parseQueryFromUrl(string2);
            if (string3 == null) {
                string3 = "";
            }
            string2 = ((RequestEncryptImpl)object4).getUrlWithReservedQuery(string2);
            RequestBody requestBody = ((Request)object).getRequestBody();
            if (requestBody != null) {
                ByteArrayOutputStream byteArrayOutputStream;
                object3 = byteArrayOutputStream;
                object3();
                requestBody.writeTo((OutputStream)object3);
                object3 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            } else {
                object3 = new byte[]{};
            }
            RequestEncryptImpl requestEncryptImpl = object4;
            Object object4 = Base64.encodeToString((byte[])object3, (int)2);
            object3 = headers;
            object3();
            headers.add(((Request)object).getHeaders());
            JSONObject jSONObject = requestEncryptImpl.getEncryptHeaders(headers);
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(J_METHOD, (Object)string);
            jSONObject2.put(J_QUERY, (Object)string3);
            jSONObject2.put(J_HEADERS, (Object)jSONObject);
            jSONObject2.put(J_BODY, object4);
            object4 = EncryptUtil.symmetricEncryption(jSONObject2.toString().getBytes("UTF-8"), (byte[])object2, byArray);
            object2 = requestBody == null ? (Object)"application/octet-stream" : (Object)requestBody.contentType();
            Request request2 = object;
            byte[] byArray2 = object3;
            object = byteRequestBody;
            byArray2.set("Content-Length", String.valueOf(new ByteRequestBody((byte[])object4, (String)object2).length()));
            byArray2.set("Content-Type", (String)object2);
            object3.set("Host", Uri.parse((String)string2).getHost());
            return request2.requestNewBuilder().url(string2).method(Request.Method.POST).headers((Headers)object3).body((RequestBody)object).build();
        }
    }
}

