/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.request.network.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;

public class NetworkChecker {
    public static boolean isAvailable(Context context) {
        return true;
    }

    public static boolean isNetworkAvailable(Context context) {
        if (context == null) {
            return false;
        }
        context = (ConnectivityManager)context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = context.getActiveNetwork();
            if (network == null) {
                return false;
            }
            return (context = context.getNetworkCapabilities(network)) != null && (context.hasTransport(1) || context.hasTransport(0) || context.hasTransport(3) || context.hasTransport(2));
        }
        return (context = context.getActiveNetworkInfo()) != null && context.isConnected();
    }

    public static String getNetworkOperator(Context context) {
        if (context == null) {
            return "";
        }
        context = (TelephonyManager)context.getSystemService("phone");
        return context.getNetworkOperator() + context.getNetworkOperatorName();
    }

    public static int getConnectType(Context context) {
        if (context == null) {
            return NetType.UNKNOWN.getValue();
        }
        NetType netType = null;
        NetworkInfo networkInfo = null;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        if (networkInfo != null) {
            int n2 = networkInfo.getType();
            netType = n2 != 0 ? (n2 != 1 ? (n2 != 9 ? NetType.UNKNOWN : NetType.ETHERNET) : NetType.WIFI) : NetworkChecker.getMobileNetType(context);
        }
        if (netType == null) {
            netType = NetType.UNKNOWN;
        }
        return netType.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NetType getMobileNetType(Context context) {
        if (context == null) {
            return NetType.UNKNOWN;
        }
        if ((context = (TelephonyManager)context.getSystemService("phone")) == null) {
            return NetType.MOBILE;
        }
        try {
            switch (context.getNetworkType()) {
                default: {
                    return NetType.MOBILE;
                }
                case 20: {
                    return NetType.MOBILE_5G;
                }
                case 13: 
                case 16: 
                case 17: {
                    return NetType.MOBILE_4G;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return NetType.MOBILE_3G;
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
            }
            return NetType.MOBILE_2G;
        }
        catch (Exception exception) {
            return NetType.MOBILE;
        }
    }

    public static final class NetType
    extends Enum<NetType> {
        public static final /* enum */ NetType UNKNOWN;
        public static final /* enum */ NetType ETHERNET;
        public static final /* enum */ NetType WIFI;
        public static final /* enum */ NetType MOBILE;
        public static final /* enum */ NetType MOBILE_2G;
        public static final /* enum */ NetType MOBILE_3G;
        public static final /* enum */ NetType MOBILE_4G;
        public static final /* enum */ NetType MOBILE_5G;
        public static final /* enum */ NetType MOBILE_6G;
        private static final /* synthetic */ NetType[] $VALUES;
        private final int mValue;

        public static NetType[] values() {
            return (NetType[])$VALUES.clone();
        }

        public static NetType valueOf(String string) {
            return Enum.valueOf(NetType.class, string);
        }

        private NetType(int n3) {
            this.mValue = n3;
        }

        static {
            NetType netType;
            UNKNOWN = new NetType(0);
            ETHERNET = new NetType(1);
            WIFI = new NetType(2);
            MOBILE = new NetType(3);
            MOBILE_2G = new NetType(4);
            MOBILE_3G = new NetType(5);
            MOBILE_4G = new NetType(6);
            MOBILE_5G = new NetType(7);
            NetType netType2 = netType;
            MOBILE_6G = new NetType(8);
            $VALUES = new NetType[]{UNKNOWN, ETHERNET, WIFI, MOBILE, MOBILE_2G, MOBILE_3G, MOBILE_4G, MOBILE_5G, netType2};
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

