/*
 * Decompiled with CFR 0.152.
 */
package com.zeus.gmc.sdk.mobileads.mintmediation.utils.thread;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class ThreadHelper {
    @Deprecated
    public static final ExecutorService CACHED_EXECUTOR = Executors.newCachedThreadPool();
    private static final Object sLock = new Object();
    private static final boolean sWillOverride = false;
    private static Handler sUiThreadHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Handler getUiThreadHandler() {
        Object object = sLock;
        synchronized (object) {
            if (sUiThreadHandler == null) {
                sUiThreadHandler = new Handler(Looper.getMainLooper());
            }
            return sUiThreadHandler;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void runOnUiThreadBlocking(Runnable runnable) {
        if (ThreadHelper.runningOnUiThread()) {
            runnable.run();
            return;
        }
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
        ThreadHelper.postOnUiThread(futureTask);
        try {
            futureTask.get();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception occured while waiting for runnable", exception);
        }
    }

    public static <T> T runOnUiThreadBlockingNoException(Callable<T> callable) {
        try {
            return ThreadHelper.runOnUiThreadBlocking(callable);
        }
        catch (ExecutionException executionException) {
            throw new RuntimeException("Error occured waiting for callable", executionException);
        }
    }

    public static <T> T runOnUiThreadBlocking(Callable<T> callable) throws ExecutionException {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        ThreadHelper.runOnUiThread(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted waiting for callable", interruptedException);
        }
    }

    public static <T> FutureTask<T> runOnUiThread(FutureTask<T> futureTask) {
        if (ThreadHelper.runningOnUiThread()) {
            futureTask.run();
        } else {
            ThreadHelper.postOnUiThread(futureTask);
        }
        return futureTask;
    }

    public static void runOnUiThread(Runnable runnable) {
        if (ThreadHelper.runningOnUiThread()) {
            runnable.run();
        } else {
            ThreadHelper.getUiThreadHandler().post(runnable);
        }
    }

    public static <T> FutureTask<T> postOnUiThread(FutureTask<T> futureTask) {
        ThreadHelper.getUiThreadHandler().post(futureTask);
        return futureTask;
    }

    public static void postOnUiThread(Runnable runnable) {
        ThreadHelper.getUiThreadHandler().post(runnable);
    }

    public static void postOnUiThreadDelayed(Runnable runnable, long l2) {
        ThreadHelper.getUiThreadHandler().postDelayed(runnable, l2);
    }

    public static boolean runningOnUiThread() {
        return ThreadHelper.getUiThreadHandler().getLooper() == Looper.myLooper();
    }

    public static void revokeOnUiThread(Runnable runnable) {
        ThreadHelper.getUiThreadHandler().removeCallbacks(runnable);
    }
}

