/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.JsonSerializable;
import com.microsoft.azure.documentdb.PartitionKeyDefinitionVersion;
import com.microsoft.azure.documentdb.PartitionKind;
import com.microsoft.azure.documentdb.internal.Strings;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONObject;

public final class PartitionKeyDefinition
extends JsonSerializable {
    public PartitionKeyDefinition() {
        this.setKind(PartitionKind.Hash);
    }

    public PartitionKeyDefinition(String jsonString) {
        super(jsonString);
    }

    public PartitionKeyDefinition(JSONObject jsonObject) {
        super(jsonObject);
    }

    public PartitionKind getKind() {
        return PartitionKind.valueOf(WordUtils.capitalize((String)super.getString("kind")));
    }

    public void setKind(PartitionKind kind) {
        super.set("kind", kind.name());
    }

    public PartitionKeyDefinitionVersion getVersion() {
        Object version = super.getObject("version", Object.class);
        if (version == null) {
            return null;
        }
        String versionStr = String.valueOf(version);
        if (StringUtils.isNumeric((CharSequence)versionStr)) {
            return PartitionKeyDefinitionVersion.valueOf(String.format("V%d", Integer.parseInt(versionStr)));
        }
        return !Strings.isNullOrEmpty(versionStr) ? PartitionKeyDefinitionVersion.valueOf(WordUtils.capitalize((String)versionStr)) : null;
    }

    public void setVersion(PartitionKeyDefinitionVersion version) {
        super.set("version", version.name());
    }

    public Collection<String> getPaths() {
        Collection<String> paths = super.getCollection("paths", String.class);
        if (paths == null) {
            paths = new ArrayList<String>();
            super.set("paths", paths);
        }
        return paths;
    }

    public void setPaths(Collection<String> paths) {
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException("paths must not be null or empty.");
        }
        super.set("paths", paths);
    }
}

