/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.Context;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.CharacterStyle;
import android.text.style.StyleSpan;
import android.util.Log;
import android.widget.Button;
import android.widget.TextView;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.GenericsUtil;
import com.mikepenz.iconics.utils.IconicsTypefaceSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class Iconics {
    public static final String TAG = Iconics.class.getSimpleName();
    private static HashMap<String, ITypeface> FONTS;

    public static void init(Context ctx) {
        String[] fonts = GenericsUtil.getFields(ctx);
        FONTS = new HashMap();
        for (String fontsClassPath : fonts) {
            try {
                ITypeface typeface = (ITypeface)Class.forName(fontsClassPath).newInstance();
                FONTS.put(typeface.getMappingPrefix(), typeface);
            }
            catch (Exception e) {
                Log.e((String)"Android-Iconics", (String)("Can't init: " + fontsClassPath));
            }
        }
    }

    public static boolean registerFont(ITypeface font) {
        FONTS.put(font.getMappingPrefix(), font);
        return true;
    }

    public static ITypeface getDefault(Context ctx) {
        if (FONTS == null) {
            Iconics.init(ctx);
        }
        if (FONTS != null && FONTS.size() > 0) {
            return FONTS.entrySet().iterator().next().getValue();
        }
        throw new RuntimeException("You have to provide at least one Typeface to use this functionality");
    }

    public static Collection<ITypeface> getRegisteredFonts(Context ctx) {
        if (FONTS == null) {
            Iconics.init(ctx);
        }
        return FONTS.values();
    }

    public static ITypeface findFont(Context ctx, String key) {
        if (FONTS == null) {
            Iconics.init(ctx);
        }
        return FONTS.get(key);
    }

    public static ITypeface findFont(IIcon icon) {
        return icon.getTypeface();
    }

    private Iconics() {
    }

    private static SpannableString style(Context ctx, HashMap<String, ITypeface> fonts, SpannableString textSpanned, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
        if (FONTS == null) {
            Iconics.init(ctx);
        }
        if (fonts == null || fonts.size() == 0) {
            fonts = FONTS;
        }
        int startIndex = -1;
        String fontKey = "";
        ArrayList<RemoveInfo> removed = new ArrayList<RemoveInfo>();
        StringBuilder text = new StringBuilder((CharSequence)textSpanned);
        while ((startIndex = text.indexOf("{", startIndex + 1)) != -1) {
            if (text.length() < startIndex + 5) {
                startIndex = -1;
                break;
            }
            if (text.substring(startIndex + 4, startIndex + 5).equals("-") && !fonts.containsKey(fontKey = text.substring(startIndex + 1, startIndex + 4).toLowerCase())) continue;
        }
        if (startIndex == -1) {
            return new SpannableString((CharSequence)text);
        }
        int removedChars = 0;
        LinkedList<StyleContainer> styleContainers = new LinkedList<StyleContainer>();
        block3: do {
            int endIndex = text.substring(startIndex).indexOf("}") + startIndex + 1;
            String iconString = text.substring(startIndex + 1, endIndex - 1);
            iconString = iconString.replaceAll("-", "_").toLowerCase();
            try {
                ITypeface typeface = fonts.get(fontKey);
                if (typeface != null) {
                    IIcon icon = typeface.getIcon(iconString);
                    if (icon != null) {
                        char fontChar = icon.getCharacter();
                        String iconValue = String.valueOf(fontChar);
                        text = text.replace(startIndex, endIndex, iconValue);
                        removed.add(new RemoveInfo(startIndex, endIndex - startIndex - 1, removedChars += endIndex - startIndex));
                        styleContainers.add(new StyleContainer(startIndex, startIndex + 1, iconString, fonts.get(fontKey)));
                    } else {
                        Log.e((String)TAG, (String)("Wrong icon name: " + iconString));
                    }
                } else {
                    Log.e((String)TAG, (String)("Wrong fontId: " + iconString));
                }
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)("Wrong icon name: " + iconString));
            }
            fontKey = null;
            while ((startIndex = text.indexOf("{", startIndex + 1)) != -1) {
                if (text.length() < startIndex + 5) {
                    startIndex = -1;
                    continue block3;
                }
                if (!text.substring(startIndex + 4, startIndex + 5).equals("-") || !fonts.containsKey(fontKey = text.substring(startIndex + 1, startIndex + 4))) continue;
            }
        } while (startIndex != -1 && fontKey != null);
        SpannableString sb = new SpannableString((CharSequence)text);
        for (StyleSpan span : (StyleSpan[])textSpanned.getSpans(0, textSpanned.length(), StyleSpan.class)) {
            int spanStart = Iconics.newSpanPoint(textSpanned.getSpanStart((Object)span), removed);
            int spanEnd = Iconics.newSpanPoint(textSpanned.getSpanEnd((Object)span), removed);
            if (spanStart < 0 || spanEnd <= 0) continue;
            sb.setSpan((Object)span, spanStart, spanEnd, textSpanned.getSpanFlags((Object)span));
        }
        for (StyleContainer styleContainer : styleContainers) {
            sb.setSpan((Object)new IconicsTypefaceSpan("sans-serif", styleContainer.getFont().getTypeface(ctx)), styleContainer.getStartIndex(), styleContainer.getEndIndex(), 33);
            if (stylesFor.containsKey(styleContainer.getIcon())) {
                for (CharacterStyle style : stylesFor.get(styleContainer.getIcon())) {
                    sb.setSpan((Object)CharacterStyle.wrap((CharacterStyle)style), styleContainer.getStartIndex(), styleContainer.getEndIndex(), 33);
                }
                continue;
            }
            if (styles == null) continue;
            for (CharacterStyle style : styles) {
                sb.setSpan((Object)CharacterStyle.wrap((CharacterStyle)style), styleContainer.getStartIndex(), styleContainer.getEndIndex(), 33);
            }
        }
        return sb;
    }

    private static int newSpanPoint(int pos, ArrayList<RemoveInfo> removed) {
        for (RemoveInfo removeInfo : removed) {
            if (pos < removeInfo.getStart()) {
                return pos;
            }
            pos -= removeInfo.getCount();
        }
        return pos;
    }

    private static int determineNewSpanPoint(int pos, ArrayList<RemoveInfo> removed) {
        for (RemoveInfo removeInfo : removed) {
            if (pos > removeInfo.getStart()) continue;
            if (pos > removeInfo.getStart() && pos < removeInfo.getStart() + removeInfo.getCount()) {
                return -1;
            }
            if (pos < removeInfo.getStart()) {
                return pos;
            }
            return pos - removeInfo.getTotal();
        }
        return -1;
    }

    private static class RemoveInfo {
        private int start;
        private int count;
        private int total;

        public RemoveInfo(int start, int count) {
            this.start = start;
            this.count = count;
        }

        public RemoveInfo(int start, int count, int total) {
            this.start = start;
            this.count = count;
            this.total = total;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }
    }

    private static class StyleContainer {
        private int startIndex;
        private int endIndex;
        private String icon;
        private ITypeface font;

        private StyleContainer(int startIndex, int endIndex, String icon, ITypeface font) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.icon = icon;
            this.font = font;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public String getIcon() {
            return this.icon;
        }

        public ITypeface getFont() {
            return this.font;
        }
    }

    public static class IconicsBuilder {
        private List<CharacterStyle> styles = new LinkedList<CharacterStyle>();
        private HashMap<String, List<CharacterStyle>> stylesFor = new HashMap();
        private List<ITypeface> fonts = new LinkedList<ITypeface>();
        private Context ctx;

        public IconicsBuilder ctx(Context ctx) {
            this.ctx = ctx;
            return this;
        }

        public IconicsBuilder style(CharacterStyle ... styles) {
            if (styles != null && styles.length > 0) {
                Collections.addAll(this.styles, styles);
            }
            return this;
        }

        public IconicsBuilder styleFor(IIcon styleFor, CharacterStyle ... styles) {
            return this.styleFor(styleFor.getName(), styles);
        }

        public IconicsBuilder styleFor(String styleFor, CharacterStyle ... styles) {
            if (!this.stylesFor.containsKey(styleFor = styleFor.replace("-", "_"))) {
                this.stylesFor.put(styleFor, new LinkedList());
            }
            if (styles != null && styles.length > 0) {
                for (CharacterStyle style : styles) {
                    this.stylesFor.get(styleFor).add(style);
                }
            }
            return this;
        }

        public IconicsBuilder font(ITypeface font) {
            this.fonts.add(font);
            return this;
        }

        public IconicsBuilderString on(SpannableString on) {
            return new IconicsBuilderString(this.ctx, this.fonts, on, this.styles, this.stylesFor);
        }

        public IconicsBuilderString on(String on) {
            return this.on(new SpannableString((CharSequence)on));
        }

        public IconicsBuilderString on(CharSequence on) {
            return this.on(on.toString());
        }

        public IconicsBuilderString on(StringBuilder on) {
            return this.on(on.toString());
        }

        public IconicsBuilderView on(TextView on) {
            return new IconicsBuilderView(this.ctx, this.fonts, on, this.styles, this.stylesFor);
        }

        public IconicsBuilderView on(Button on) {
            return new IconicsBuilderView(this.ctx, this.fonts, (TextView)on, this.styles, this.stylesFor);
        }
    }

    public static class IconicsBuilderView {
        private Context ctx;
        private TextView view;
        private List<CharacterStyle> withStyles;
        private HashMap<String, List<CharacterStyle>> withStylesFor;
        private List<ITypeface> fonts;

        public IconicsBuilderView(Context ctx, List<ITypeface> fonts, TextView view, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
            this.ctx = ctx;
            this.fonts = fonts;
            this.view = view;
            this.withStyles = styles;
            this.withStylesFor = stylesFor;
        }

        public void build() {
            HashMap<String, ITypeface> mappedFonts = new HashMap<String, ITypeface>();
            for (ITypeface font : this.fonts) {
                mappedFonts.put(font.getMappingPrefix(), font);
            }
            if (this.view.getText() instanceof SpannableString) {
                this.view.setText((CharSequence)Iconics.style(this.ctx, mappedFonts, (SpannableString)this.view.getText(), this.withStyles, this.withStylesFor));
            } else {
                this.view.setText((CharSequence)Iconics.style(this.ctx, mappedFonts, new SpannableString(this.view.getText()), this.withStyles, this.withStylesFor));
            }
            if (Build.VERSION.SDK_INT >= 14 && this.view instanceof Button) {
                this.view.setAllCaps(false);
            }
        }
    }

    public static class IconicsBuilderString {
        private Context ctx;
        private SpannableString text;
        private List<CharacterStyle> withStyles;
        private HashMap<String, List<CharacterStyle>> withStylesFor;
        private List<ITypeface> fonts;

        public IconicsBuilderString(Context ctx, List<ITypeface> fonts, SpannableString text, List<CharacterStyle> styles, HashMap<String, List<CharacterStyle>> stylesFor) {
            this.ctx = ctx;
            this.fonts = fonts;
            this.text = text;
            this.withStyles = styles;
            this.withStylesFor = stylesFor;
        }

        public SpannableString build() {
            HashMap<String, ITypeface> mappedFonts = new HashMap<String, ITypeface>();
            for (ITypeface font : this.fonts) {
                mappedFonts.put(font.getMappingPrefix(), font);
            }
            return Iconics.style(this.ctx, mappedFonts, this.text, this.withStyles, this.withStylesFor);
        }
    }
}

