/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.typeface;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import java.util.Collection;
import java.util.HashMap;

public class GenericFont
implements ITypeface {
    private String mMappingPrefix;
    private String mFontFile;
    private Typeface typeface = null;
    private HashMap<String, Character> mChars = new HashMap();

    protected GenericFont() {
    }

    public GenericFont(String mappingPrefix, String fontFile) {
        this.mMappingPrefix = mappingPrefix;
        this.mFontFile = fontFile;
    }

    public void registerIcon(String name, char aChar) {
        this.mChars.put(this.mMappingPrefix + "_" + name, Character.valueOf(aChar));
    }

    @Override
    public IIcon getIcon(String key) {
        return new Icon(this.mChars.get(key).charValue()).withTypeface(this);
    }

    @Override
    public HashMap<String, Character> getCharacters() {
        return new HashMap<String, Character>();
    }

    @Override
    public String getMappingPrefix() {
        return this.mMappingPrefix;
    }

    @Override
    public String getFontName() {
        return "GenericFont";
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public int getIconCount() {
        return this.mChars.size();
    }

    @Override
    public Collection<String> getIcons() {
        return this.mChars.keySet();
    }

    @Override
    public String getAuthor() {
        return "";
    }

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getLicense() {
        return "";
    }

    @Override
    public String getLicenseUrl() {
        return "";
    }

    @Override
    public Typeface getTypeface(Context context) {
        if (this.typeface == null) {
            try {
                this.typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)this.mFontFile);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.typeface;
    }

    public class Icon
    implements IIcon {
        private String mName;
        private char aChar;
        private ITypeface mTypeface;

        public Icon(char c) {
            this.aChar = c;
        }

        public Icon(String name, char c) {
            this.mName = name;
            this.aChar = c;
        }

        public Icon withTypeface(ITypeface typeface) {
            this.mTypeface = typeface;
            return this;
        }

        @Override
        public String getFormattedName() {
            return "{" + this.getName() + "}";
        }

        @Override
        public String getName() {
            if (this.mName != null) {
                return this.mName;
            }
            return String.valueOf(this.aChar);
        }

        @Override
        public char getCharacter() {
            return this.aChar;
        }

        @Override
        public ITypeface getTypeface() {
            if (this.mTypeface != null) {
                return this.mTypeface;
            }
            return GenericFont.this;
        }
    }
}

