/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.graphics.Typeface;
import android.util.Pair;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import java.util.ArrayList;

public class IconicsArrayBuilder {
    private IconicsDrawable mIconBase;
    private ArrayList<Pair<Object, Typeface>> mIcons = new ArrayList();

    public IconicsArrayBuilder(IconicsDrawable iconicsDrawable) {
        this.mIconBase = iconicsDrawable;
    }

    public IconicsArrayBuilder add(IIcon icon) {
        this.mIcons.add((Pair<Object, Typeface>)Pair.create((Object)icon, (Object)null));
        return this;
    }

    public IconicsArrayBuilder add(String icon) {
        return this.add(icon, Typeface.DEFAULT);
    }

    public IconicsArrayBuilder add(Character icon) {
        return this.add(icon, Typeface.DEFAULT);
    }

    public IconicsArrayBuilder add(String icon, Typeface typeface) {
        this.mIcons.add((Pair<Object, Typeface>)Pair.create((Object)icon, (Object)typeface));
        return this;
    }

    public IconicsArrayBuilder add(Character icon, Typeface typeface) {
        this.mIcons.add((Pair<Object, Typeface>)Pair.create((Object)icon, (Object)typeface));
        return this;
    }

    public IconicsDrawable[] build() {
        IconicsDrawable[] iconicsDrawables = new IconicsDrawable[this.mIcons.size()];
        for (int i = 0; i < this.mIcons.size(); ++i) {
            Pair<Object, Typeface> pair = this.mIcons.get(i);
            if (pair.first instanceof IIcon) {
                iconicsDrawables[i] = this.mIconBase.clone().icon((IIcon)pair.first);
                continue;
            }
            if (pair.first instanceof Character) {
                iconicsDrawables[i] = this.mIconBase.clone().icon((Character)pair.first, (Typeface)pair.second);
                continue;
            }
            if (!(pair.first instanceof String)) continue;
            iconicsDrawables[i] = this.mIconBase.clone().iconText((String)pair.first, (Typeface)pair.second);
        }
        return iconicsDrawables;
    }
}

