/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.context;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StyleableRes;
import android.text.TextUtils;
import com.mikepenz.iconics.IconicsDrawable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class IconicsAttrsExtractor {
    private static final int DEF_COLOR = Integer.MIN_VALUE;
    private static final int DEF_SIZE = -1;
    @NonNull
    private final Context mContext;
    @NonNull
    private final TypedArray mTypedArray;
    @StyleableRes
    private int mIconId;
    @StyleableRes
    private int mSizeId;
    @StyleableRes
    private int mColorsId;
    @StyleableRes
    private int mPaddingId;
    @StyleableRes
    private int mContourColorId;
    @StyleableRes
    private int mContourWidthId;
    @StyleableRes
    private int mBackgroundColorId;
    @StyleableRes
    private int mCornerRadiusId;
    @StyleableRes
    private int mBackgroundContourColorId;
    @StyleableRes
    private int mBackgroundContourWidthId;
    @StyleableRes
    private int mOffsetXId;
    @StyleableRes
    private int mOffsetYId;

    public IconicsAttrsExtractor(@NonNull Context context, @NonNull TypedArray typedArray) {
        this.mContext = context;
        this.mTypedArray = typedArray;
    }

    public IconicsAttrsExtractor iconId(@StyleableRes int iconId) {
        this.mIconId = iconId;
        return this;
    }

    public IconicsAttrsExtractor sizeId(@StyleableRes int sizeId) {
        this.mSizeId = sizeId;
        return this;
    }

    public IconicsAttrsExtractor colorsId(@StyleableRes int colorsId) {
        this.mColorsId = colorsId;
        return this;
    }

    public IconicsAttrsExtractor paddingId(@StyleableRes int paddingId) {
        this.mPaddingId = paddingId;
        return this;
    }

    public IconicsAttrsExtractor contourColorId(@StyleableRes int contourColorId) {
        this.mContourColorId = contourColorId;
        return this;
    }

    public IconicsAttrsExtractor contourWidthId(@StyleableRes int contourWidthId) {
        this.mContourWidthId = contourWidthId;
        return this;
    }

    public IconicsAttrsExtractor backgroundColorId(@StyleableRes int backgroundColorId) {
        this.mBackgroundColorId = backgroundColorId;
        return this;
    }

    public IconicsAttrsExtractor cornerRadiusId(@StyleableRes int cornerRadiusId) {
        this.mCornerRadiusId = cornerRadiusId;
        return this;
    }

    public IconicsAttrsExtractor backgroundContourColorId(@StyleableRes int backgroundContourColorId) {
        this.mBackgroundContourColorId = backgroundContourColorId;
        return this;
    }

    public IconicsAttrsExtractor backgroundContourWidthId(@StyleableRes int backgroundContourWidthId) {
        this.mBackgroundContourWidthId = backgroundContourWidthId;
        return this;
    }

    public IconicsAttrsExtractor offsetXId(@StyleableRes int offsetXId) {
        this.mOffsetXId = offsetXId;
        return this;
    }

    public IconicsAttrsExtractor offsetYId(@StyleableRes int offsetYId) {
        this.mOffsetYId = offsetYId;
        return this;
    }

    @NonNull
    public IconicsDrawable extractNonNull() {
        return this.extract(null, false, true);
    }

    @Nullable
    public IconicsDrawable extract(@Nullable IconicsDrawable icon) {
        return this.extract(icon, false, false);
    }

    @Nullable
    public IconicsDrawable extract() {
        return this.extract(null, false, false);
    }

    @Nullable
    public IconicsDrawable extractWithOffsets() {
        return this.extract(null, true, false);
    }

    private IconicsDrawable extract(@Nullable IconicsDrawable icon, boolean extractOffsets, boolean nonNull) {
        int backgroundContourWidth;
        int backgroundContourColor;
        int cornerRadius;
        int backgroundColor;
        int contourWidth;
        int contourColor;
        int padding;
        int size;
        ColorStateList colors;
        icon = IconicsAttrsExtractor.copyIfCan(icon);
        String i = this.mTypedArray.getString(this.mIconId);
        if (!TextUtils.isEmpty((CharSequence)i)) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).icon(i);
        }
        if ((colors = this.mTypedArray.getColorStateList(this.mColorsId)) != null) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).color(colors);
        }
        if ((size = this.mTypedArray.getDimensionPixelSize(this.mSizeId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).sizePx(size);
        }
        if ((padding = this.mTypedArray.getDimensionPixelSize(this.mPaddingId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).paddingPx(padding);
        }
        if ((contourColor = this.mTypedArray.getColor(this.mContourColorId, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).contourColor(contourColor);
        }
        if ((contourWidth = this.mTypedArray.getDimensionPixelSize(this.mContourWidthId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).contourWidthPx(contourWidth);
        }
        if ((backgroundColor = this.mTypedArray.getColor(this.mBackgroundColorId, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).backgroundColor(backgroundColor);
        }
        if ((cornerRadius = this.mTypedArray.getDimensionPixelSize(this.mCornerRadiusId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).roundedCornersPx(cornerRadius);
        }
        if ((backgroundContourColor = this.mTypedArray.getColor(this.mBackgroundContourColorId, Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).backgroundContourColor(backgroundContourColor);
        }
        if ((backgroundContourWidth = this.mTypedArray.getDimensionPixelSize(this.mBackgroundContourWidthId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).backgroundContourWidthPx(backgroundContourWidth);
        }
        if (extractOffsets) {
            int offsetX;
            int offsetY = this.mTypedArray.getDimensionPixelSize(this.mOffsetYId, -1);
            if (offsetY != -1) {
                icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).iconOffsetYPx(offsetY);
            }
            if ((offsetX = this.mTypedArray.getDimensionPixelSize(this.mOffsetXId, -1)) != -1) {
                icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).iconOffsetXPx(offsetX);
            }
        }
        if (nonNull) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext);
        }
        return icon;
    }

    @Nullable
    private static IconicsDrawable copyIfCan(@Nullable IconicsDrawable drawable) {
        if (drawable != null) {
            return drawable.clone();
        }
        return null;
    }

    @NonNull
    private static IconicsDrawable createIfNeeds(@Nullable IconicsDrawable drawable, Context context) {
        if (drawable == null) {
            drawable = new IconicsDrawable(context);
        }
        return drawable;
    }
}

