/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.content.Context;
import android.text.TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class GenericsUtil {
    public static String[] getFields(Context ctx) {
        Class rStringClass = GenericsUtil.resolveRClass(ctx.getPackageName());
        if (rStringClass != null) {
            return GenericsUtil.getDefinedFonts(ctx, rStringClass.getFields());
        }
        return new String[0];
    }

    private static Class resolveRClass(String packageName) {
        while (true) {
            try {
                return Class.forName(packageName + ".R$string");
            }
            catch (ClassNotFoundException e) {
                if (!TextUtils.isEmpty((CharSequence)(packageName = packageName.contains(".") ? packageName.substring(0, packageName.lastIndexOf(46)) : ""))) continue;
                return null;
            }
            break;
        }
    }

    private static String[] getDefinedFonts(Context ctx, Field[] fields) {
        ArrayList<String> fieldArray = new ArrayList<String>();
        for (Field field : fields) {
            if (!field.getName().contains("define_font_")) continue;
            fieldArray.add(GenericsUtil.getStringResourceByName(ctx, field.getName()));
        }
        return fieldArray.toArray(new String[fieldArray.size()]);
    }

    private static String getStringResourceByName(Context ctx, String resourceName) {
        String packageName = ctx.getPackageName();
        int resId = ctx.getResources().getIdentifier(resourceName, "string", packageName);
        if (resId == 0) {
            return "";
        }
        return ctx.getString(resId);
    }
}

