/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.widget.TextViewCompat;
import android.util.AttributeSet;
import android.widget.Checkable;
import android.widget.TextView;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.internal.CheckedCompoundIconicsDrawables;
import com.mikepenz.iconics.internal.CompoundIconsBundle;
import com.mikepenz.iconics.internal.IconicsViewsAttrsApplier;
import com.mikepenz.iconics.utils.Utils;
import com.mikepenz.iconics.view.IconicsTextView;

public class IconicsCheckableTextView
extends IconicsTextView
implements Checkable,
CheckedCompoundIconicsDrawables {
    protected CompoundIconsBundle mCheckedIconsBundle;
    private boolean mAnimateChanges;
    private boolean mChecked;
    private boolean mBroadcasting;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public IconicsCheckableTextView(Context context) {
        this(context, null);
    }

    public IconicsCheckableTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public IconicsCheckableTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(Context context, AttributeSet attrs, int defStyle) {
        this.mCheckedIconsBundle = new CompoundIconsBundle();
        this.setFocusable(true);
        this.setClickable(true);
        super.applyAttr(context, attrs, defStyle);
        this.applyAttr(context, attrs, defStyle);
        this.setIcons();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void applyAttr(Context context, AttributeSet attrs, int defStyle) {
        IconicsViewsAttrsApplier.readIconicsCheckableTextView(context, attrs, this.mCheckedIconsBundle);
        this.mAnimateChanges = IconicsViewsAttrsApplier.isIconicsAnimateChanges(context, attrs);
    }

    private void setIcons() {
        TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this, (Drawable)this.createStatesStart(), (Drawable)this.createStatesTop(), (Drawable)this.createStatesEnd(), (Drawable)this.createStatesBottom());
    }

    private StateListDrawable createStatesStart() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mStartIcon, (Drawable)this.mCheckedIconsBundle.mStartIcon, (boolean)this.mAnimateChanges);
    }

    private StateListDrawable createStatesTop() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mTopIcon, (Drawable)this.mCheckedIconsBundle.mTopIcon, (boolean)this.mAnimateChanges);
    }

    private StateListDrawable createStatesEnd() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mEndIcon, (Drawable)this.mCheckedIconsBundle.mEndIcon, (boolean)this.mAnimateChanges);
    }

    private StateListDrawable createStatesBottom() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mBottomIcon, (Drawable)this.mCheckedIconsBundle.mBottomIcon, (boolean)this.mAnimateChanges);
    }

    public CharSequence getAccessibilityClassName() {
        return IconicsCheckableTextView.class.getName();
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
            if (this.mBroadcasting) {
                return;
            }
            this.mBroadcasting = true;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
            this.mBroadcasting = false;
        }
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            IconicsCheckableTextView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public boolean performClick() {
        this.toggle();
        boolean handled = super.performClick();
        if (!handled) {
            this.playSoundEffect(0);
        }
        return handled;
    }

    @Override
    public IconicsDrawable getCheckedIconicsDrawableStart() {
        if (this.mCheckedIconsBundle.mStartIcon != null) {
            return this.mCheckedIconsBundle.mStartIcon;
        }
        return null;
    }

    @Override
    public IconicsDrawable getCheckedIconicsDrawableTop() {
        if (this.mCheckedIconsBundle.mTopIcon != null) {
            return this.mCheckedIconsBundle.mTopIcon;
        }
        return null;
    }

    @Override
    public IconicsDrawable getCheckedIconicsDrawableEnd() {
        if (this.mCheckedIconsBundle.mEndIcon != null) {
            return this.mCheckedIconsBundle.mEndIcon;
        }
        return null;
    }

    @Override
    public IconicsDrawable getCheckedIconicsDrawableBottom() {
        if (this.mCheckedIconsBundle.mBottomIcon != null) {
            return this.mCheckedIconsBundle.mBottomIcon;
        }
        return null;
    }

    @Override
    public void setCheckedDrawableStart(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mStartIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableTop(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mTopIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableEnd(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mEndIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableBottom(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mBottomIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableForAll(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mStartIcon = drawable;
        this.mCheckedIconsBundle.mTopIcon = drawable;
        this.mCheckedIconsBundle.mEndIcon = drawable;
        this.mCheckedIconsBundle.mBottomIcon = drawable;
        this.setIcons();
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(IconicsCheckableTextView var1, boolean var2);
    }
}

